/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.entity.mime;

import java.io.File;
import java.util.Arrays;
import java.util.List;
import org.apache.hc.client5.http.entity.mime.ContentBody;
import org.apache.hc.client5.http.entity.mime.FileBody;
import org.apache.hc.client5.http.entity.mime.FormBodyPart;
import org.apache.hc.client5.http.entity.mime.FormBodyPartBuilder;
import org.apache.hc.client5.http.entity.mime.Header;
import org.apache.hc.client5.http.entity.mime.MimeField;
import org.apache.hc.client5.http.entity.mime.StringBody;
import org.apache.hc.core5.http.ContentType;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestFormBodyPartBuilder {
    @Test
    public void testBuildBodyPartBasics() throws Exception {
        StringBody stringBody = new StringBody("stuff", ContentType.TEXT_PLAIN);
        FormBodyPart bodyPart = FormBodyPartBuilder.create().setName("blah").setBody((ContentBody)stringBody).build();
        Assertions.assertNotNull((Object)bodyPart);
        Assertions.assertEquals((Object)"blah", (Object)bodyPart.getName());
        Assertions.assertEquals((Object)stringBody, (Object)bodyPart.getBody());
        Header header = bodyPart.getHeader();
        Assertions.assertNotNull((Object)header);
        TestFormBodyPartBuilder.assertFields(Arrays.asList(new MimeField("Content-Disposition", "form-data; name=\"blah\""), new MimeField("Content-Type", "text/plain; charset=ISO-8859-1")), header.getFields());
    }

    @Test
    public void testBuildBodyPartMultipleBuilds() throws Exception {
        StringBody stringBody = new StringBody("stuff", ContentType.TEXT_PLAIN);
        FormBodyPartBuilder builder = FormBodyPartBuilder.create();
        FormBodyPart bodyPart1 = builder.setName("blah").setBody((ContentBody)stringBody).build();
        Assertions.assertNotNull((Object)bodyPart1);
        Assertions.assertEquals((Object)"blah", (Object)bodyPart1.getName());
        Assertions.assertEquals((Object)stringBody, (Object)bodyPart1.getBody());
        Header header1 = bodyPart1.getHeader();
        Assertions.assertNotNull((Object)header1);
        TestFormBodyPartBuilder.assertFields(Arrays.asList(new MimeField("Content-Disposition", "form-data; name=\"blah\""), new MimeField("Content-Type", "text/plain; charset=ISO-8859-1")), header1.getFields());
        FileBody fileBody = new FileBody(new File("/path/stuff.bin"), ContentType.DEFAULT_BINARY);
        FormBodyPart bodyPart2 = builder.setName("yada").setBody((ContentBody)fileBody).build();
        Assertions.assertNotNull((Object)bodyPart2);
        Assertions.assertEquals((Object)"yada", (Object)bodyPart2.getName());
        Assertions.assertEquals((Object)fileBody, (Object)bodyPart2.getBody());
        Header header2 = bodyPart2.getHeader();
        Assertions.assertNotNull((Object)header2);
        TestFormBodyPartBuilder.assertFields(Arrays.asList(new MimeField("Content-Disposition", "form-data; name=\"yada\"; filename=\"stuff.bin\""), new MimeField("Content-Type", "application/octet-stream")), header2.getFields());
    }

    @Test
    public void testBuildBodyPartCustomHeaders() throws Exception {
        StringBody stringBody = new StringBody("stuff", ContentType.TEXT_PLAIN);
        FormBodyPartBuilder builder = FormBodyPartBuilder.create((String)"blah", (ContentBody)stringBody);
        FormBodyPart bodyPart1 = builder.addField("header1", "blah").addField("header3", "blah").addField("header3", "blah").addField("header3", "blah").addField("header3", "blah").addField("header3", "blah").build();
        Assertions.assertNotNull((Object)bodyPart1);
        Header header1 = bodyPart1.getHeader();
        Assertions.assertNotNull((Object)header1);
        TestFormBodyPartBuilder.assertFields(Arrays.asList(new MimeField("header1", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("header3", "blah"), new MimeField("Content-Disposition", "form-data; name=\"blah\""), new MimeField("Content-Type", "text/plain; charset=ISO-8859-1")), header1.getFields());
        FormBodyPart bodyPart2 = builder.setField("header2", "yada").removeFields("header3").build();
        Assertions.assertNotNull((Object)bodyPart2);
        Header header2 = bodyPart2.getHeader();
        Assertions.assertNotNull((Object)header2);
        TestFormBodyPartBuilder.assertFields(Arrays.asList(new MimeField("header1", "blah"), new MimeField("header2", "yada"), new MimeField("Content-Disposition", "form-data; name=\"blah\""), new MimeField("Content-Type", "text/plain; charset=ISO-8859-1")), header2.getFields());
        FormBodyPart bodyPart3 = builder.addField("Content-Disposition", "disposition stuff").addField("Content-Type", "type stuff").addField("Content-Transfer-Encoding", "encoding stuff").build();
        Assertions.assertNotNull((Object)bodyPart3);
        Header header3 = bodyPart3.getHeader();
        Assertions.assertNotNull((Object)header3);
        TestFormBodyPartBuilder.assertFields(Arrays.asList(new MimeField("header1", "blah"), new MimeField("header2", "yada"), new MimeField("Content-Disposition", "disposition stuff"), new MimeField("Content-Type", "type stuff"), new MimeField("Content-Transfer-Encoding", "encoding stuff")), header3.getFields());
    }

    private static void assertFields(List<MimeField> expected, List<MimeField> result) {
        Assertions.assertNotNull(result);
        Assertions.assertEquals((int)expected.size(), (int)result.size());
        for (int i = 0; i < expected.size(); ++i) {
            MimeField expectedField = expected.get(i);
            MimeField resultField = result.get(i);
            Assertions.assertNotNull((Object)resultField);
            Assertions.assertEquals((Object)expectedField.getName(), (Object)resultField.getName());
            Assertions.assertEquals((Object)expectedField.getBody(), (Object)resultField.getBody());
        }
    }
}

