/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import javax.net.ssl.SSLContext;
import org.apache.hc.client5.http.ContextBuilder;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SystemDefaultDnsResolver;
import org.apache.hc.client5.http.auth.CredentialsProvider;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.cookie.BasicCookieStore;
import org.apache.hc.client5.http.cookie.CookieStore;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.ManagedHttpClientConnectionFactory;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.socket.PlainConnectionSocketFactory;
import org.apache.hc.client5.http.ssl.SSLConnectionSocketFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.HttpResponseFactory;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.config.CharCodingConfig;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.impl.io.DefaultClassicHttpResponseFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpRequestWriterFactory;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParser;
import org.apache.hc.core5.http.impl.io.DefaultHttpResponseParserFactory;
import org.apache.hc.core5.http.io.HttpMessageParser;
import org.apache.hc.core5.http.io.HttpMessageParserFactory;
import org.apache.hc.core5.http.io.HttpMessageWriterFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicLineParser;
import org.apache.hc.core5.http.message.LineParser;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.pool.PoolConcurrencyPolicy;
import org.apache.hc.core5.pool.PoolReusePolicy;
import org.apache.hc.core5.ssl.SSLContexts;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class ClientConfiguration {
    public static final void main(String[] args) throws Exception {
        DefaultHttpResponseParserFactory responseParserFactory = new DefaultHttpResponseParserFactory(){

            public HttpMessageParser<ClassicHttpResponse> create(Http1Config h1Config) {
                BasicLineParser lineParser = new BasicLineParser(){

                    public Header parseHeader(CharArrayBuffer buffer) {
                        try {
                            return super.parseHeader(buffer);
                        }
                        catch (ParseException ex) {
                            return new BasicHeader(buffer.toString(), null);
                        }
                    }
                };
                return new DefaultHttpResponseParser((LineParser)lineParser, (HttpResponseFactory)DefaultClassicHttpResponseFactory.INSTANCE, h1Config);
            }
        };
        DefaultHttpRequestWriterFactory requestWriterFactory = new DefaultHttpRequestWriterFactory();
        Http1Config h1Config = Http1Config.custom().setMaxHeaderCount(200).setMaxLineLength(2000).build();
        CharCodingConfig connectionConfig = CharCodingConfig.custom().setMalformedInputAction(CodingErrorAction.IGNORE).setUnmappableInputAction(CodingErrorAction.IGNORE).setCharset(StandardCharsets.UTF_8).build();
        ManagedHttpClientConnectionFactory connFactory = new ManagedHttpClientConnectionFactory(h1Config, connectionConfig, (HttpMessageWriterFactory)requestWriterFactory, (HttpMessageParserFactory)responseParserFactory);
        SSLContext sslcontext = SSLContexts.createSystemDefault();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register("https", (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        SystemDefaultDnsResolver dnsResolver = new SystemDefaultDnsResolver(){

            public InetAddress[] resolve(String host) throws UnknownHostException {
                if (host.equalsIgnoreCase("myhost")) {
                    return new InetAddress[]{InetAddress.getByAddress(new byte[]{127, 0, 0, 1})};
                }
                return super.resolve(host);
            }
        };
        PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry, PoolConcurrencyPolicy.STRICT, PoolReusePolicy.LIFO, TimeValue.ofMinutes((long)5L), null, (DnsResolver)dnsResolver, null);
        connManager.setDefaultSocketConfig(SocketConfig.custom().setTcpNoDelay(true).build());
        connManager.setDefaultConnectionConfig(ConnectionConfig.custom().setConnectTimeout(Timeout.ofSeconds((long)30L)).setSocketTimeout(Timeout.ofSeconds((long)30L)).setValidateAfterInactivity(TimeValue.ofSeconds((long)10L)).setTimeToLive(TimeValue.ofHours((long)1L)).build());
        connManager.setDefaultTlsConfig(TlsConfig.custom().setHandshakeTimeout(Timeout.ofSeconds((long)30L)).setSupportedProtocols(new TLS[]{TLS.V_1_3}).build());
        connManager.setMaxTotal(100);
        connManager.setDefaultMaxPerRoute(10);
        connManager.setMaxPerRoute(new HttpRoute(new HttpHost("somehost", 80)), 20);
        BasicCookieStore cookieStore = new BasicCookieStore();
        CredentialsProvider credentialsProvider = CredentialsProviderBuilder.create().build();
        RequestConfig defaultRequestConfig = RequestConfig.custom().setCookieSpec("strict").setExpectContinueEnabled(true).setTargetPreferredAuthSchemes(Arrays.asList("NTLM", "Digest")).setProxyPreferredAuthSchemes(Collections.singletonList("Basic")).build();
        try (CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)connManager).setDefaultCookieStore((CookieStore)cookieStore).setDefaultCredentialsProvider(credentialsProvider).setProxy(new HttpHost("myproxy", 8080)).setDefaultRequestConfig(defaultRequestConfig).build();){
            HttpGet httpget = new HttpGet("http://httpbin.org/get");
            RequestConfig requestConfig = RequestConfig.copy((RequestConfig)defaultRequestConfig).setConnectionRequestTimeout(Timeout.ofSeconds((long)5L)).build();
            httpget.setConfig(requestConfig);
            HttpClientContext context = ContextBuilder.create().useCookieStore((CookieStore)cookieStore).useCredentialsProvider(credentialsProvider).build();
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            httpclient.execute((ClassicHttpRequest)httpget, (HttpContext)context, response -> {
                System.out.println("----------------------------------------");
                System.out.println(httpget + "->" + new StatusLine((HttpResponse)response));
                EntityUtils.consume((HttpEntity)response.getEntity());
                return null;
            });
            context.getRequest();
            context.getHttpRoute();
            context.getAuthExchanges();
            context.getCookieOrigin();
            context.getCookieSpec();
            context.getUserToken();
        }
    }
}

