/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import org.apache.hc.client5.http.ConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultConnectionKeepAliveStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.BasicHttpContext;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultConnKeepAliveStrategy {
    @Test
    public void testIllegalResponseArg() throws Exception {
        BasicHttpContext context = new BasicHttpContext(null);
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        Assertions.assertThrows(NullPointerException.class, () -> TestDefaultConnKeepAliveStrategy.lambda$testIllegalResponseArg$0((ConnectionKeepAliveStrategy)keepAliveStrat, (HttpContext)context));
    }

    @Test
    public void testNoKeepAliveHeader() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setConnectionKeepAlive(TimeValue.NEG_ONE_MILLISECOND).build());
        BasicHttpResponse response = new BasicHttpResponse(200);
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        TimeValue d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)TimeValue.NEG_ONE_MILLISECOND, (Object)d);
    }

    @Test
    public void testEmptyKeepAliveHeader() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setConnectionKeepAlive(TimeValue.NEG_ONE_MILLISECOND).build());
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader("Keep-Alive", (Object)"timeout, max=20");
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        TimeValue d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)TimeValue.NEG_ONE_MILLISECOND, (Object)d);
    }

    @Test
    public void testInvalidKeepAliveHeader() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setConnectionKeepAlive(TimeValue.NEG_ONE_MILLISECOND).build());
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader("Keep-Alive", (Object)"timeout=whatever, max=20");
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        TimeValue d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)TimeValue.NEG_ONE_MILLISECOND, (Object)d);
    }

    @Test
    public void testKeepAliveHeader() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setConnectionKeepAlive(TimeValue.NEG_ONE_MILLISECOND).build());
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader("Keep-Alive", (Object)"timeout=300, max=20");
        DefaultConnectionKeepAliveStrategy keepAliveStrat = new DefaultConnectionKeepAliveStrategy();
        TimeValue d = keepAliveStrat.getKeepAliveDuration((HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)TimeValue.ofSeconds((long)300L), (Object)d);
    }

    private static /* synthetic */ void lambda$testIllegalResponseArg$0(ConnectionKeepAliveStrategy keepAliveStrat, HttpContext context) throws Throwable {
        keepAliveStrat.getKeepAliveDuration(null, context);
    }
}

