/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.net.URI;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.impl.DefaultRedirectStrategy;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.ProtocolException;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDefaultRedirectStrategy {
    @Test
    public void testIsRedirectedMovedTemporary() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assertions.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedMovedTemporaryNoLocation() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedMovedPermanently() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(301, "Redirect");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assertions.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedTemporaryRedirect() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(307, "Redirect");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assertions.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedSeeOther() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(303, "Redirect");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        response.setHeader("Location", (Object)"http://localhost/blah");
        Assertions.assertTrue((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedUnknownStatus() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(333, "Redirect");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context));
        HttpPost httppost = new HttpPost("http://localhost/");
        Assertions.assertFalse((boolean)redirectStrategy.isRedirected((HttpRequest)httppost, (HttpResponse)response, (HttpContext)context));
    }

    @Test
    public void testIsRedirectedInvalidInput() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(303, "Redirect");
        Assertions.assertThrows(NullPointerException.class, () -> TestDefaultRedirectStrategy.lambda$testIsRedirectedInvalidInput$0(redirectStrategy, (HttpResponse)response, context));
        Assertions.assertThrows(NullPointerException.class, () -> redirectStrategy.isRedirected((HttpRequest)httpget, null, (HttpContext)context));
    }

    @Test
    public void testGetLocationUri() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test
    public void testGetLocationUriMissingHeader() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        Assertions.assertThrows(HttpException.class, () -> TestDefaultRedirectStrategy.lambda$testGetLocationUriMissingHeader$2(redirectStrategy, httpget, (HttpResponse)response, context));
    }

    @Test
    public void testGetLocationUriInvalidLocation() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/not valid");
        Assertions.assertThrows(ProtocolException.class, () -> TestDefaultRedirectStrategy.lambda$testGetLocationUriInvalidLocation$3(redirectStrategy, httpget, (HttpResponse)response, context));
    }

    @Test
    public void testGetLocationUriRelative() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"/stuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)URI.create("http://localhost/stuff"), (Object)uri);
    }

    @Test
    public void testGetLocationUriRelativeWithFragment() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"/stuff#fragment");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)URI.create("http://localhost/stuff#fragment"), (Object)uri);
    }

    @Test
    public void testGetLocationUriAbsoluteWithFragment() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/stuff#fragment");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)URI.create("http://localhost/stuff#fragment"), (Object)uri);
    }

    @Test
    public void testGetLocationUriNormalized() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/././stuff/../morestuff");
        URI uri = redirectStrategy.getLocationURI((HttpRequest)httpget, (HttpResponse)response, (HttpContext)context);
        Assertions.assertEquals((Object)URI.create("http://localhost/morestuff"), (Object)uri);
    }

    @Test
    public void testGetLocationUriInvalidInput() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        HttpClientContext context = HttpClientContext.create();
        HttpGet httpget = new HttpGet("http://localhost/");
        BasicHttpResponse response = new BasicHttpResponse(302, "Redirect");
        response.addHeader("Location", (Object)"http://localhost/stuff");
        Assertions.assertThrows(NullPointerException.class, () -> TestDefaultRedirectStrategy.lambda$testGetLocationUriInvalidInput$4(redirectStrategy, (HttpResponse)response, context));
        Assertions.assertThrows(NullPointerException.class, () -> redirectStrategy.getLocationURI((HttpRequest)httpget, null, (HttpContext)context));
        Assertions.assertThrows(NullPointerException.class, () -> TestDefaultRedirectStrategy.lambda$testGetLocationUriInvalidInput$6(redirectStrategy, httpget, (HttpResponse)response));
    }

    @Test
    public void testCreateLocationURI() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        Assertions.assertEquals((Object)"http://blahblah/", (Object)redirectStrategy.createLocationURI("http://BlahBlah").toASCIIString());
    }

    @Test
    public void testCreateLocationURIInvalid() throws Exception {
        DefaultRedirectStrategy redirectStrategy = new DefaultRedirectStrategy();
        Assertions.assertThrows(ProtocolException.class, () -> redirectStrategy.createLocationURI(":::::::"));
    }

    private static /* synthetic */ void lambda$testGetLocationUriInvalidInput$6(DefaultRedirectStrategy redirectStrategy, HttpGet httpget, HttpResponse response) throws Throwable {
        redirectStrategy.getLocationURI((HttpRequest)httpget, response, null);
    }

    private static /* synthetic */ void lambda$testGetLocationUriInvalidInput$4(DefaultRedirectStrategy redirectStrategy, HttpResponse response, HttpClientContext context) throws Throwable {
        redirectStrategy.getLocationURI(null, response, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testGetLocationUriInvalidLocation$3(DefaultRedirectStrategy redirectStrategy, HttpGet httpget, HttpResponse response, HttpClientContext context) throws Throwable {
        redirectStrategy.getLocationURI((HttpRequest)httpget, response, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testGetLocationUriMissingHeader$2(DefaultRedirectStrategy redirectStrategy, HttpGet httpget, HttpResponse response, HttpClientContext context) throws Throwable {
        redirectStrategy.getLocationURI((HttpRequest)httpget, response, (HttpContext)context);
    }

    private static /* synthetic */ void lambda$testIsRedirectedInvalidInput$0(DefaultRedirectStrategy redirectStrategy, HttpResponse response, HttpClientContext context) throws Throwable {
        redirectStrategy.isRedirected(null, response, (HttpContext)context);
    }
}

