/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import java.util.List;
import org.apache.hc.client5.http.NameValuePairMatcher;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.impl.auth.AuthChallengeParser;
import org.apache.hc.core5.http.ParseException;
import org.apache.hc.core5.http.message.ParserCursor;
import org.apache.hc.core5.util.CharArrayBuffer;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestAuthChallengeParser {
    private AuthChallengeParser parser;

    @BeforeEach
    public void setUp() throws Exception {
        this.parser = new AuthChallengeParser();
    }

    @Test
    public void testParseTokenTerminatedByBlank() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
    }

    @Test
    public void testParseTokenTerminatedByComma() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc, ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
    }

    @Test
    public void testParseTokenTerminatedByEndOfStream() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
    }

    @Test
    public void testParsePaddedToken68() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc==== ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc===="));
        MatcherAssert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)Character.valueOf(buffer.charAt(cursor.getPos())), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf(' ')));
    }

    @Test
    public void testParsePaddedToken68SingleEqual() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc=");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc="));
        MatcherAssert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testParsePaddedToken68MultipleEquals() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(16);
        buffer.append("aaabbbbccc======");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc======"));
        MatcherAssert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)true));
    }

    @Test
    public void testParsePaddedToken68TerminatedByComma() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc====,");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc===="));
        MatcherAssert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)Character.valueOf(buffer.charAt(cursor.getPos())), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf(',')));
    }

    @Test
    public void testParseTokenTerminatedByParameter() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("aaabbbbccc=blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        MatcherAssert.assertThat((Object)this.parser.parseToken((CharSequence)buffer, cursor), (Matcher)CoreMatchers.equalTo((Object)"aaabbbbccc"));
        MatcherAssert.assertThat((Object)cursor.atEnd(), (Matcher)CoreMatchers.equalTo((Object)false));
        MatcherAssert.assertThat((Object)Character.valueOf(buffer.charAt(cursor.getPos())), (Matcher)CoreMatchers.equalTo((Object)Character.valueOf('=')));
    }

    @Test
    public void testParseBasicAuthChallenge() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("Basic realm=blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)1, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
        List params = challenge1.getParams();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)1, (int)params.size());
        MatcherAssert.assertThat(params.get(0), NameValuePairMatcher.equals("realm", "blah"));
    }

    @Test
    public void testParseAuthChallengeWithBlanks() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("   Basic  realm = blah   ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)1, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
        List params = challenge1.getParams();
        Assertions.assertNotNull((Object)params);
        Assertions.assertEquals((int)1, (int)params.size());
        MatcherAssert.assertThat(params.get(0), NameValuePairMatcher.equals("realm", "blah"));
    }

    @Test
    public void testParseMultipleAuthChallenge() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This  xxxxxxxxxxxxxxxxxxxxxx, That yyyyyyyyyyyyyyyyyyyyyy  ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)2, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"This", (Object)challenge1.getSchemeName());
        Assertions.assertEquals((Object)"xxxxxxxxxxxxxxxxxxxxxx", (Object)challenge1.getValue());
        Assertions.assertNull((Object)challenge1.getParams());
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assertions.assertEquals((Object)"That", (Object)challenge2.getSchemeName());
        Assertions.assertEquals((Object)"yyyyyyyyyyyyyyyyyyyyyy", (Object)challenge2.getValue());
        Assertions.assertNull((Object)challenge2.getParams());
    }

    @Test
    public void testParseMultipleAuthChallengeWithParams() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("Basic realm=blah, param1 = this, param2=that, Basic realm=\"\\\"yada\\\"\", this, that=,this-and-that  ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)2, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
        List params1 = challenge1.getParams();
        Assertions.assertNotNull((Object)params1);
        Assertions.assertEquals((int)3, (int)params1.size());
        MatcherAssert.assertThat(params1.get(0), NameValuePairMatcher.equals("realm", "blah"));
        MatcherAssert.assertThat(params1.get(1), NameValuePairMatcher.equals("param1", "this"));
        MatcherAssert.assertThat(params1.get(2), NameValuePairMatcher.equals("param2", "that"));
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assertions.assertEquals((Object)"Basic", (Object)challenge2.getSchemeName());
        Assertions.assertNull((Object)challenge2.getValue());
        List params2 = challenge2.getParams();
        Assertions.assertNotNull((Object)params2);
        Assertions.assertEquals((int)4, (int)params2.size());
        MatcherAssert.assertThat(params2.get(0), NameValuePairMatcher.equals("realm", "\"yada\""));
        MatcherAssert.assertThat(params2.get(1), NameValuePairMatcher.equals("this", null));
        MatcherAssert.assertThat(params2.get(2), NameValuePairMatcher.equals("that", ""));
        MatcherAssert.assertThat(params2.get(3), NameValuePairMatcher.equals("this-and-that", null));
    }

    @Test
    public void testParseMultipleAuthChallengeWithParamsContainingComma() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("Basic realm=blah, param1 = \"this, param2=that\", Basic realm=\"\\\"yada,,,,\\\"\"");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)2, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"Basic", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
        List params1 = challenge1.getParams();
        Assertions.assertNotNull((Object)params1);
        Assertions.assertEquals((int)2, (int)params1.size());
        MatcherAssert.assertThat(params1.get(0), NameValuePairMatcher.equals("realm", "blah"));
        MatcherAssert.assertThat(params1.get(1), NameValuePairMatcher.equals("param1", "this, param2=that"));
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        Assertions.assertEquals((Object)"Basic", (Object)challenge2.getSchemeName());
        Assertions.assertNull((Object)challenge2.getValue());
        List params2 = challenge2.getParams();
        Assertions.assertNotNull((Object)params2);
        Assertions.assertEquals((int)1, (int)params2.size());
        MatcherAssert.assertThat(params2.get(0), NameValuePairMatcher.equals("realm", "\"yada,,,,\""));
    }

    @Test
    public void testParseEmptyAuthChallenge1() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)1, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"This", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
        Assertions.assertNull((Object)challenge1.getParams());
    }

    @Test
    public void testParseMalformedAuthChallenge1() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This , ");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor));
    }

    @Test
    public void testParseMalformedAuthChallenge2() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("This = that");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor));
    }

    @Test
    public void testParseMalformedAuthChallenge3() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("blah blah blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        Assertions.assertThrows(ParseException.class, () -> this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor));
    }

    @Test
    public void testParseValidAuthChallenge1() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("blah blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)1, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"blah", (Object)challenge1.getSchemeName());
        Assertions.assertEquals((Object)"blah", (Object)challenge1.getValue());
        Assertions.assertNull((Object)challenge1.getParams());
    }

    @Test
    public void testParseValidAuthChallenge2() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("blah blah, blah");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)1, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"blah", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
        List params1 = challenge1.getParams();
        Assertions.assertNotNull((Object)params1);
        Assertions.assertEquals((int)2, (int)params1.size());
        MatcherAssert.assertThat(params1.get(0), NameValuePairMatcher.equals("blah", null));
        MatcherAssert.assertThat(params1.get(1), NameValuePairMatcher.equals("blah", null));
    }

    @Test
    public void testParseEmptyNTLMAuthChallenge() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("NTLM");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)1, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        Assertions.assertEquals((Object)"NTLM", (Object)challenge1.getSchemeName());
        Assertions.assertNull((Object)challenge1.getValue());
    }

    @Test
    public void testParseParameterAndToken68AuthChallengeMix() throws Exception {
        CharArrayBuffer buffer = new CharArrayBuffer(64);
        buffer.append("scheme1 aaaa  , scheme2 aaaa==,  scheme3 aaaa=aaaa, scheme4 aaaa=");
        ParserCursor cursor = new ParserCursor(0, buffer.length());
        List challenges = this.parser.parse(ChallengeType.TARGET, (CharSequence)buffer, cursor);
        Assertions.assertNotNull((Object)challenges);
        Assertions.assertEquals((int)4, (int)challenges.size());
        AuthChallenge challenge1 = (AuthChallenge)challenges.get(0);
        MatcherAssert.assertThat((Object)challenge1.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme1"));
        MatcherAssert.assertThat((Object)challenge1.getValue(), (Matcher)CoreMatchers.equalTo((Object)"aaaa"));
        MatcherAssert.assertThat((Object)challenge1.getParams(), (Matcher)CoreMatchers.nullValue());
        AuthChallenge challenge2 = (AuthChallenge)challenges.get(1);
        MatcherAssert.assertThat((Object)challenge2.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme2"));
        MatcherAssert.assertThat((Object)challenge2.getValue(), (Matcher)CoreMatchers.equalTo((Object)"aaaa=="));
        MatcherAssert.assertThat((Object)challenge2.getParams(), (Matcher)CoreMatchers.nullValue());
        AuthChallenge challenge3 = (AuthChallenge)challenges.get(2);
        MatcherAssert.assertThat((Object)challenge3.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme3"));
        MatcherAssert.assertThat((Object)challenge3.getValue(), (Matcher)CoreMatchers.nullValue());
        MatcherAssert.assertThat((Object)challenge3.getParams(), (Matcher)CoreMatchers.notNullValue());
        MatcherAssert.assertThat((Object)challenge3.getParams().size(), (Matcher)CoreMatchers.equalTo((Object)1));
        MatcherAssert.assertThat(challenge3.getParams().get(0), NameValuePairMatcher.equals("aaaa", "aaaa"));
        AuthChallenge challenge4 = (AuthChallenge)challenges.get(3);
        MatcherAssert.assertThat((Object)challenge4.getSchemeName(), (Matcher)CoreMatchers.equalTo((Object)"scheme4"));
        MatcherAssert.assertThat((Object)challenge4.getValue(), (Matcher)CoreMatchers.equalTo((Object)"aaaa="));
        MatcherAssert.assertThat((Object)challenge4.getParams(), (Matcher)CoreMatchers.nullValue());
    }
}

