/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.CloseableHttpResponse;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;

public class TestCloseableHttpClient {
    private NoopCloseableHttpClient client;
    private InputStream content;
    private HttpEntity entity;
    private ClassicHttpResponse originResponse;
    private CloseableHttpResponse response;

    @BeforeEach
    public void setup() throws Exception {
        this.content = (InputStream)Mockito.mock(InputStream.class);
        this.entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        this.originResponse = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        this.response = CloseableHttpResponse.adapt((ClassicHttpResponse)this.originResponse);
        Mockito.when((Object)this.entity.getContent()).thenReturn((Object)this.content);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.response.getEntity()).thenReturn((Object)this.entity);
        this.client = (NoopCloseableHttpClient)((Object)Mockito.mock(NoopCloseableHttpClient.class, (Answer)Mockito.CALLS_REAL_METHODS));
    }

    @Test
    public void testExecuteRequestAbsoluteURI() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute((HttpHost)Mockito.any(), (ClassicHttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.response);
        this.client.execute((ClassicHttpRequest)httpget, response -> null);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("https", "somehost", 444)), (ClassicHttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
    }

    @Test
    public void testExecuteRequestRelativeURI() throws Exception {
        HttpGet httpget = new HttpGet("/stuff");
        Mockito.when((Object)this.client.doExecute((HttpHost)Mockito.any(), (ClassicHttpRequest)Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.response);
        this.client.execute((ClassicHttpRequest)httpget, response -> null);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.isNull(), (ClassicHttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
    }

    @Test
    public void testExecuteRequestHandleResponse() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("https", "somehost", 444), (ClassicHttpRequest)httpget, null)).thenReturn((Object)this.response);
        HttpClientResponseHandler handler = (HttpClientResponseHandler)Mockito.mock(HttpClientResponseHandler.class);
        this.client.execute((ClassicHttpRequest)httpget, handler);
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("https", "somehost", 444)), (ClassicHttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
        ((HttpClientResponseHandler)Mockito.verify((Object)handler)).handleResponse((ClassicHttpResponse)this.response);
        ((InputStream)Mockito.verify((Object)this.content)).close();
    }

    @Test
    public void testExecuteRequestHandleResponseIOException() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("https", "somehost", 444), (ClassicHttpRequest)httpget, null)).thenReturn((Object)this.response);
        HttpClientResponseHandler handler = (HttpClientResponseHandler)Mockito.mock(HttpClientResponseHandler.class);
        Mockito.when((Object)handler.handleResponse((ClassicHttpResponse)this.response)).thenThrow(new Throwable[]{new IOException()});
        Assertions.assertThrows(IOException.class, () -> {
            HttpResponse cfr_ignored_0 = (HttpResponse)this.client.execute((ClassicHttpRequest)httpget, handler);
        });
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("https", "somehost", 444)), (ClassicHttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
        ((ClassicHttpResponse)Mockito.verify((Object)this.originResponse)).close();
    }

    @Test
    public void testExecuteRequestHandleResponseHttpException() throws Exception {
        HttpGet httpget = new HttpGet("https://somehost:444/stuff");
        Mockito.when((Object)this.client.doExecute(new HttpHost("https", "somehost", 444), (ClassicHttpRequest)httpget, null)).thenReturn((Object)this.response);
        HttpClientResponseHandler handler = (HttpClientResponseHandler)Mockito.mock(HttpClientResponseHandler.class);
        Mockito.when((Object)handler.handleResponse((ClassicHttpResponse)this.response)).thenThrow(new Throwable[]{new RuntimeException()});
        Assertions.assertThrows(RuntimeException.class, () -> {
            HttpResponse cfr_ignored_0 = (HttpResponse)this.client.execute((ClassicHttpRequest)httpget, handler);
        });
        ((NoopCloseableHttpClient)((Object)Mockito.verify((Object)((Object)this.client)))).doExecute((HttpHost)Mockito.eq((Object)new HttpHost("https", "somehost", 444)), (ClassicHttpRequest)Mockito.same((Object)httpget), (HttpContext)Mockito.isNull());
        ((ClassicHttpResponse)Mockito.verify((Object)this.originResponse)).close();
    }

    static abstract class NoopCloseableHttpClient
    extends CloseableHttpClient {
        NoopCloseableHttpClient() {
        }

        protected CloseableHttpResponse doExecute(HttpHost target, ClassicHttpRequest request, HttpContext context) throws IOException {
            return null;
        }
    }
}

