/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.hc.client5.http.HttpRequestRetryStrategy;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.classic.ExecChain;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.classic.methods.HttpPost;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.entity.EntityBuilder;
import org.apache.hc.client5.http.impl.classic.HttpRequestRetryExec;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class TestHttpRequestRetryExec {
    @Mock
    private HttpRequestRetryStrategy retryStrategy;
    @Mock
    private ExecChain chain;
    @Mock
    private ExecRuntime endpoint;
    @Mock
    private TimeValue nextInterval;
    private HttpRequestRetryExec retryExec;
    private HttpHost target;

    @BeforeEach
    public void setup() throws Exception {
        MockitoAnnotations.openMocks((Object)this);
        this.retryExec = new HttpRequestRetryExec(this.retryStrategy);
        this.target = new HttpHost("localhost", 80);
    }

    @Test
    public void testFundamentals1() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.retryStrategy.getRetryInterval((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ZERO_MILLISECONDS);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.retryExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.same((Object)scope));
        ((ClassicHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testRetrySleepOnIOException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpRequest)Mockito.any(), (IOException)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.retryStrategy.getRetryInterval((HttpRequest)Mockito.any(), (IOException)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)this.nextInterval);
        Mockito.when((Object)this.nextInterval.getDuration()).thenReturn((Object)100L);
        Mockito.when((Object)this.nextInterval.compareTo((TimeValue)Mockito.any())).thenReturn((Object)-1);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.retryExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.same((Object)scope));
        ((TimeValue)Mockito.verify((Object)this.nextInterval, (VerificationMode)Mockito.times((int)1))).sleep();
    }

    @Test
    public void testRetryIntervalGreaterResponseTimeout() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setResponseTimeout(Timeout.ofSeconds((long)3L)).build());
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.retryStrategy.getRetryInterval((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ofSeconds((long)5L));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.retryExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.same((Object)scope));
        ((ClassicHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).close();
    }

    @Test
    public void testRetryIntervalResponseTimeoutNull() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        context.setRequestConfig(RequestConfig.custom().setResponseTimeout(null).build());
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.retryStrategy.getRetryInterval((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any())).thenReturn((Object)TimeValue.ofSeconds((long)1L));
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        this.retryExec.execute((ClassicHttpRequest)request, scope, this.chain);
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.same((Object)scope));
        ((ClassicHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)1))).close();
    }

    @Test
    public void testStrategyRuntimeException() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet request = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ((HttpRequestRetryStrategy)Mockito.doThrow((Throwable[])new Throwable[]{new RuntimeException("Ooopsie")}).when((Object)this.retryStrategy)).retryRequest((HttpResponse)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any());
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        Assertions.assertThrows(RuntimeException.class, () -> this.lambda$testStrategyRuntimeException$0((ClassicHttpRequest)request, scope));
        ((ClassicHttpResponse)Mockito.verify((Object)response)).close();
    }

    @Test
    public void testNonRepeatableEntityResponseReturnedImmediately() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpPost request = new HttpPost("/test");
        request.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        HttpClientContext context = HttpClientContext.create();
        ClassicHttpResponse response = (ClassicHttpResponse)Mockito.mock(ClassicHttpResponse.class);
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenReturn((Object)response);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)request, this.endpoint, context);
        ClassicHttpResponse finalResponse = this.retryExec.execute((ClassicHttpRequest)request, scope, this.chain);
        Assertions.assertSame((Object)response, (Object)finalResponse);
        ((ClassicHttpResponse)Mockito.verify((Object)response, (VerificationMode)Mockito.times((int)0))).close();
    }

    @Test
    public void testFundamentals2() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet originalRequest = new HttpGet("/test");
        originalRequest.addHeader("header", (Object)"this");
        originalRequest.addHeader("header", (Object)"that");
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            ClassicHttpRequest wrapper = (ClassicHttpRequest)args[0];
            Header[] headers = wrapper.getHeaders();
            Assertions.assertEquals((int)2, (int)headers.length);
            Assertions.assertEquals((Object)"this", (Object)headers[0].getValue());
            Assertions.assertEquals((Object)"that", (Object)headers[1].getValue());
            wrapper.addHeader("Cookie", (Object)"monster");
            throw new IOException("Ka-boom");
        });
        Mockito.when((Object)this.retryStrategy.retryRequest((HttpRequest)Mockito.any(), (IOException)Mockito.any(), Mockito.eq((int)1), (HttpContext)Mockito.any())).thenReturn((Object)Boolean.TRUE);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)originalRequest, this.endpoint, context);
        ClassicHttpRequest request = ClassicRequestBuilder.copy((ClassicHttpRequest)originalRequest).build();
        Assertions.assertThrows(IOException.class, () -> this.retryExec.execute(request, scope, this.chain));
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)2))).proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.same((Object)scope));
    }

    @Test
    public void testAbortedRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpGet originalRequest = new HttpGet("/test");
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenThrow(new Throwable[]{new IOException("Ka-boom")});
        Mockito.when((Object)this.endpoint.isExecutionAborted()).thenReturn((Object)true);
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)originalRequest, this.endpoint, context);
        ClassicHttpRequest request = ClassicRequestBuilder.copy((ClassicHttpRequest)originalRequest).build();
        Assertions.assertThrows(IOException.class, () -> this.retryExec.execute(request, scope, this.chain));
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.same((Object)scope));
        ((HttpRequestRetryStrategy)Mockito.verify((Object)this.retryStrategy, (VerificationMode)Mockito.never())).retryRequest((HttpRequest)Mockito.any(), (IOException)Mockito.any(), Mockito.anyInt(), (HttpContext)Mockito.any());
    }

    @Test
    public void testNonRepeatableRequest() throws Exception {
        HttpRoute route = new HttpRoute(this.target);
        HttpPost originalRequest = new HttpPost("/test");
        originalRequest.setEntity(EntityBuilder.create().setStream((InputStream)new ByteArrayInputStream(new byte[0])).build());
        HttpClientContext context = HttpClientContext.create();
        Mockito.when((Object)this.chain.proceed((ClassicHttpRequest)Mockito.any(), (ExecChain.Scope)Mockito.any())).thenAnswer(invocationOnMock -> {
            Object[] args = invocationOnMock.getArguments();
            ClassicHttpRequest req = (ClassicHttpRequest)args[0];
            req.getEntity().writeTo((OutputStream)new ByteArrayOutputStream());
            throw new IOException("Ka-boom");
        });
        ExecChain.Scope scope = new ExecChain.Scope("test", route, (ClassicHttpRequest)originalRequest, this.endpoint, context);
        ClassicHttpRequest request = ClassicRequestBuilder.copy((ClassicHttpRequest)originalRequest).build();
        Assertions.assertThrows(IOException.class, () -> this.retryExec.execute(request, scope, this.chain));
        ((ExecChain)Mockito.verify((Object)this.chain, (VerificationMode)Mockito.times((int)1))).proceed((ClassicHttpRequest)Mockito.same((Object)request), (ExecChain.Scope)Mockito.same((Object)scope));
    }

    private /* synthetic */ void lambda$testStrategyRuntimeException$0(ClassicHttpRequest request, ExecChain.Scope scope) throws Throwable {
        this.retryExec.execute(request, scope, this.chain);
    }
}

