/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.temporal.ChronoField;
import org.apache.hc.client5.http.cookie.CookieAttributeHandler;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.cookie.LaxExpiresHandler;
import org.apache.hc.client5.http.impl.cookie.LaxMaxAgeHandler;
import org.apache.hc.client5.http.utils.DateUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestLaxCookieAttribHandlers {
    @Test
    public void testParseMaxAge() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = LaxMaxAgeHandler.INSTANCE;
        h.parse((SetCookie)cookie, "2000");
        Assertions.assertNotNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testParseMaxNegative() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = LaxMaxAgeHandler.INSTANCE;
        h.parse((SetCookie)cookie, "-2000");
        Assertions.assertNotNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testParseMaxZero() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = LaxMaxAgeHandler.INSTANCE;
        h.parse((SetCookie)cookie, "0000");
        Assertions.assertNotNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testBasicMaxAgeParseEmpty() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = LaxMaxAgeHandler.INSTANCE;
        h.parse((SetCookie)cookie, "  ");
        Assertions.assertNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testBasicMaxAgeParseInvalid() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxMaxAgeHandler h = LaxMaxAgeHandler.INSTANCE;
        h.parse((SetCookie)cookie, "garbage");
        Assertions.assertNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testBasicMaxAgeInvalidInput() throws Exception {
        LaxMaxAgeHandler h = LaxMaxAgeHandler.INSTANCE;
        Assertions.assertThrows(NullPointerException.class, () -> TestLaxCookieAttribHandlers.lambda$testBasicMaxAgeInvalidInput$0((CookieAttributeHandler)h));
    }

    @Test
    public void testExpiryGarbage() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testExpiryGarbage$1((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiry() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "1:0:12 8-jan-2012");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2012, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)8, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)12, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryInstant() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "1:0:12 8-jan-2012");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2012, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)8, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)12, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryInvalidTime0() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, null);
        Assertions.assertNull((Object)cookie.getExpiryInstant());
    }

    @Test
    public void testParseExpiryInvalidTime1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidTime1$2((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidTime2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidTime2$3((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidTime3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidTime3$4((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidTime4() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidTime4$5((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryFunnyTime() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "1:59:00blah; 8-feb-2000");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2000, (int)expiryDate.get(ChronoField.YEAR_OF_ERA));
        Assertions.assertEquals((int)2, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)8, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryFunnyTimeInstant() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "1:59:00blah; 8-feb-2000");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2000, (int)expiryDate.get(ChronoField.YEAR_OF_ERA));
        Assertions.assertEquals((int)2, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)8, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryInvalidDayOfMonth1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidDayOfMonth1$6((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidDayOfMonth2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidDayOfMonth2$7((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidDayOfMonth3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidDayOfMonth3$8((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryFunnyDayOfMonth() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "12:00:00 8blah;mar;1880");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)1880, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)3, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)8, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)12, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryFunnyDayOfMonthInstant() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "12:00:00 8blah;mar;1880");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)1880, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)3, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)8, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)12, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryInvalidMonth() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidMonth$9((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryFunnyMonth() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-ApriLLLLL-2008");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2008, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)4, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)23, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryFunnyMonthInstant() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-ApriLLLLL-2008");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2008, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)4, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)23, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryInvalidYearTooShort() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidYearTooShort$10((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidYearTooLong() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidYearTooLong$11((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryInvalidYearTooLongAgo() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        Assertions.assertThrows(MalformedCookieException.class, () -> TestLaxCookieAttribHandlers.lambda$testParseExpiryInvalidYearTooLongAgo$12((CookieAttributeHandler)h, cookie));
    }

    @Test
    public void testParseExpiryFunnyYear() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-2008blah");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2008, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)4, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)23, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryFunnyYearInstant() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-2008blah");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2008, (int)expiryDate.get(ChronoField.YEAR));
        Assertions.assertEquals((int)4, (int)expiryDate.get(ChronoField.MONTH_OF_YEAR));
        Assertions.assertEquals((int)1, (int)expiryDate.get(ChronoField.DAY_OF_MONTH));
        Assertions.assertEquals((int)23, (int)expiryDate.get(ChronoField.HOUR_OF_DAY));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.MINUTE_OF_HOUR));
        Assertions.assertEquals((int)59, (int)expiryDate.get(ChronoField.SECOND_OF_MINUTE));
        Assertions.assertEquals((int)0, (int)expiryDate.get(ChronoField.MILLI_OF_SECOND));
    }

    @Test
    public void testParseExpiryYearTwoDigit1() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-70");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)1970, (int)expiryDate.get(ChronoField.YEAR));
    }

    @Test
    public void testParseExpiryYearTwoDigit2() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-99");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)1999, (int)expiryDate.get(ChronoField.YEAR));
    }

    @Test
    public void testParseExpiryYearTwoDigit3() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        LaxExpiresHandler h = LaxExpiresHandler.INSTANCE;
        h.parse((SetCookie)cookie, "23:59:59; 1-Apr-00");
        LocalDateTime expiryDate = DateUtils.toUTC((Instant)cookie.getExpiryInstant());
        Assertions.assertNotNull((Object)expiryDate);
        Assertions.assertEquals((int)2000, (int)expiryDate.get(ChronoField.YEAR));
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidYearTooLongAgo$12(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "1:00:00 8 dec 1600");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidYearTooLong$11(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "1:00:00 8 dec 88888");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidYearTooShort$10(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "1:00:00 8 dec 8");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidMonth$9(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "1:00:00 8 dek 80");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidDayOfMonth3$8(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "12:00:00 32 mar 1880");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidDayOfMonth2$7(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "12:00:00 0 mar 1880");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidDayOfMonth1$6(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "12:00:00 888 mar 1880");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidTime4$5(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "23:00:60 8 dec 1980");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidTime3$4(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "23:60:00 8 dec 1980");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidTime2$3(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "24:00:00 8 dec 1980");
    }

    private static /* synthetic */ void lambda$testParseExpiryInvalidTime1$2(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, "1:0:122 8 dec 1980");
    }

    private static /* synthetic */ void lambda$testExpiryGarbage$1(CookieAttributeHandler h, BasicClientCookie cookie) throws Throwable {
        h.parse((SetCookie)cookie, ";;blah,blah;yada  ");
    }

    private static /* synthetic */ void lambda$testBasicMaxAgeInvalidInput$0(CookieAttributeHandler h) throws Throwable {
        h.parse(null, "stuff");
    }
}

