/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.cookie;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.hc.client5.http.cookie.CommonCookieAttributeHandler;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookieOrigin;
import org.apache.hc.client5.http.cookie.MalformedCookieException;
import org.apache.hc.client5.http.cookie.SetCookie;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.apache.hc.client5.http.impl.cookie.RFC6265CookieSpec;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.message.BasicHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestRFC6265CookieSpec {
    @Test
    public void testParseCookieBasics() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"name", (Object)cookie.getName());
        Assertions.assertEquals((Object)"value", (Object)cookie.getValue());
        Assertions.assertEquals((Object)"/path", (Object)cookie.getPath());
        Assertions.assertEquals((Object)"host", (Object)cookie.getDomain());
        Assertions.assertEquals((Object)"stuff", (Object)cookie.getAttribute("this"));
        Assertions.assertNull((Object)cookie.getAttribute("that"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).parse((SetCookie)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"stuff"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2, (VerificationMode)Mockito.never())).parse((SetCookie)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test
    public void testParseCookieQuotedValue() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = \" one, two, three; four \" ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"name", (Object)cookie.getName());
        Assertions.assertEquals((Object)" one, two, three; four ", (Object)cookie.getValue());
        Assertions.assertEquals((Object)"stuff", (Object)cookie.getAttribute("this"));
    }

    @Test
    public void testParseCookieWrongHeader() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie2", (Object)"blah");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        Assertions.assertThrows(MalformedCookieException.class, () -> TestRFC6265CookieSpec.lambda$testParseCookieWrongHeader$0(cookiespec, (Header)header, origin));
    }

    @Test
    public void testParseCookieMissingName() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"=blah ; this = stuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testParseCookieMissingValue1() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"blah");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)0, (int)cookies.size());
    }

    @Test
    public void testParseCookieMissingValue2() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"blah;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        Assertions.assertThrows(MalformedCookieException.class, () -> TestRFC6265CookieSpec.lambda$testParseCookieMissingValue2$1(cookiespec, (Header)header, origin));
    }

    @Test
    public void testParseCookieEmptyValue() throws Exception {
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"blah=;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"blah", (Object)cookie.getName());
        Assertions.assertEquals((Object)"", (Object)cookie.getValue());
    }

    @Test
    public void testParseCookieWithAttributes() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; p1 = v ; p2 = v,0; p3 ; p4");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"name", (Object)cookie.getName());
        Assertions.assertEquals((Object)"value", (Object)cookie.getValue());
        Assertions.assertEquals((Object)"v", (Object)cookie.getAttribute("p1"));
        Assertions.assertEquals((Object)"v,0", (Object)cookie.getAttribute("p2"));
        Assertions.assertTrue((boolean)cookie.containsAttribute("p3"));
        Assertions.assertTrue((boolean)cookie.containsAttribute("p4"));
        Assertions.assertFalse((boolean)cookie.containsAttribute("p5"));
    }

    @Test
    public void testParseCookieWithAttributes2() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; p1 = v");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"name", (Object)cookie.getName());
        Assertions.assertEquals((Object)"value", (Object)cookie.getValue());
        Assertions.assertEquals((Object)"v", (Object)cookie.getAttribute("p1"));
    }

    @Test
    public void testParseCookieWithAttributes3() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; p1 =");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        List cookies = cookiespec.parse((Header)header, origin);
        Assertions.assertEquals((int)1, (int)cookies.size());
        Cookie cookie = (Cookie)cookies.get(0);
        Assertions.assertEquals((Object)"name", (Object)cookie.getName());
        Assertions.assertEquals((Object)"value", (Object)cookie.getValue());
        Assertions.assertEquals((Object)"", (Object)cookie.getAttribute("p1"));
    }

    @Test
    public void testValidateCookieBasics() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookiespec.validate((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).validate((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).validate((Cookie)cookie, origin);
    }

    @Test
    public void testMatchCookie() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Mockito.when((Object)h1.match((Cookie)cookie, origin)).thenReturn((Object)true);
        Mockito.when((Object)h2.match((Cookie)cookie, origin)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).match((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).match((Cookie)cookie, origin);
    }

    @Test
    public void testMatchCookieNoMatch() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"that");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        Mockito.when((Object)h1.match((Cookie)cookie, origin)).thenReturn((Object)false);
        Mockito.when((Object)h2.match((Cookie)cookie, origin)).thenReturn((Object)false);
        Assertions.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).match((Cookie)cookie, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2, (VerificationMode)Mockito.never())).match((Cookie)cookie, origin);
    }

    @Test
    public void testFormatCookiesBasics() throws Exception {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        List headers = cookiespec.formatCookies(Collections.singletonList(cookie1));
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)1, (int)headers.size());
        Header header = (Header)headers.get(0);
        Assertions.assertEquals((Object)"Cookie", (Object)header.getName());
        Assertions.assertEquals((Object)"name1=value", (Object)header.getValue());
    }

    @Test
    public void testFormatCookiesIllegalCharsInValue() throws Exception {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        BasicClientCookie cookie2 = new BasicClientCookie("name2", "some value");
        BasicClientCookie cookie3 = new BasicClientCookie("name3", "\"\\\"");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[0]);
        List headers = cookiespec.formatCookies(Arrays.asList(cookie1, cookie2, cookie3));
        Assertions.assertNotNull((Object)headers);
        Assertions.assertEquals((int)1, (int)headers.size());
        Header header = (Header)headers.get(0);
        Assertions.assertEquals((Object)"Cookie", (Object)header.getName());
        Assertions.assertEquals((Object)"name1=value; name2=\"some value\"; name3=\"\\\"\\\\\\\"\"", (Object)header.getValue());
    }

    @Test
    public void testParseCookieMultipleAttributes() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"this");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; this = stuff; this = morestuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1)).parse((SetCookie)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"morestuff"));
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1, (VerificationMode)Mockito.times((int)1))).parse((SetCookie)ArgumentMatchers.any(), ArgumentMatchers.anyString());
    }

    @Test
    public void testParseCookieMaxAgeOverExpires() throws Exception {
        CommonCookieAttributeHandler h1 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h1.getAttributeName()).thenReturn((Object)"Expires");
        CommonCookieAttributeHandler h2 = (CommonCookieAttributeHandler)Mockito.mock(CommonCookieAttributeHandler.class);
        Mockito.when((Object)h2.getAttributeName()).thenReturn((Object)"Max-Age");
        RFC6265CookieSpec cookiespec = new RFC6265CookieSpec(new CommonCookieAttributeHandler[]{h1, h2});
        BasicHeader header = new BasicHeader("Set-Cookie", (Object)"name = value ; expires = stuff; max-age = otherstuff;");
        CookieOrigin origin = new CookieOrigin("host", 80, "/path/", true);
        cookiespec.parse((Header)header, origin);
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h1, (VerificationMode)Mockito.never())).parse((SetCookie)ArgumentMatchers.any(), ArgumentMatchers.anyString());
        ((CommonCookieAttributeHandler)Mockito.verify((Object)h2)).parse((SetCookie)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"otherstuff"));
    }

    private static /* synthetic */ void lambda$testParseCookieMissingValue2$1(RFC6265CookieSpec cookiespec, Header header, CookieOrigin origin) throws Throwable {
        cookiespec.parse(header, origin);
    }

    private static /* synthetic */ void lambda$testParseCookieWrongHeader$0(RFC6265CookieSpec cookiespec, Header header, CookieOrigin origin) throws Throwable {
        cookiespec.parse(header, origin);
    }
}

