/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.routing;

import java.net.InetAddress;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.impl.routing.BasicRouteDirector;
import org.apache.hc.client5.http.routing.HttpRouteDirector;
import org.apache.hc.core5.http.HttpHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestRouteDirector {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid", 80);
    public static final HttpHost TARGET2 = new HttpHost("target2.test.invalid", 8080);
    public static final HttpHost PROXY1 = new HttpHost("proxy1.test.invalid", 80);
    public static final HttpHost PROXY2 = new HttpHost("proxy2.test.invalid", 1080);
    public static final HttpHost PROXY3 = new HttpHost("proxy3.test.invalid", 88);
    public static final InetAddress LOCAL41;
    public static final InetAddress LOCAL42;
    public static final InetAddress LOCAL61;
    public static final InetAddress LOCAL62;

    @Test
    public void testIllegal() {
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route = new HttpRoute(TARGET1);
        Assertions.assertThrows(NullPointerException.class, () -> TestRouteDirector.lambda$testIllegal$0((HttpRouteDirector)rowdy, route));
    }

    @Test
    public void testDirect() {
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route1 = new HttpRoute(TARGET1);
        HttpRoute route2 = new HttpRoute(TARGET2);
        HttpRoute route1p1 = new HttpRoute(TARGET1, null, PROXY1, false);
        int step = rowdy.nextStep((RouteInfo)route1, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1");
        step = rowdy.nextStep((RouteInfo)route2, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route2");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1 not detected");
        step = rowdy.nextStep((RouteInfo)route2, (RouteInfo)route2);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route2 not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route2);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable target not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1p1);
        Assertions.assertEquals((int)-1, (int)step, (String)"invalid proxy not detected");
    }

    @Test
    public void testProxy() {
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route1p1 = new HttpRoute(TARGET1, null, PROXY1, false);
        HttpRoute route1p2 = new HttpRoute(TARGET1, null, PROXY2, false);
        HttpRoute route2p1 = new HttpRoute(TARGET2, null, PROXY1, false);
        HttpRoute route0 = new HttpRoute(PROXY1);
        HttpRoute route1 = new HttpRoute(TARGET1);
        int step = rowdy.nextStep((RouteInfo)route1p1, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1p1");
        step = rowdy.nextStep((RouteInfo)route1p2, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1p2");
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route1p1);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1p1 not detected");
        step = rowdy.nextStep((RouteInfo)route1p2, (RouteInfo)route1p2);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1p2 not detected");
        step = rowdy.nextStep((RouteInfo)route2p1, (RouteInfo)route2p1);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route2p1 not detected");
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route1p2);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1p1 via route1p2 not detected");
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route2p1);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1p1 via route2p1 not detected");
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route0);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1p1 via route0 not detected");
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route1);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1p1 via route1 not detected");
    }

    @Test
    public void testProxyChain() {
        HttpHost[] chainA = new HttpHost[]{PROXY1};
        HttpHost[] chainB = new HttpHost[]{PROXY1, PROXY2};
        HttpHost[] chainC = new HttpHost[]{PROXY2, PROXY1};
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route1cA = new HttpRoute(TARGET1, null, chainA, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1cB = new HttpRoute(TARGET1, null, chainB, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1cC = new HttpRoute(TARGET1, null, chainC, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1cD = new HttpRoute(TARGET1, null, chainC, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        int step = rowdy.nextStep((RouteInfo)route1cA, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1cA");
        step = rowdy.nextStep((RouteInfo)route1cB, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1cB");
        step = rowdy.nextStep((RouteInfo)route1cC, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1cC");
        step = rowdy.nextStep((RouteInfo)route1cD, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1cD");
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cA);
        Assertions.assertEquals((int)4, (int)step, (String)"wrong step to route 1cB from 1cA");
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cB);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route 1cB not detected");
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cC);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1cB from 1cC not detected");
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cD);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1cB from 1cD not detected");
        step = rowdy.nextStep((RouteInfo)route1cA, (RouteInfo)route1cB);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1cA from 1cB not detected");
    }

    @Test
    public void testLocalDirect() {
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route1l41 = new HttpRoute(TARGET1, LOCAL41, false);
        HttpRoute route1l42 = new HttpRoute(TARGET1, LOCAL42, false);
        HttpRoute route1l61 = new HttpRoute(TARGET1, LOCAL61, false);
        HttpRoute route1l00 = new HttpRoute(TARGET1, null, false);
        int step = rowdy.nextStep((RouteInfo)route1l41, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1l41");
        step = rowdy.nextStep((RouteInfo)route1l42, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1l42");
        step = rowdy.nextStep((RouteInfo)route1l61, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1l61");
        step = rowdy.nextStep((RouteInfo)route1l00, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1l00");
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l41);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l41 not detected");
        step = rowdy.nextStep((RouteInfo)route1l42, (RouteInfo)route1l42);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l42 not detected");
        step = rowdy.nextStep((RouteInfo)route1l61, (RouteInfo)route1l61);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l61 not detected");
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l00);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l00 not detected");
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l42);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1l41 via route1l42 not detected");
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l61);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1l41 via route1l61 not detected");
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l00);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1l41 via route1l00 not detected");
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l41);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l00 as route1l41 not detected");
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l42);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l00 as route1l42 not detected");
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l61);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1l00 as route1l61 not detected");
    }

    @Test
    public void testDirectSecure() {
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route1u = new HttpRoute(TARGET1, null, false);
        HttpRoute route1s = new HttpRoute(TARGET1, null, true);
        HttpRoute route1p1u = new HttpRoute(TARGET1, null, PROXY1, false);
        HttpRoute route1p1s = new HttpRoute(TARGET1, null, PROXY1, true);
        int step = rowdy.nextStep((RouteInfo)route1u, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1u");
        step = rowdy.nextStep((RouteInfo)route1s, null);
        Assertions.assertEquals((int)1, (int)step, (String)"wrong step to route1s");
        step = rowdy.nextStep((RouteInfo)route1u, (RouteInfo)route1s);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1u from 1s not detected");
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1u);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1s from 1u not detected");
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1p1u);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1s from 1p1u not detected");
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1p1s);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route 1s from 1p1s not detected");
    }

    @Test
    public void testProxyTLS() {
        BasicRouteDirector rowdy = BasicRouteDirector.INSTANCE;
        HttpRoute route1 = new HttpRoute(TARGET1, null, PROXY1, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1t = new HttpRoute(TARGET1, null, PROXY1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute route1tl = new HttpRoute(TARGET1, null, PROXY1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoute route1s = new HttpRoute(TARGET1, null, PROXY1, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1ts = new HttpRoute(TARGET1, null, PROXY1, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute route1tls = new HttpRoute(TARGET1, null, PROXY1, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        int step = rowdy.nextStep((RouteInfo)route1, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1");
        step = rowdy.nextStep((RouteInfo)route1t, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1t");
        step = rowdy.nextStep((RouteInfo)route1tl, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1tl");
        step = rowdy.nextStep((RouteInfo)route1s, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1s");
        step = rowdy.nextStep((RouteInfo)route1ts, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1ts");
        step = rowdy.nextStep((RouteInfo)route1tls, null);
        Assertions.assertEquals((int)2, (int)step, (String)"wrong step to route1tls");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1 not detected");
        step = rowdy.nextStep((RouteInfo)route1t, (RouteInfo)route1t);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1t not detected");
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1tl);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1tl not detected");
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1s);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1s not detected");
        step = rowdy.nextStep((RouteInfo)route1ts, (RouteInfo)route1ts);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1ts not detected");
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1tls);
        Assertions.assertEquals((int)0, (int)step, (String)"complete route1tls not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1t);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1 from 1t not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1tl);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1 from 1tl not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1s);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1 from 1s not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1ts);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1 from 1ts not detected");
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1tls);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1 from 1tls not detected");
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1s from 1 not detected");
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1tl);
        Assertions.assertEquals((int)-1, (int)step, (String)"unreachable route1tls from 1tl not detected");
        step = rowdy.nextStep((RouteInfo)route1t, (RouteInfo)route1);
        Assertions.assertEquals((int)3, (int)step, (String)"wrong step to route1t from 1");
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1);
        Assertions.assertEquals((int)3, (int)step, (String)"wrong step to route1tl from 1");
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1);
        Assertions.assertEquals((int)3, (int)step, (String)"wrong step to route1tls from 1");
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1t);
        Assertions.assertEquals((int)5, (int)step, (String)"wrong step to route1tl from 1t");
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1ts);
        Assertions.assertEquals((int)5, (int)step, (String)"wrong step to route1tl from 1ts");
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1t);
        Assertions.assertEquals((int)5, (int)step, (String)"wrong step to route1tls from 1t");
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1ts);
        Assertions.assertEquals((int)5, (int)step, (String)"wrong step to route1tls from 1ts");
    }

    private static /* synthetic */ void lambda$testIllegal$0(HttpRouteDirector rowdy, HttpRoute route) throws Throwable {
        rowdy.nextStep(null, (RouteInfo)route);
    }

    static {
        try {
            LOCAL41 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LOCAL42 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
            LOCAL61 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            LOCAL62 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

