/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.psl;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import org.apache.hc.client5.http.psl.DomainType;
import org.apache.hc.client5.http.psl.PublicSuffixListParser;
import org.apache.hc.client5.http.psl.PublicSuffixMatcher;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class TestPublicSuffixMatcher {
    private static final String SOURCE_FILE = "suffixlistmatcher.txt";
    private PublicSuffixMatcher matcher;

    @BeforeEach
    public void setUp() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);
        Assertions.assertNotNull((Object)in);
        List lists = PublicSuffixListParser.INSTANCE.parseByType((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
        this.matcher = new PublicSuffixMatcher((Collection)lists);
    }

    @Test
    public void testGetDomainRootAnyType() {
        Assertions.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("example.XX"));
        Assertions.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.example.XX"));
        Assertions.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX"));
        Assertions.assertEquals((Object)"appspot.com", (Object)this.matcher.getDomainRoot("example.appspot.com"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("jp"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("ac.jp"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("any.tokyo.jp"));
        Assertions.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp"));
        Assertions.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp"));
        Assertions.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp"));
        Assertions.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("garbage"));
        Assertions.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("garbage.garbage"));
        Assertions.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage"));
        Assertions.assertEquals((Object)"garbage", (Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage"));
        Assertions.assertEquals((Object)"*.compute-1.amazonaws.com", (Object)this.matcher.getDomainRoot("*.compute-1.amazonaws.com"));
    }

    @Test
    public void testGetDomainRootOnlyPRIVATE() {
        Assertions.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("example.XX", DomainType.PRIVATE));
        Assertions.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.example.XX", DomainType.PRIVATE));
        Assertions.assertEquals((Object)"xx", (Object)this.matcher.getDomainRoot("www.blah.blah.example.XX", DomainType.PRIVATE));
        Assertions.assertEquals((Object)"appspot.com", (Object)this.matcher.getDomainRoot("example.appspot.com"));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("ac.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("any.tokyo.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("metro.tokyo.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("blah.blah.ac.jp", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage.garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage", DomainType.PRIVATE));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage", DomainType.PRIVATE));
    }

    @Test
    public void testGetDomainRootOnlyICANN() {
        Assertions.assertNull((Object)this.matcher.getDomainRoot("example.XX", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("www.example.XX", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("www.blah.blah.example.XX", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("xx", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("jp", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("ac.jp", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("any.tokyo.jp", DomainType.ICANN));
        Assertions.assertEquals((Object)"metro.tokyo.jp", (Object)this.matcher.getDomainRoot("metro.tokyo.jp", DomainType.ICANN));
        Assertions.assertEquals((Object)"blah.blah.tokyo.jp", (Object)this.matcher.getDomainRoot("blah.blah.tokyo.jp", DomainType.ICANN));
        Assertions.assertEquals((Object)"blah.ac.jp", (Object)this.matcher.getDomainRoot("blah.blah.ac.jp", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("garbage.garbage", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage", DomainType.ICANN));
        Assertions.assertNull((Object)this.matcher.getDomainRoot("*.garbage.garbage.garbage", DomainType.ICANN));
    }

    @Test
    public void testMatch() {
        Assertions.assertTrue((boolean)this.matcher.matches(".jp"));
        Assertions.assertTrue((boolean)this.matcher.matches(".ac.jp"));
        Assertions.assertTrue((boolean)this.matcher.matches(".any.tokyo.jp"));
        Assertions.assertFalse((boolean)this.matcher.matches(".metro.tokyo.jp"));
        Assertions.assertFalse((boolean)this.matcher.matches(".xx"));
        Assertions.assertFalse((boolean)this.matcher.matches(".appspot.com"));
    }

    @Test
    public void testMatchUnicode() {
        Assertions.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assertions.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
        Assertions.assertTrue((boolean)this.matcher.matches(".h\u00e5.no"));
        Assertions.assertTrue((boolean)this.matcher.matches(".xn--h-2fa.no"));
    }
}

