/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.utils;

import java.time.Instant;
import java.time.LocalDate;
import java.time.Month;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.Date;
import org.apache.hc.client5.http.utils.DateUtils;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.MessageHeaders;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.HeaderGroup;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestDateUtils {
    private static Instant createInstant(int year, Month month, int day) {
        return LocalDate.of(year, month, day).atStartOfDay(ZoneId.of("GMT")).toInstant();
    }

    private static Date createDate(int year, Month month, int day) {
        Instant instant = TestDateUtils.createInstant(year, month, day);
        return new Date(instant.toEpochMilli());
    }

    @Test
    public void testBasicDateParse() throws Exception {
        Instant instant = TestDateUtils.createInstant(2005, Month.OCTOBER, 14);
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Friday, 14 Oct 2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Fri, 14-Oct-2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseDate((String)"Friday, 14-Oct-2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
        Assertions.assertEquals((Object)instant.minus(2L, ChronoUnit.HOURS), (Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 CET", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
        Assertions.assertEquals((Object)instant.minus(2L, ChronoUnit.HOURS), (Object)DateUtils.parseDate((String)"Fri, 14-Oct-05 00:00:00 CET", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
        Assertions.assertEquals((Object)instant, (Object)DateUtils.parseStandardDate((String)"Fri, 14 Oct 2005 00:00:00 GMT"));
    }

    @Test
    public void testDateParseMessage() throws Exception {
        HeaderGroup message1 = new HeaderGroup();
        message1.setHeader((Header)new BasicHeader("Date", (Object)"Fri, 14 Oct 2005 00:00:00 GMT"));
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseStandardDate((MessageHeaders)message1, (String)"Date"));
        HeaderGroup message2 = new HeaderGroup();
        message2.addHeader((Header)new BasicHeader("Date", (Object)"Fri, 14 Oct 2005 00:00:00 GMT"));
        message2.addHeader((Header)new BasicHeader("Date", (Object)"Fri, 21 Oct 2005 00:00:00 GMT"));
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseStandardDate((MessageHeaders)message2, (String)"Date"));
    }

    @Test
    public void testMalformedDate() {
        Assertions.assertNull((Object)DateUtils.parseDate((String)"Fri, 14 Oct 2005 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[0]));
    }

    @Test
    public void testInvalidInput() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.parseStandardDate(null));
        Assertions.assertThrows(NullPointerException.class, () -> DateUtils.formatStandardDate(null));
    }

    @Test
    public void testTwoDigitYearDateParse() throws Exception {
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseDate((String)"Friday, 14-Oct-05 00:00:00 GMT", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1036}));
    }

    @Test
    public void testParseQuotedDate() throws Exception {
        Assertions.assertEquals((Object)TestDateUtils.createInstant(2005, Month.OCTOBER, 14), (Object)DateUtils.parseDate((String)"'Fri, 14 Oct 2005 00:00:00 GMT'", (DateTimeFormatter[])new DateTimeFormatter[]{DateUtils.FORMATTER_RFC1123}));
    }

    @Test
    public void testBasicDateFormat() throws Exception {
        Instant instant = TestDateUtils.createInstant(2005, Month.OCTOBER, 14);
        Assertions.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatStandardDate((Instant)instant));
        Assertions.assertEquals((Object)"Fri, 14 Oct 2005 00:00:00 GMT", (Object)DateUtils.formatDate((Instant)instant, (DateTimeFormatter)DateUtils.FORMATTER_RFC1123));
        Assertions.assertEquals((Object)"Fri, 14-Oct-05 00:00:00 GMT", (Object)DateUtils.formatDate((Instant)instant, (DateTimeFormatter)DateUtils.FORMATTER_RFC1036));
        Assertions.assertEquals((Object)"Fri Oct 14 00:00:00 2005", (Object)DateUtils.formatDate((Instant)instant, (DateTimeFormatter)DateUtils.FORMATTER_ASCTIME));
    }
}

