/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.cookie;

import java.time.Instant;
import java.util.Comparator;
import org.apache.hc.client5.http.cookie.Cookie;
import org.apache.hc.client5.http.cookie.CookiePriorityComparator;
import org.apache.hc.client5.http.impl.cookie.BasicClientCookie;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestCookiePriorityComparator {
    private Comparator<Cookie> comparator;

    TestCookiePriorityComparator() {
    }

    @BeforeEach
    void setup() {
        this.comparator = CookiePriorityComparator.INSTANCE;
    }

    @Test
    void testUnequality() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/a/b/");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/a/");
        Assertions.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testEquality() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/a");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/a");
        Assertions.assertEquals((int)0, (int)this.comparator.compare((Cookie)cookie1, (Cookie)cookie2));
        Assertions.assertEquals((int)0, (int)this.comparator.compare((Cookie)cookie2, (Cookie)cookie1));
    }

    @Test
    void testUnequalityTrailingSlash() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/a/");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/a");
        Assertions.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) > 0 ? 1 : 0) != 0);
    }

    @Test
    void testEqualityNullPath() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath(null);
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/");
        Assertions.assertEquals((int)0, (int)this.comparator.compare((Cookie)cookie1, (Cookie)cookie2));
        Assertions.assertEquals((int)0, (int)this.comparator.compare((Cookie)cookie2, (Cookie)cookie1));
    }

    @Test
    void testEqualitySameLength() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/this");
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/that");
        Assertions.assertEquals((int)0, (int)this.comparator.compare((Cookie)cookie1, (Cookie)cookie2));
        Assertions.assertEquals((int)0, (int)this.comparator.compare((Cookie)cookie2, (Cookie)cookie1));
    }

    @Test
    void testUnequalityCreationDate() {
        BasicClientCookie cookie1 = new BasicClientCookie("name1", "value");
        cookie1.setPath("/blah");
        cookie1.setCreationDate(Instant.now().minusMillis(200000L));
        BasicClientCookie cookie2 = new BasicClientCookie("name1", "value");
        cookie2.setPath("/blah");
        cookie2.setCreationDate(Instant.now());
        Assertions.assertTrue((this.comparator.compare((Cookie)cookie1, (Cookie)cookie2) < 0 ? 1 : 0) != 0);
        Assertions.assertTrue((this.comparator.compare((Cookie)cookie2, (Cookie)cookie1) > 0 ? 1 : 0) != 0);
    }
}

