/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.nio.CharBuffer;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.AbstractCharResponseConsumer;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHttpRequest;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http.nio.support.BasicRequestProducer;
import org.apache.hc.core5.http.support.BasicRequestBuilder;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientHttpExchangeStreaming {
    public static void main(String[] args) throws Exception {
        String[] requestUris;
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setIOReactorConfig(ioReactorConfig).build();
        client.start();
        HttpHost target = new HttpHost("httpbin.org");
        for (String requestUri : requestUris = new String[]{"/", "/ip", "/user-agent", "/headers"}) {
            final BasicHttpRequest request = BasicRequestBuilder.get().setHttpHost(target).setPath(requestUri).build();
            System.out.println("Executing request " + request);
            Future future = client.execute((AsyncRequestProducer)new BasicRequestProducer((HttpRequest)request, null), (AsyncResponseConsumer)new AbstractCharResponseConsumer<Void>(){

                protected void start(HttpResponse response, ContentType contentType) {
                    System.out.println(request + "->" + new StatusLine(response));
                }

                protected int capacityIncrement() {
                    return Integer.MAX_VALUE;
                }

                protected void data(CharBuffer data, boolean endOfStream) {
                    while (data.hasRemaining()) {
                        System.out.print(data.get());
                    }
                    if (endOfStream) {
                        System.out.println();
                    }
                }

                protected Void buildResult() {
                    return null;
                }

                public void failed(Exception cause) {
                    System.out.println(request + "->" + cause);
                }

                public void releaseResources() {
                }
            }, null);
            future.get();
        }
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

