/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.net.ConnectException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.net.SocketAddress;
import java.net.SocketTimeoutException;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.ConnectTimeoutException;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpHostConnectException;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.UnsupportedSchemeException;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestHttpClientConnectionOperator {
    private ManagedHttpClientConnection conn;
    private Socket socket;
    private DetachedSocketFactory detachedSocketFactory;
    private TlsSocketStrategy tlsSocketStrategy;
    private Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    private SchemePortResolver schemePortResolver;
    private DnsResolver dnsResolver;
    private DefaultHttpClientConnectionOperator connectionOperator;

    TestHttpClientConnectionOperator() {
    }

    @BeforeEach
    void setup() {
        this.conn = (ManagedHttpClientConnection)Mockito.mock(ManagedHttpClientConnection.class);
        this.socket = (Socket)Mockito.mock(Socket.class);
        this.detachedSocketFactory = (DetachedSocketFactory)Mockito.mock(DetachedSocketFactory.class);
        this.tlsSocketStrategy = (TlsSocketStrategy)Mockito.mock(TlsSocketStrategy.class);
        this.tlsSocketStrategyLookup = (Lookup)Mockito.mock(Lookup.class);
        this.schemePortResolver = (SchemePortResolver)Mockito.mock(SchemePortResolver.class);
        this.dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        this.connectionOperator = new DefaultHttpClientConnectionOperator(this.detachedSocketFactory, this.schemePortResolver, this.dnsResolver, this.tlsSocketStrategyLookup);
    }

    @Test
    void testConnect() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.schemePortResolver.resolve(host.getSchemeName(), (NamedEndpoint)host)).thenReturn((Object)80);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        SocketConfig socketConfig = SocketConfig.custom().setSoKeepAlive(true).setSoReuseAddress(true).setSoTimeout(5000, TimeUnit.MILLISECONDS).setTcpNoDelay(true).setSoLinger(50, TimeUnit.MILLISECONDS).build();
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        this.connectionOperator.connect(this.conn, host, null, localAddress, Timeout.ofMilliseconds((long)123L), socketConfig, null, (HttpContext)context);
        ((Socket)Mockito.verify((Object)this.socket)).setKeepAlive(true);
        ((Socket)Mockito.verify((Object)this.socket)).setReuseAddress(true);
        ((Socket)Mockito.verify((Object)this.socket)).setSoTimeout(5000);
        ((Socket)Mockito.verify((Object)this.socket)).setSoLinger(true, 50);
        ((Socket)Mockito.verify((Object)this.socket)).setTcpNoDelay(true);
        ((Socket)Mockito.verify((Object)this.socket)).bind(localAddress);
        ((Socket)Mockito.verify((Object)this.socket)).connect(new InetSocketAddress(ip1, 80), 123);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
    }

    @Test
    void testConnectWithTLSUpgrade() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("https", "somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
        TlsConfig tlsConfig = TlsConfig.custom().setHandshakeTimeout(Timeout.ofMilliseconds((long)345L)).setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_1).build();
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.schemePortResolver.resolve(host.getSchemeName(), (NamedEndpoint)host)).thenReturn((Object)443);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.tlsSocketStrategyLookup.lookup("https")).thenReturn((Object)this.tlsSocketStrategy);
        SSLSocket upgradedSocket = (SSLSocket)Mockito.mock(SSLSocket.class);
        Mockito.when((Object)this.tlsSocketStrategy.upgrade((Socket)Mockito.same((Object)this.socket), (String)Mockito.eq((Object)"somehost"), Mockito.anyInt(), Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)upgradedSocket);
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        this.connectionOperator.connect(this.conn, host, null, localAddress, Timeout.ofMilliseconds((long)123L), SocketConfig.DEFAULT, (Object)tlsConfig, (HttpContext)context);
        ((Socket)Mockito.verify((Object)this.socket)).connect(new InetSocketAddress(ip1, 443), 123);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy)).upgrade(this.socket, "somehost", -1, (Object)tlsConfig, (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).bind(upgradedSocket, this.socket);
    }

    @Test
    void testConnectTimeout() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("somehost");
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        ((Socket)Mockito.doThrow((Throwable[])new Throwable[]{new SocketTimeoutException()}).when((Object)this.socket)).connect((SocketAddress)Mockito.any(), Mockito.anyInt());
        Assertions.assertThrows(ConnectTimeoutException.class, () -> this.connectionOperator.connect(this.conn, host, null, TimeValue.ofMilliseconds((long)1000L), SocketConfig.DEFAULT, (HttpContext)context));
    }

    @Test
    void testConnectFailure() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("somehost");
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.schemePortResolver.resolve(host)).thenReturn((Object)80);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        ((Socket)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectException()}).when((Object)this.socket)).connect((SocketAddress)Mockito.any(), Mockito.anyInt());
        Assertions.assertThrows(HttpHostConnectException.class, () -> this.connectionOperator.connect(this.conn, host, null, TimeValue.ofMilliseconds((long)1000L), SocketConfig.DEFAULT, (HttpContext)context));
    }

    @Test
    void testConnectFailover() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("somehost");
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress ip2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{ip1, ip2});
        Mockito.when((Object)this.schemePortResolver.resolve(host.getSchemeName(), (NamedEndpoint)host)).thenReturn((Object)80);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        ((Socket)Mockito.doThrow((Throwable[])new Throwable[]{new ConnectException()}).when((Object)this.socket)).connect((SocketAddress)Mockito.eq((Object)new InetSocketAddress(ip1, 80)), Mockito.anyInt());
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        TlsConfig tlsConfig = TlsConfig.custom().build();
        this.connectionOperator.connect(this.conn, host, null, localAddress, Timeout.ofMilliseconds((long)123L), SocketConfig.DEFAULT, (Object)tlsConfig, (HttpContext)context);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)2))).bind(localAddress);
        ((Socket)Mockito.verify((Object)this.socket)).connect(new InetSocketAddress(ip2, 80), 123);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)3))).bind(this.socket);
    }

    @Test
    void testConnectExplicitAddress() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 0});
        InetAddress ip = InetAddress.getByAddress(new byte[]{127, 0, 0, 23});
        HttpHost host = new HttpHost(ip);
        Mockito.when((Object)this.schemePortResolver.resolve(host.getSchemeName(), (NamedEndpoint)host)).thenReturn((Object)80);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        InetSocketAddress localAddress = new InetSocketAddress(local, 0);
        TlsConfig tlsConfig = TlsConfig.custom().build();
        this.connectionOperator.connect(this.conn, host, null, localAddress, Timeout.ofMilliseconds((long)123L), SocketConfig.DEFAULT, (Object)tlsConfig, (HttpContext)context);
        ((Socket)Mockito.verify((Object)this.socket)).bind(localAddress);
        ((Socket)Mockito.verify((Object)this.socket)).connect(new InetSocketAddress(ip, 80), 123);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.never())).resolve(Mockito.anyString());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)2))).bind(this.socket);
    }

    @Test
    void testUpgrade() throws Exception {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("https", "somehost", -1);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        Mockito.when((Object)this.tlsSocketStrategyLookup.lookup("https")).thenReturn((Object)this.tlsSocketStrategy);
        SSLSocket upgradedSocket = (SSLSocket)Mockito.mock(SSLSocket.class);
        Mockito.when((Object)this.tlsSocketStrategy.upgrade((Socket)Mockito.any(), (String)Mockito.eq((Object)"somehost"), Mockito.anyInt(), Mockito.eq((Object)Timeout.ofMilliseconds((long)345L)), (HttpContext)Mockito.any())).thenReturn((Object)upgradedSocket);
        this.connectionOperator.upgrade(this.conn, host, null, (Object)Timeout.ofMilliseconds((long)345L), (HttpContext)context);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).bind((Socket)upgradedSocket);
    }

    @Test
    void testUpgradeUpsupportedScheme() {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("httpsssss", "somehost", -1);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        Assertions.assertThrows(UnsupportedSchemeException.class, () -> this.connectionOperator.upgrade(this.conn, host, (HttpContext)context));
    }

    @Test
    void testUpgradeNonLayeringScheme() {
        HttpClientContext context = HttpClientContext.create();
        HttpHost host = new HttpHost("http", "somehost", -1);
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)true);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        Assertions.assertThrows(UnsupportedSchemeException.class, () -> this.connectionOperator.upgrade(this.conn, host, (HttpContext)context));
    }
}

