/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.async.MinimalHttpAsyncClient;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.config.Http1Config;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncClientEndpoint;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.http2.config.H2Config;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;

public class AsyncClientH2Multiplexing {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        MinimalHttpAsyncClient client = HttpAsyncClients.createMinimal((H2Config)H2Config.DEFAULT, (Http1Config)Http1Config.DEFAULT, (IOReactorConfig)IOReactorConfig.DEFAULT, (AsyncClientConnectionManager)PoolingAsyncClientConnectionManagerBuilder.create().setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_2).build()).build());
        client.start();
        HttpHost target = new HttpHost("https", "nghttp2.org");
        Future leaseFuture = client.lease(target, null);
        AsyncClientEndpoint endpoint = (AsyncClientEndpoint)leaseFuture.get(30L, TimeUnit.SECONDS);
        try {
            String[] requestUris = new String[]{"/httpbin/ip", "/httpbin/user-agent", "/httpbin/headers"};
            final CountDownLatch latch = new CountDownLatch(requestUris.length);
            for (String requestUri : requestUris) {
                final SimpleHttpRequest request = SimpleRequestBuilder.get().setHttpHost(target).setPath(requestUri).build();
                System.out.println("Executing request " + request);
                endpoint.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                    public void completed(SimpleHttpResponse response) {
                        latch.countDown();
                        System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                        System.out.println(response.getBody());
                    }

                    public void failed(Exception ex) {
                        latch.countDown();
                        System.out.println(request + "->" + ex);
                    }

                    public void cancelled() {
                        latch.countDown();
                        System.out.println(request + " cancelled");
                    }
                });
            }
            latch.await();
        }
        finally {
            endpoint.releaseAndReuse();
        }
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

