/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.auth;

import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.impl.auth.BasicAuthCache;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.core5.http.HttpHost;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestBasicAuthCache {
    TestBasicAuthCache() {
    }

    @Test
    void testBasicStoreRestore() {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        Assertions.assertNotNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.remove(new HttpHost("localhost", 80));
        Assertions.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
        cache.put(new HttpHost("localhost", 80), (AuthScheme)authScheme);
        cache.clear();
        Assertions.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    @Test
    void testNullKey() {
        BasicAuthCache cache = new BasicAuthCache();
        BasicScheme authScheme = new BasicScheme();
        Assertions.assertThrows(NullPointerException.class, () -> TestBasicAuthCache.lambda$testNullKey$0(cache, (AuthScheme)authScheme));
    }

    @Test
    void testNullAuthScheme() {
        BasicAuthCache cache = new BasicAuthCache();
        cache.put(new HttpHost("localhost", 80), null);
        Assertions.assertNull((Object)cache.get(new HttpHost("localhost", 80)));
    }

    private static /* synthetic */ void lambda$testNullKey$0(BasicAuthCache cache, AuthScheme authScheme) throws Throwable {
        cache.put(null, authScheme);
    }
}

