/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.classic;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;
import org.apache.hc.client5.http.classic.ExecRuntime;
import org.apache.hc.client5.http.impl.classic.ResponseEntityProxy;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

class TestResponseEntityWrapper {
    private InputStream inStream;
    private HttpEntity entity;
    private ExecRuntime execRuntime;
    private ResponseEntityProxy wrapper;

    TestResponseEntityWrapper() {
    }

    @BeforeEach
    void setup() throws Exception {
        this.inStream = (InputStream)Mockito.mock(InputStream.class);
        this.entity = (HttpEntity)Mockito.mock(HttpEntity.class);
        Mockito.when((Object)this.entity.getContent()).thenReturn((Object)this.inStream);
        this.execRuntime = (ExecRuntime)Mockito.mock(ExecRuntime.class);
        this.wrapper = new ResponseEntityProxy(this.entity, this.execRuntime);
    }

    @Test
    void testReusableEntityStreamClosed() throws Exception {
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        EntityUtils.consume((HttpEntity)this.wrapper);
        ((InputStream)Mockito.verify((Object)this.inStream, (VerificationMode)Mockito.times((int)1))).close();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).releaseEndpoint();
    }

    @Test
    void testReusableEntityStreamClosedIOError() throws Exception {
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.inStream)).close();
        Assertions.assertThrows(IOException.class, () -> EntityUtils.consume((HttpEntity)this.wrapper));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.atLeast((int)1))).discardEndpoint();
    }

    @Test
    void testEntityStreamClosedIOErrorAlreadyReleased() throws Exception {
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isEndpointAcquired()).thenReturn((Object)false);
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new SocketException()}).when((Object)this.inStream)).close();
        EntityUtils.consume((HttpEntity)this.wrapper);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).discardEndpoint();
    }

    @Test
    void testReusableEntityWriteTo() throws Exception {
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        this.wrapper.writeTo(outStream);
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).releaseEndpoint();
    }

    @Test
    void testReusableEntityWriteToIOError() throws Exception {
        OutputStream outStream = (OutputStream)Mockito.mock(OutputStream.class);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        ((HttpEntity)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.entity)).writeTo(outStream);
        Assertions.assertThrows(IOException.class, () -> this.wrapper.writeTo(outStream));
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.never())).releaseEndpoint();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.atLeast((int)1))).discardEndpoint();
    }

    @Test
    void testReusableEntityEndOfStream() throws Exception {
        Mockito.when((Object)this.inStream.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        InputStream content = this.wrapper.getContent();
        Assertions.assertEquals((int)-1, (int)content.read());
        ((InputStream)Mockito.verify((Object)this.inStream)).close();
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime)).releaseEndpoint();
    }

    @Test
    void testReusableEntityEndOfStreamIOError() throws Exception {
        Mockito.when((Object)this.inStream.read()).thenReturn((Object)-1);
        Mockito.when((Object)this.entity.isStreaming()).thenReturn((Object)true);
        Mockito.when((Object)this.execRuntime.isConnectionReusable()).thenReturn((Object)true);
        ((InputStream)Mockito.doThrow((Throwable[])new Throwable[]{new IOException()}).when((Object)this.inStream)).close();
        InputStream content = this.wrapper.getContent();
        Assertions.assertThrows(IOException.class, () -> content.read());
        ((ExecRuntime)Mockito.verify((Object)this.execRuntime, (VerificationMode)Mockito.atLeast((int)1))).discardEndpoint();
    }
}

