/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.io;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSocket;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.SchemePortResolver;
import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.io.BasicHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.DefaultHttpClientConnectionOperator;
import org.apache.hc.client5.http.io.ConnectionEndpoint;
import org.apache.hc.client5.http.io.DetachedSocketFactory;
import org.apache.hc.client5.http.io.HttpClientConnectionOperator;
import org.apache.hc.client5.http.io.LeaseRequest;
import org.apache.hc.client5.http.io.ManagedHttpClientConnection;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.ssl.TlsSocketStrategy;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.io.HttpConnectionFactory;
import org.apache.hc.core5.http.io.SocketConfig;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

class TestBasicHttpClientConnectionManager {
    @Mock
    private ManagedHttpClientConnection conn;
    @Mock
    private HttpConnectionFactory<ManagedHttpClientConnection> connFactory;
    @Mock
    private Lookup<TlsSocketStrategy> tlsSocketStrategyLookup;
    @Mock
    private DetachedSocketFactory detachedSocketFactory;
    @Mock
    private TlsSocketStrategy tlsSocketStrategy;
    @Mock
    private Socket socket;
    @Mock
    private SSLSocket upgradedSocket;
    @Mock
    private SchemePortResolver schemePortResolver;
    @Mock
    private DnsResolver dnsResolver;
    private BasicHttpClientConnectionManager mgr;

    TestBasicHttpClientConnectionManager() {
    }

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks((Object)this);
        this.mgr = new BasicHttpClientConnectionManager((HttpClientConnectionOperator)new DefaultHttpClientConnectionOperator(this.detachedSocketFactory, this.schemePortResolver, this.dnsResolver, this.tlsSocketStrategyLookup), this.connFactory);
    }

    @Test
    void testLeaseReleaseNonReusable() throws Exception {
        HttpHost target = new HttpHost("localhost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        Assertions.assertFalse((boolean)endpoint1.isConnected());
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        Assertions.assertNull((Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertFalse((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).createConnection((Socket)Mockito.any());
    }

    @Test
    void testLeaseReleaseReusable() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        Assertions.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertTrue((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
    }

    @Test
    void testLeaseReleaseReusableWithState() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, (Object)"some state");
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, (Object)"some other state", TimeValue.ofMilliseconds((long)10000L));
        Assertions.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assertions.assertEquals((Object)"some other state", (Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, (Object)"some other state");
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertTrue((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
    }

    @Test
    void testLeaseDifferentRoute() throws Exception {
        HttpHost target1 = new HttpHost("somehost", 80);
        HttpRoute route1 = new HttpRoute(target1);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route1, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        Assertions.assertEquals((Object)route1, (Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        HttpHost target2 = new HttpHost("otherhost", 80);
        HttpRoute route2 = new HttpRoute(target2);
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route2, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertFalse((boolean)conn2.isConnected());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).createConnection((Socket)Mockito.any());
    }

    @Test
    void testLeaseExpired() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)10L));
        Assertions.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        Thread.sleep(50L);
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertFalse((boolean)conn2.isConnected());
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)2))).createConnection((Socket)Mockito.any());
    }

    @Test
    void testReleaseInvalidArg() {
        Assertions.assertThrows(NullPointerException.class, () -> this.mgr.release(null, null, TimeValue.NEG_ONE_MILLISECOND));
    }

    @Test
    void testReleaseAnotherConnection() {
        ConnectionEndpoint wrongCon = (ConnectionEndpoint)Mockito.mock(ConnectionEndpoint.class);
        Assertions.assertThrows(IllegalStateException.class, () -> this.mgr.release(wrongCon, null, TimeValue.NEG_ONE_MILLISECOND));
    }

    @Test
    void testShutdown() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        this.mgr.close();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close(CloseMode.GRACEFUL);
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        Assertions.assertThrows(IllegalStateException.class, () -> connRequest2.get(Timeout.ZERO_MILLISECONDS));
        this.mgr.closeExpired();
        this.mgr.closeIdle(TimeValue.ZERO_MILLISECONDS);
        this.mgr.close();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close(CloseMode.GRACEFUL);
    }

    @Test
    void testCloseExpired() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)10L));
        Assertions.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        Thread.sleep(50L);
        this.mgr.closeExpired();
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
    }

    @Test
    void testCloseIdle() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE, (Object[])new Boolean[]{Boolean.FALSE});
        this.mgr.release(endpoint1, null, TimeValue.NEG_ONE_MILLISECOND);
        Assertions.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        Thread.sleep(100L);
        this.mgr.closeIdle(TimeValue.ofMilliseconds((long)50L));
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn)).close(CloseMode.GRACEFUL);
    }

    @Test
    void testAlreadyLeased() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        this.mgr.getConnection(route, null);
        Assertions.assertThrows(IllegalStateException.class, () -> this.mgr.getConnection(route, null));
    }

    @Test
    void testTargetConnect() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, true);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setSocketConfig(sconfig);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(234L, TimeUnit.MILLISECONDS).build();
        this.mgr.setConnectionConfig(connectionConfig);
        TlsConfig tlsConfig = TlsConfig.custom().setHandshakeTimeout(345L, TimeUnit.MILLISECONDS).build();
        this.mgr.setTlsConfig(tlsConfig);
        Mockito.when((Object)this.dnsResolver.resolve("somehost")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(target.getSchemeName(), (NamedEndpoint)target)).thenReturn((Object)8443);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        Mockito.when((Object)this.tlsSocketStrategyLookup.lookup("https")).thenReturn((Object)this.tlsSocketStrategy);
        Mockito.when((Object)this.tlsSocketStrategy.upgrade((Socket)Mockito.same((Object)this.socket), (String)Mockito.eq((Object)"somehost"), Mockito.eq((int)8443), Mockito.any(), (HttpContext)Mockito.any())).thenReturn((Object)this.upgradedSocket);
        this.mgr.connect(endpoint1, null, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("somehost");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(target.getSchemeName(), (NamedEndpoint)target);
        ((DetachedSocketFactory)Mockito.verify((Object)this.detachedSocketFactory, (VerificationMode)Mockito.times((int)1))).create(null);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).connect(new InetSocketAddress(remote, 8443), 234);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy)).upgrade(this.socket, "somehost", 443, (Object)tlsConfig, (HttpContext)context);
        this.mgr.connect(endpoint1, TimeValue.ofMilliseconds((long)123L), (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)2))).resolve("somehost");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)2))).resolve(target.getSchemeName(), (NamedEndpoint)target);
        ((DetachedSocketFactory)Mockito.verify((Object)this.detachedSocketFactory, (VerificationMode)Mockito.times((int)2))).create(null);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).connect(new InetSocketAddress(remote, 8443), 123);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy, (VerificationMode)Mockito.times((int)2))).upgrade(this.socket, "somehost", 443, (Object)tlsConfig, (HttpContext)context);
    }

    @Test
    void testProxyConnectAndUpgrade() throws Exception {
        HttpHost target = new HttpHost("https", "somehost", 443);
        HttpHost proxy = new HttpHost("someproxy", 8080);
        InetAddress remote = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress local = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
        HttpRoute route = new HttpRoute(target, local, proxy, true);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        HttpClientContext context = HttpClientContext.create();
        SocketConfig sconfig = SocketConfig.custom().build();
        this.mgr.setSocketConfig(sconfig);
        ConnectionConfig connectionConfig = ConnectionConfig.custom().setConnectTimeout(234L, TimeUnit.MILLISECONDS).build();
        this.mgr.setConnectionConfig(connectionConfig);
        TlsConfig tlsConfig = TlsConfig.custom().setHandshakeTimeout(345L, TimeUnit.MILLISECONDS).build();
        this.mgr.setTlsConfig(tlsConfig);
        Mockito.when((Object)this.dnsResolver.resolve("someproxy")).thenReturn((Object)new InetAddress[]{remote});
        Mockito.when((Object)this.schemePortResolver.resolve(proxy.getSchemeName(), (NamedEndpoint)proxy)).thenReturn((Object)8080);
        Mockito.when((Object)this.schemePortResolver.resolve(target.getSchemeName(), (NamedEndpoint)target)).thenReturn((Object)8443);
        Mockito.when((Object)this.tlsSocketStrategyLookup.lookup("https")).thenReturn((Object)this.tlsSocketStrategy);
        Mockito.when((Object)this.detachedSocketFactory.create((Proxy)Mockito.any())).thenReturn((Object)this.socket);
        this.mgr.connect(endpoint1, null, (HttpContext)context);
        ((DnsResolver)Mockito.verify((Object)this.dnsResolver, (VerificationMode)Mockito.times((int)1))).resolve("someproxy");
        ((SchemePortResolver)Mockito.verify((Object)this.schemePortResolver, (VerificationMode)Mockito.times((int)1))).resolve(proxy.getSchemeName(), (NamedEndpoint)proxy);
        ((DetachedSocketFactory)Mockito.verify((Object)this.detachedSocketFactory, (VerificationMode)Mockito.times((int)1))).create(null);
        ((Socket)Mockito.verify((Object)this.socket, (VerificationMode)Mockito.times((int)1))).connect(new InetSocketAddress(remote, 8080), 234);
        Mockito.when((Object)this.conn.getSocket()).thenReturn((Object)this.socket);
        this.mgr.upgrade(endpoint1, (HttpContext)context);
        ((TlsSocketStrategy)Mockito.verify((Object)this.tlsSocketStrategy, (VerificationMode)Mockito.times((int)1))).upgrade(this.socket, "somehost", 443, (Object)tlsConfig, (HttpContext)context);
    }

    @Test
    void shouldCloseStaleConnectionAndCreateNewOne() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, null, TimeValue.ofMilliseconds((long)100L));
        Assertions.assertEquals((Object)route, (Object)this.mgr.getRoute());
        Assertions.assertNull((Object)this.mgr.getState());
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        Mockito.when((Object)this.conn.isStale()).thenReturn((Object)Boolean.TRUE);
        ConnectionEndpoint conn2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)conn2);
        Assertions.assertTrue((boolean)conn2.isConnected());
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
    }

    @Test
    void shouldCloseGRACEFULStaleConnection() throws Exception {
        HttpHost target = new HttpHost("somehost", 80);
        HttpRoute route = new HttpRoute(target);
        Mockito.when((Object)this.connFactory.createConnection((Socket)Mockito.any())).thenReturn((Object)this.conn);
        LeaseRequest connRequest1 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint1 = connRequest1.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint1);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Mockito.when((Object)this.conn.isOpen()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.conn.isConsistent()).thenReturn((Object)Boolean.TRUE);
        this.mgr.release(endpoint1, null, null);
        ((ManagedHttpClientConnection)Mockito.verify((Object)this.conn, (VerificationMode)Mockito.times((int)1))).close(CloseMode.GRACEFUL);
        Mockito.when((Object)this.conn.isStale()).thenReturn((Object)Boolean.TRUE);
        LeaseRequest connRequest2 = this.mgr.lease("some-id", route, null);
        ConnectionEndpoint endpoint2 = connRequest2.get(Timeout.ZERO_MILLISECONDS);
        Assertions.assertNotNull((Object)endpoint2);
        ((HttpConnectionFactory)Mockito.verify(this.connFactory, (VerificationMode)Mockito.times((int)1))).createConnection((Socket)Mockito.any());
        Assertions.assertTrue((boolean)endpoint2.isConnected());
    }
}

