/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.ssl;

import java.util.Arrays;
import org.apache.hc.client5.http.ssl.DistinguishedNameParser;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestDistinguishedNameParser {
    private DistinguishedNameParser impl;

    TestDistinguishedNameParser() {
    }

    @BeforeEach
    void setup() {
        this.impl = DistinguishedNameParser.INSTANCE;
    }

    @Test
    void testParseBasic() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn=blah, ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    void testParseRepeatedElements() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn=blah, cn=yada, cn=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("cn", "yada"), new BasicNameValuePair("cn", "booh"))));
    }

    @Test
    void testParseBlanks() {
        MatcherAssert.assertThat((Object)this.impl.parse("c = pampa ,  cn  =    blah    , ou = blah , o = blah"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("c", "pampa"), new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "blah"), new BasicNameValuePair("o", "blah"))));
    }

    @Test
    void testParseQuotes() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn=\"blah\", ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    void testParseQuotes2() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn=\"blah  blah\", ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah  blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    void testParseQuotes3() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn=\"blah, blah\", ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah, blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    void testParseEscape() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn=blah\\, blah, ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", "blah, blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    void testParseUnescapedEqual() {
        MatcherAssert.assertThat((Object)this.impl.parse("c = cn=uuh, cn=blah, ou=yada, o=booh"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("c", "cn=uuh"), new BasicNameValuePair("cn", "blah"), new BasicNameValuePair("ou", "yada"), new BasicNameValuePair("o", "booh"))));
    }

    @Test
    void testParseInvalid() {
        MatcherAssert.assertThat((Object)this.impl.parse("blah,blah"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("blah", null), new BasicNameValuePair("blah", null))));
    }

    @Test
    void testParseInvalid2() {
        MatcherAssert.assertThat((Object)this.impl.parse("cn,o=blah"), (Matcher)CoreMatchers.equalTo(Arrays.asList(new BasicNameValuePair("cn", null), new BasicNameValuePair("o", "blah"))));
    }
}

