/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.async.methods.SimpleHttpRequest;
import org.apache.hc.client5.http.async.methods.SimpleHttpResponse;
import org.apache.hc.client5.http.async.methods.SimpleRequestBuilder;
import org.apache.hc.client5.http.async.methods.SimpleRequestProducer;
import org.apache.hc.client5.http.async.methods.SimpleResponseConsumer;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManager;
import org.apache.hc.client5.http.impl.nio.PoolingAsyncClientConnectionManagerBuilder;
import org.apache.hc.client5.http.nio.AsyncClientConnectionManager;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.nio.AsyncRequestProducer;
import org.apache.hc.core5.http.nio.AsyncResponseConsumer;
import org.apache.hc.core5.http2.HttpVersionPolicy;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.reactor.IOReactorConfig;
import org.apache.hc.core5.util.Timeout;

public class AsyncClientH2Multiplexing {
    public static void main(String[] args) throws Exception {
        IOReactorConfig ioReactorConfig = IOReactorConfig.custom().setSoTimeout(Timeout.ofSeconds((long)5L)).build();
        PoolingAsyncClientConnectionManager connectionManager = PoolingAsyncClientConnectionManagerBuilder.create().setDefaultTlsConfig(TlsConfig.custom().setVersionPolicy(HttpVersionPolicy.FORCE_HTTP_2).build()).setMessageMultiplexing(true).build();
        CloseableHttpAsyncClient client = HttpAsyncClients.custom().setConnectionManager((AsyncClientConnectionManager)connectionManager).setIOReactorConfig(ioReactorConfig).build();
        client.start();
        HttpHost target = new HttpHost("https", "nghttp2.org");
        final SimpleHttpRequest warmup = SimpleRequestBuilder.get().setHttpHost(target).setPath("/httpbin").build();
        System.out.println("Executing warm-up request " + warmup);
        Future future = client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)warmup), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

            public void completed(SimpleHttpResponse response) {
                System.out.println(warmup + "->" + new StatusLine((HttpResponse)response));
                System.out.println(response.getBody());
            }

            public void failed(Exception ex) {
                System.out.println(warmup + "->" + ex);
            }

            public void cancelled() {
                System.out.println(warmup + " cancelled");
            }
        });
        future.get();
        Thread.sleep(1000L);
        System.out.println("Connection pool stats: " + connectionManager.getTotalStats());
        String[] requestUris = new String[]{"/httpbin", "/httpbin/ip", "/httpbin/user-agent", "/httpbin/headers"};
        final CountDownLatch countDownLatch = new CountDownLatch(requestUris.length);
        for (String requestUri : requestUris) {
            final SimpleHttpRequest request = SimpleRequestBuilder.get().setHttpHost(target).setPath(requestUri).build();
            System.out.println("Executing request " + request);
            client.execute((AsyncRequestProducer)SimpleRequestProducer.create((SimpleHttpRequest)request), (AsyncResponseConsumer)SimpleResponseConsumer.create(), (FutureCallback)new FutureCallback<SimpleHttpResponse>(){

                public void completed(SimpleHttpResponse response) {
                    countDownLatch.countDown();
                    System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                    System.out.println(response.getBody());
                }

                public void failed(Exception ex) {
                    countDownLatch.countDown();
                    System.out.println(request + "->" + ex);
                }

                public void cancelled() {
                    countDownLatch.countDown();
                    System.out.println(request + " cancelled");
                }
            });
        }
        countDownLatch.await();
        System.out.println("Connection pool stats: " + connectionManager.getTotalStats());
        System.out.println("Shutting down");
        client.close(CloseMode.GRACEFUL);
    }
}

