/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.hc.client5.http.classic.methods.HttpGet;
import org.apache.hc.client5.http.impl.async.CloseableHttpAsyncClient;
import org.apache.hc.client5.http.impl.async.HttpAsyncClients;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.core5.annotation.Experimental;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.util.Timeout;

@Experimental
public class ClientClassicOverAsync {
    public static void main(String[] args) throws Exception {
        try (CloseableHttpClient httpclient = HttpAsyncClients.classic((CloseableHttpAsyncClient)HttpAsyncClients.createDefault(), (Timeout)Timeout.ofMinutes((long)1L));){
            HttpGet httpget = new HttpGet("http://httpbin.org/get");
            System.out.println("Executing request " + httpget.getMethod() + " " + httpget.getUri());
            httpclient.execute((ClassicHttpRequest)httpget, response -> {
                System.out.println("----------------------------------------");
                System.out.println(httpget + "->" + new StatusLine((HttpResponse)response));
                HttpEntity entity = response.getEntity();
                if (entity != null) {
                    ContentType contentType = ContentType.parseLenient((CharSequence)entity.getContentType());
                    Charset charset = ContentType.getCharset((ContentType)contentType, (Charset)StandardCharsets.UTF_8);
                    try (BufferedReader reader = new BufferedReader(new InputStreamReader(entity.getContent(), charset));){
                        String line;
                        while ((line = reader.readLine()) != null) {
                            System.out.println(line);
                        }
                    }
                }
                return null;
            });
        }
    }
}

