/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.examples;

import org.apache.hc.client5.http.config.ConnectionConfig;
import org.apache.hc.client5.http.config.TlsConfig;
import org.apache.hc.client5.http.impl.classic.CloseableHttpClient;
import org.apache.hc.client5.http.impl.classic.HttpClients;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManager;
import org.apache.hc.client5.http.impl.io.PoolingHttpClientConnectionManagerBuilder;
import org.apache.hc.client5.http.io.HttpClientConnectionManager;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpHost;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.URIScheme;
import org.apache.hc.core5.http.io.entity.EntityUtils;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.http.message.StatusLine;
import org.apache.hc.core5.http.ssl.TLS;
import org.apache.hc.core5.util.TimeValue;
import org.apache.hc.core5.util.Timeout;

public class ClientConnectionConfig {
    public static final void main(String[] args) throws Exception {
        PoolingHttpClientConnectionManager cm = PoolingHttpClientConnectionManagerBuilder.create().setConnectionConfigResolver(route -> {
            if (route.isSecure()) {
                return ConnectionConfig.custom().setConnectTimeout(Timeout.ofMinutes((long)2L)).setSocketTimeout(Timeout.ofMinutes((long)2L)).setValidateAfterInactivity(TimeValue.ofMinutes((long)1L)).setTimeToLive(TimeValue.ofHours((long)1L)).build();
            }
            return ConnectionConfig.custom().setConnectTimeout(Timeout.ofMinutes((long)1L)).setSocketTimeout(Timeout.ofMinutes((long)1L)).setValidateAfterInactivity(TimeValue.ofSeconds((long)15L)).setTimeToLive(TimeValue.ofMinutes((long)15L)).build();
        }).setTlsConfigResolver(host -> {
            if (host.getSchemeName().equalsIgnoreCase("httpbin.org")) {
                return TlsConfig.custom().setSupportedProtocols(new TLS[]{TLS.V_1_3}).setHandshakeTimeout(Timeout.ofSeconds((long)10L)).build();
            }
            return TlsConfig.DEFAULT;
        }).build();
        try (CloseableHttpClient httpclient = HttpClients.custom().setConnectionManager((HttpClientConnectionManager)cm).build();){
            for (URIScheme uriScheme : URIScheme.values()) {
                ClassicHttpRequest request = ClassicRequestBuilder.get().setHttpHost(new HttpHost(uriScheme.id, "httpbin.org")).setPath("/headers").build();
                System.out.println("Executing request " + request);
                httpclient.execute(request, response -> {
                    System.out.println("----------------------------------------");
                    System.out.println(request + "->" + new StatusLine((HttpResponse)response));
                    EntityUtils.consume((HttpEntity)response.getEntity());
                    return null;
                });
            }
        }
    }
}

