/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.hc.client5.http.auth.AuthChallenge;
import org.apache.hc.client5.http.auth.AuthScheme;
import org.apache.hc.client5.http.auth.AuthScope;
import org.apache.hc.client5.http.auth.ChallengeType;
import org.apache.hc.client5.http.config.RequestConfig;
import org.apache.hc.client5.http.impl.DefaultAuthenticationStrategy;
import org.apache.hc.client5.http.impl.auth.BasicScheme;
import org.apache.hc.client5.http.impl.auth.BasicSchemeFactory;
import org.apache.hc.client5.http.impl.auth.CredentialsProviderBuilder;
import org.apache.hc.client5.http.impl.auth.DigestScheme;
import org.apache.hc.client5.http.impl.auth.DigestSchemeFactory;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.NameValuePair;
import org.apache.hc.core5.http.config.Lookup;
import org.apache.hc.core5.http.config.Registry;
import org.apache.hc.core5.http.config.RegistryBuilder;
import org.apache.hc.core5.http.message.BasicNameValuePair;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class TestAuthenticationStrategy {
    TestAuthenticationStrategy() {
    }

    @Test
    void testSelectInvalidInput() {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        HttpClientContext context = HttpClientContext.create();
        Assertions.assertThrows(NullPointerException.class, () -> authStrategy.select(null, Collections.emptyMap(), (HttpContext)context));
        Assertions.assertThrows(NullPointerException.class, () -> authStrategy.select(ChallengeType.TARGET, null, (HttpContext)context));
        Assertions.assertThrows(NullPointerException.class, () -> authStrategy.select(ChallengeType.TARGET, Collections.emptyMap(), null));
    }

    @Test
    void testSelectNoSchemeRegistry() {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        HttpClientContext context = HttpClientContext.create();
        HashMap<String, AuthChallenge> challenges = new HashMap<String, AuthChallenge>();
        challenges.put("Basic".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Basic", new NameValuePair[]{new BasicNameValuePair("realm", "test")}));
        challenges.put("Digest".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Digest", new NameValuePair[]{new BasicNameValuePair("realm", "test"), new BasicNameValuePair("nonce", "1234")}));
        List authSchemes = authStrategy.select(ChallengeType.TARGET, challenges, (HttpContext)context);
        Assertions.assertNotNull((Object)authSchemes);
        Assertions.assertEquals((int)0, (int)authSchemes.size());
    }

    @Test
    void testUnsupportedScheme() {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        HttpClientContext context = HttpClientContext.create();
        HashMap<String, AuthChallenge> challenges = new HashMap<String, AuthChallenge>();
        challenges.put("Basic".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Basic", new NameValuePair[]{new BasicNameValuePair("realm", "realm1")}));
        challenges.put("Digest".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Digest", new NameValuePair[]{new BasicNameValuePair("realm", "realm2"), new BasicNameValuePair("nonce", "1234")}));
        challenges.put("whatever", new AuthChallenge(ChallengeType.TARGET, "Whatever", new NameValuePair[]{new BasicNameValuePair("realm", "realm3")}));
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).build();
        context.setAuthSchemeRegistry((Lookup)authSchemeRegistry);
        context.setCredentialsProvider(CredentialsProviderBuilder.create().add(new AuthScope("somehost", 80), "user", "pwd".toCharArray()).build());
        List authSchemes = authStrategy.select(ChallengeType.TARGET, challenges, (HttpContext)context);
        Assertions.assertNotNull((Object)authSchemes);
        Assertions.assertEquals((int)2, (int)authSchemes.size());
        AuthScheme authScheme1 = (AuthScheme)authSchemes.get(0);
        Assertions.assertTrue((boolean)(authScheme1 instanceof DigestScheme));
        AuthScheme authScheme2 = (AuthScheme)authSchemes.get(1);
        Assertions.assertTrue((boolean)(authScheme2 instanceof BasicScheme));
    }

    @Test
    void testCustomAuthPreference() {
        DefaultAuthenticationStrategy authStrategy = new DefaultAuthenticationStrategy();
        RequestConfig config = RequestConfig.custom().setTargetPreferredAuthSchemes(Collections.singletonList("Basic")).build();
        HttpClientContext context = HttpClientContext.create();
        HashMap<String, AuthChallenge> challenges = new HashMap<String, AuthChallenge>();
        challenges.put("Basic".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Basic", new NameValuePair[]{new BasicNameValuePair("realm", "realm1")}));
        challenges.put("Digest".toLowerCase(Locale.ROOT), new AuthChallenge(ChallengeType.TARGET, "Digest", new NameValuePair[]{new BasicNameValuePair("realm", "realm2"), new BasicNameValuePair("nonce", "1234")}));
        Registry authSchemeRegistry = RegistryBuilder.create().register("Basic", (Object)BasicSchemeFactory.INSTANCE).register("Digest", (Object)DigestSchemeFactory.INSTANCE).build();
        context.setAuthSchemeRegistry((Lookup)authSchemeRegistry);
        context.setRequestConfig(config);
        context.setCredentialsProvider(CredentialsProviderBuilder.create().add(new AuthScope("somehost", 80), "user", "pwd".toCharArray()).build());
        List authSchemes = authStrategy.select(ChallengeType.TARGET, challenges, (HttpContext)context);
        Assertions.assertNotNull((Object)authSchemes);
        Assertions.assertEquals((int)1, (int)authSchemes.size());
        AuthScheme authScheme1 = (AuthScheme)authSchemes.get(0);
        Assertions.assertTrue((boolean)(authScheme1 instanceof BasicScheme));
    }
}

