/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.util.concurrent.Future;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hc.client5.http.impl.nio.H2SharingConnPool;
import org.apache.hc.core5.concurrent.BasicFuture;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.http.HttpConnection;
import org.apache.hc.core5.http.HttpVersion;
import org.apache.hc.core5.io.CloseMode;
import org.apache.hc.core5.io.ModalCloseable;
import org.apache.hc.core5.pool.ManagedConnPool;
import org.apache.hc.core5.pool.PoolEntry;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.MockitoAnnotations;
import org.mockito.verification.VerificationMode;

public class H2SharingConnPoolTest {
    static final String DEFAULT_ROUTE = "DEFAULT_ROUTE";
    @Mock
    ManagedConnPool<String, HttpConnection> connPool;
    @Mock
    FutureCallback<PoolEntry<String, HttpConnection>> callback;
    @Mock
    HttpConnection connection;
    H2SharingConnPool<String, HttpConnection> h2SharingPool;

    @BeforeEach
    void setup() {
        MockitoAnnotations.openMocks((Object)this);
        this.h2SharingPool = new H2SharingConnPool(this.connPool);
    }

    @Test
    void testLeaseFutureReturned() throws Exception {
        Mockito.when((Object)this.connPool.lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any())).thenReturn((Object)new BasicFuture(null));
        Future result = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, null, Timeout.ONE_MILLISECOND, this.callback);
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isDone());
        ((ManagedConnPool)Mockito.verify(this.connPool)).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.eq(null), (Timeout)Mockito.eq((Object)Timeout.ONE_MILLISECOND), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback, (VerificationMode)Mockito.never())).completed(Mockito.any());
    }

    @Test
    void testLeaseExistingConnectionReturned() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        HttpConnection conn = (HttpConnection)Mockito.mock(HttpConnection.class);
        Mockito.when((Object)conn.isOpen()).thenReturn((Object)true);
        poolEntry.assignConnection((ModalCloseable)conn);
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        routePool.track(poolEntry);
        Future future = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, null, Timeout.ONE_MILLISECOND, this.callback);
        Assertions.assertNotNull((Object)future);
        Assertions.assertSame((Object)poolEntry, future.get());
        ((ManagedConnPool)Mockito.verify(this.connPool, (VerificationMode)Mockito.never())).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback)).completed(Mockito.same((Object)poolEntry));
    }

    @Test
    void testLeaseWithStateCacheBypassed() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        routePool.track(poolEntry);
        Mockito.when((Object)this.connPool.lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any())).thenReturn((Object)new BasicFuture(null));
        Future result = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, (Object)"stuff", Timeout.ONE_MILLISECOND, this.callback);
        Assertions.assertNotNull((Object)result);
        Assertions.assertFalse((boolean)result.isDone());
        ((ManagedConnPool)Mockito.verify(this.connPool)).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.eq((Object)"stuff"), (Timeout)Mockito.eq((Object)Timeout.ONE_MILLISECOND), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback, (VerificationMode)Mockito.never())).completed(Mockito.any());
    }

    @Test
    void testLeaseNewConnectionReturnedAndCached() throws Exception {
        AtomicReference futureRef = new AtomicReference();
        Mockito.when((Object)this.connPool.lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any())).thenAnswer(invocationOnMock -> {
            BasicFuture future = new BasicFuture((FutureCallback)invocationOnMock.getArgument(3));
            futureRef.set(future);
            return future;
        });
        Future result = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, null, Timeout.ONE_MILLISECOND, this.callback);
        BasicFuture future = (BasicFuture)futureRef.get();
        Assertions.assertNotNull((Object)future);
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.getProtocolVersion()).thenReturn((Object)HttpVersion.HTTP_2);
        future.completed((Object)poolEntry);
        Assertions.assertTrue((boolean)result.isDone());
        ((ManagedConnPool)Mockito.verify(this.connPool)).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.eq(null), (Timeout)Mockito.eq((Object)Timeout.ONE_MILLISECOND), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback)).completed(Mockito.any());
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        Assertions.assertEquals((long)1L, (long)routePool.getCount(poolEntry));
    }

    @Test
    void testLeaseNewConnectionReturnedAndNotCached() throws Exception {
        AtomicReference futureRef = new AtomicReference();
        Mockito.when((Object)this.connPool.lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any())).thenAnswer(invocationOnMock -> {
            BasicFuture future = new BasicFuture((FutureCallback)invocationOnMock.getArgument(3));
            futureRef.set(future);
            return future;
        });
        Future result = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, null, Timeout.ONE_MILLISECOND, this.callback);
        BasicFuture future = (BasicFuture)futureRef.get();
        Assertions.assertNotNull((Object)future);
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.getProtocolVersion()).thenReturn((Object)HttpVersion.HTTP_1_1);
        future.completed((Object)poolEntry);
        Assertions.assertTrue((boolean)result.isDone());
        ((ManagedConnPool)Mockito.verify(this.connPool)).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.eq(null), (Timeout)Mockito.eq((Object)Timeout.ONE_MILLISECOND), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback)).completed(Mockito.any());
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        Assertions.assertEquals((long)0L, (long)routePool.getCount(poolEntry));
    }

    @Test
    void testLeaseNoConnection() throws Exception {
        AtomicReference futureRef = new AtomicReference();
        Mockito.when((Object)this.connPool.lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any())).thenAnswer(invocationOnMock -> {
            BasicFuture future = new BasicFuture((FutureCallback)invocationOnMock.getArgument(3));
            futureRef.set(future);
            return future;
        });
        Future result = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, null, Timeout.ONE_MILLISECOND, this.callback);
        BasicFuture future = (BasicFuture)futureRef.get();
        Assertions.assertNotNull((Object)future);
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.discardConnection(CloseMode.IMMEDIATE);
        future.completed((Object)poolEntry);
        Assertions.assertTrue((boolean)result.isDone());
        ((ManagedConnPool)Mockito.verify(this.connPool)).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.eq(null), (Timeout)Mockito.eq((Object)Timeout.ONE_MILLISECOND), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback)).completed(Mockito.any());
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        Assertions.assertEquals((long)0L, (long)routePool.getCount(poolEntry));
    }

    @Test
    void testLeaseWithStateNewConnectionReturnedAndNotCached() throws Exception {
        AtomicReference futureRef = new AtomicReference();
        Mockito.when((Object)this.connPool.lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.any(), (Timeout)Mockito.any(), (FutureCallback)Mockito.any())).thenAnswer(invocationOnMock -> {
            BasicFuture future = new BasicFuture((FutureCallback)invocationOnMock.getArgument(3));
            futureRef.set(future);
            return future;
        });
        Future result = this.h2SharingPool.lease((Object)DEFAULT_ROUTE, (Object)"stuff", Timeout.ONE_MILLISECOND, this.callback);
        BasicFuture future = (BasicFuture)futureRef.get();
        Assertions.assertNotNull((Object)future);
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.getProtocolVersion()).thenReturn((Object)HttpVersion.HTTP_2);
        future.completed((Object)poolEntry);
        Assertions.assertTrue((boolean)result.isDone());
        ((ManagedConnPool)Mockito.verify(this.connPool)).lease(Mockito.eq((Object)DEFAULT_ROUTE), Mockito.eq((Object)"stuff"), (Timeout)Mockito.eq((Object)Timeout.ONE_MILLISECOND), (FutureCallback)Mockito.any());
        ((FutureCallback)Mockito.verify(this.callback)).completed(Mockito.any());
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        Assertions.assertEquals((long)0L, (long)routePool.getCount(poolEntry));
    }

    @Test
    void testReleaseReusableNoCacheReturnedToPool() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.isOpen()).thenReturn((Object)true);
        this.h2SharingPool.release(poolEntry, true);
        ((ManagedConnPool)Mockito.verify(this.connPool)).release((PoolEntry)Mockito.same((Object)poolEntry), Mockito.eq((boolean)true));
    }

    @Test
    void testReleaseReusableNotInCacheReturnedToPool() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.isOpen()).thenReturn((Object)true);
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        routePool.track(poolEntry);
        this.h2SharingPool.release(poolEntry, true);
        ((ManagedConnPool)Mockito.verify(this.connPool)).release((PoolEntry)Mockito.same((Object)poolEntry), Mockito.eq((boolean)true));
    }

    @Test
    void testReleaseReusableInCacheNotReturnedToPool() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.isOpen()).thenReturn((Object)true);
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        routePool.track(poolEntry);
        routePool.track(poolEntry);
        this.h2SharingPool.release(poolEntry, true);
        ((ManagedConnPool)Mockito.verify(this.connPool, (VerificationMode)Mockito.never())).release((PoolEntry)Mockito.same((Object)poolEntry), Mockito.anyBoolean());
    }

    @Test
    void testReleaseNonReusableNotInCacheReturnedToPool() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.isOpen()).thenReturn((Object)false);
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        routePool.track(poolEntry);
        routePool.track(poolEntry);
        AtomicReference<HttpConnection> connRef = new AtomicReference<HttpConnection>(this.connection);
        ((ManagedConnPool)Mockito.doAnswer(invocation -> {
            PoolEntry entry = (PoolEntry)invocation.getArgument(0);
            if (!connRef.compareAndSet((HttpConnection)entry.getConnection(), (HttpConnection)null)) {
                throw new IllegalStateException("Pool entry is not present in the set of leased entries");
            }
            return null;
        }).when(this.connPool)).release((PoolEntry)Mockito.eq((Object)poolEntry), Mockito.anyBoolean());
        this.h2SharingPool.release(poolEntry, false);
        Assertions.assertThrows(IllegalStateException.class, () -> this.h2SharingPool.release(poolEntry, false));
    }

    @Test
    void testClose() throws Exception {
        this.h2SharingPool.close();
        ((ManagedConnPool)Mockito.verify(this.connPool)).close();
    }

    @Test
    void testCloseMode() throws Exception {
        this.h2SharingPool.close(CloseMode.IMMEDIATE);
        ((ManagedConnPool)Mockito.verify(this.connPool)).close(CloseMode.IMMEDIATE);
    }

    @Test
    void testLeasePoolClosed() throws Exception {
        this.h2SharingPool.close();
        Assertions.assertThrows(IllegalStateException.class, () -> this.h2SharingPool.lease((Object)DEFAULT_ROUTE, null, Timeout.ONE_MILLISECOND, this.callback));
    }

    @Test
    void testReleasePoolClosed() throws Exception {
        PoolEntry poolEntry = new PoolEntry((Object)DEFAULT_ROUTE);
        poolEntry.assignConnection((ModalCloseable)this.connection);
        Mockito.when((Object)this.connection.isOpen()).thenReturn((Object)false);
        H2SharingConnPool.PerRoutePool routePool = this.h2SharingPool.getPerRoutePool((Object)DEFAULT_ROUTE);
        routePool.track(poolEntry);
        this.h2SharingPool.close();
        this.h2SharingPool.release(poolEntry, true);
        ((ManagedConnPool)Mockito.verify(this.connPool)).release((PoolEntry)Mockito.same((Object)poolEntry), Mockito.eq((boolean)true));
    }
}

