/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.impl.nio;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.apache.hc.client5.http.DnsResolver;
import org.apache.hc.client5.http.impl.nio.MultihomeIOSessionRequester;
import org.apache.hc.core5.concurrent.FutureCallback;
import org.apache.hc.core5.net.NamedEndpoint;
import org.apache.hc.core5.reactor.ConnectionInitiator;
import org.apache.hc.core5.reactor.IOSession;
import org.apache.hc.core5.util.Timeout;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MultihomeIOSessionRequesterTest {
    private DnsResolver dnsResolver;
    private ConnectionInitiator connectionInitiator;
    private MultihomeIOSessionRequester sessionRequester;
    private NamedEndpoint namedEndpoint;

    MultihomeIOSessionRequesterTest() {
    }

    @BeforeEach
    void setUp() {
        this.dnsResolver = (DnsResolver)Mockito.mock(DnsResolver.class);
        this.connectionInitiator = (ConnectionInitiator)Mockito.mock(ConnectionInitiator.class);
        this.namedEndpoint = (NamedEndpoint)Mockito.mock(NamedEndpoint.class);
        this.sessionRequester = new MultihomeIOSessionRequester(this.dnsResolver);
    }

    @Test
    void testConnectWithMultipleAddresses() throws Exception {
        InetAddress address1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress address2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        List<InetSocketAddress> remoteAddresses = Arrays.asList(new InetSocketAddress(address1, 8080), new InetSocketAddress(address2, 8080));
        Mockito.when((Object)this.namedEndpoint.getHostName()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.namedEndpoint.getPort()).thenReturn((Object)8080);
        Mockito.when((Object)this.dnsResolver.resolve("somehost", 8080)).thenReturn(remoteAddresses);
        Mockito.when((Object)this.connectionInitiator.connect((NamedEndpoint)ArgumentMatchers.any(), (SocketAddress)ArgumentMatchers.any(), (SocketAddress)ArgumentMatchers.any(), (Timeout)ArgumentMatchers.any(), ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.any())).thenAnswer(invocation -> {
            FutureCallback callback = (FutureCallback)invocation.getArgument(5);
            CompletableFuture future = new CompletableFuture();
            callback.failed((Exception)new IOException("Simulated connection failure"));
            future.completeExceptionally(new IOException("Simulated connection failure"));
            return future;
        });
        Future future = this.sessionRequester.connect(this.connectionInitiator, this.namedEndpoint, null, Timeout.ofMilliseconds((long)500L), null, null);
        Assertions.assertTrue((boolean)future.isDone());
        try {
            future.get();
            Assertions.fail((String)"Expected ExecutionException");
        }
        catch (ExecutionException ex) {
            Assertions.assertInstanceOf(IOException.class, (Object)ex.getCause());
            Assertions.assertEquals((Object)"Simulated connection failure", (Object)ex.getCause().getMessage());
        }
    }

    @Test
    void testConnectSuccessfulAfterRetries() throws Exception {
        InetAddress address1 = InetAddress.getByAddress(new byte[]{10, 0, 0, 1});
        InetAddress address2 = InetAddress.getByAddress(new byte[]{10, 0, 0, 2});
        List<InetSocketAddress> remoteAddresses = Arrays.asList(new InetSocketAddress(address1, 8080), new InetSocketAddress(address2, 8080));
        Mockito.when((Object)this.namedEndpoint.getHostName()).thenReturn((Object)"somehost");
        Mockito.when((Object)this.namedEndpoint.getPort()).thenReturn((Object)8080);
        Mockito.when((Object)this.dnsResolver.resolve("somehost", 8080)).thenReturn(remoteAddresses);
        Mockito.when((Object)this.connectionInitiator.connect((NamedEndpoint)ArgumentMatchers.any(), (SocketAddress)ArgumentMatchers.any(), (SocketAddress)ArgumentMatchers.any(), (Timeout)ArgumentMatchers.any(), ArgumentMatchers.any(), (FutureCallback)ArgumentMatchers.any())).thenAnswer(invocation -> {
            FutureCallback callback = (FutureCallback)invocation.getArgument(5);
            InetSocketAddress remoteAddress = (InetSocketAddress)invocation.getArgument(1);
            CompletableFuture<IOSession> future = new CompletableFuture<IOSession>();
            if (remoteAddress.getAddress().equals(address1)) {
                callback.failed((Exception)new IOException("Simulated connection failure"));
                future.completeExceptionally(new IOException("Simulated connection failure"));
            } else {
                IOSession mockSession = (IOSession)Mockito.mock(IOSession.class);
                callback.completed((Object)mockSession);
                future.complete(mockSession);
            }
            return future;
        });
        Future future = this.sessionRequester.connect(this.connectionInitiator, this.namedEndpoint, null, Timeout.ofMilliseconds((long)500L), null, null);
        Assertions.assertTrue((boolean)future.isDone());
        try {
            IOSession session = (IOSession)future.get();
            Assertions.assertNotNull((Object)session);
        }
        catch (ExecutionException ex) {
            Assertions.fail((String)"Did not expect an ExecutionException", (Throwable)ex);
        }
    }
}

