/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hc.client5.http.protocol;

import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.client5.http.protocol.NextNonceInterceptor;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpResponse;
import org.apache.hc.core5.http.message.BasicHeader;
import org.apache.hc.core5.http.message.BasicHttpResponse;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

class TestNextNonceInterceptor {
    private static final String AUTHENTICATION_INFO_HEADER = "Authentication-Info";
    private NextNonceInterceptor interceptor;
    private HttpClientContext context;

    TestNextNonceInterceptor() {
    }

    @BeforeEach
    void setUp() {
        this.interceptor = new NextNonceInterceptor();
        this.context = HttpClientContext.create();
    }

    @Test
    void testNoAuthenticationInfoHeader() {
        BasicHttpResponse response = new BasicHttpResponse(200);
        this.interceptor.process((HttpResponse)response, null, (HttpContext)this.context);
        Assertions.assertNull((Object)this.context.getNextNonce(), (String)"Context should not contain nextnonce when the header is missing");
    }

    @Test
    void testAuthenticationInfoHeaderWithoutNextNonce() {
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader((Header)new BasicHeader(AUTHENTICATION_INFO_HEADER, (Object)"auth-param=value"));
        this.interceptor.process((HttpResponse)response, null, (HttpContext)this.context);
        Assertions.assertNull((Object)this.context.getNextNonce(), (String)"Context should not contain nextnonce when it is missing in the header value");
    }

    @Test
    void testAuthenticationInfoHeaderWithNextNonce() {
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader((Header)new BasicHeader(AUTHENTICATION_INFO_HEADER, (Object)"nextnonce=\"10024b2308596a55d02699c0a0400fb4\",qop=auth,rspauth=\"0386df3cb9effdf08c9e00ab955827f3\",cnonce=\"21558090\",nc=00000001"));
        this.interceptor.process((HttpResponse)response, null, (HttpContext)this.context);
        Assertions.assertEquals((Object)"10024b2308596a55d02699c0a0400fb4", (Object)this.context.getNextNonce(), (String)"Context should contain the correct nextnonce value when it is present in the header");
    }

    @Test
    void testMultipleAuthenticationInfoHeaders() {
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader((Header)new BasicHeader(AUTHENTICATION_INFO_HEADER, (Object)"auth-param=value"));
        response.addHeader((Header)new BasicHeader(AUTHENTICATION_INFO_HEADER, (Object)"nextnonce=\"10024b2308596a55d02699c0a0400fb4\",qop=auth,rspauth=\"0386df3cb9effdf08c9e00ab955827f3\",cnonce=\"21558090\",nc=00000001"));
        this.interceptor.process((HttpResponse)response, null, (HttpContext)this.context);
        Assertions.assertNull((Object)this.context.getNextNonce(), (String)"Context should not contain nextnonce if it's not in the first Authentication-Info header");
    }

    @Test
    void testAuthenticationInfoHeaderWithEmptyNextNonce() {
        BasicHttpResponse response = new BasicHttpResponse(200);
        response.addHeader((Header)new BasicHeader(AUTHENTICATION_INFO_HEADER, (Object)"nextnonce=\"\",qop=auth,rspauth=\"0386df3cb9effdf08c9e00ab955827f3\",cnonce=\"21558090\",nc=00000001"));
        this.interceptor.process((HttpResponse)response, null, (HttpContext)this.context);
        Assertions.assertNull((Object)this.context.getNextNonce(), (String)"Context should not contain nextnonce if it is empty in the Authentication-Info header");
    }
}

