/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.params;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.conn.HttpRoute;
import org.apache.http.params.HttpParams;

public final class HttpConnectionManagerParams {
    public static final int DEFAULT_MAX_HOST_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_TOTAL_CONNECTIONS = 20;
    private static final String ROUTE_DEFAULT = "*Route*Default*";

    public static void setDefaultMaxConnectionsPerHost(HttpParams params, int max) {
        HttpConnectionManagerParams.setMaxPerHost(params, ROUTE_DEFAULT, max);
    }

    public static void setMaxConnectionsPerHost(HttpParams params, HttpRoute route, int max) {
        if (route == null) {
            throw new IllegalArgumentException("Route must not be null.");
        }
        HttpConnectionManagerParams.setMaxPerHost(params, route, max);
    }

    private static void setMaxPerHost(HttpParams params, Object key, int max) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters must not be null.");
        }
        if (max <= 0) {
            throw new IllegalArgumentException("The maximum must be greater than 0.");
        }
        Map currentValues = (Map)params.getParameter("http.connection-manager.max-per-host");
        HashMap<Object, Integer> newValues = null;
        newValues = currentValues == null ? new HashMap<Object, Integer>() : new HashMap(currentValues);
        newValues.put(key, new Integer(max));
        params.setParameter("http.connection-manager.max-per-host", newValues);
    }

    public static int getDefaultMaxConnectionsPerHost(HttpParams params) {
        return HttpConnectionManagerParams.getMaxPerHost(params, ROUTE_DEFAULT);
    }

    public static int getMaxConnectionsPerHost(HttpParams params, HttpRoute route) {
        if (route == null) {
            throw new IllegalArgumentException("Route must not be null.");
        }
        return HttpConnectionManagerParams.getMaxPerHost(params, route);
    }

    private static int getMaxPerHost(HttpParams params, Object key) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters must not be null.");
        }
        int result = 2;
        Map m = (Map)params.getParameter("http.connection-manager.max-per-host");
        if (m != null) {
            Integer max = (Integer)m.get(key);
            if (max == null && key != ROUTE_DEFAULT) {
                max = (Integer)m.get(ROUTE_DEFAULT);
            }
            if (max != null) {
                result = max;
            }
        }
        return result;
    }

    public static void setMaxTotalConnections(HttpParams params, int maxTotalConnections) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters must not be null.");
        }
        params.setIntParameter("http.connection-manager.max-total", maxTotalConnections);
    }

    public static int getMaxTotalConnections(HttpParams params) {
        if (params == null) {
            throw new IllegalArgumentException("HTTP parameters must not be null.");
        }
        return params.getIntParameter("http.connection-manager.max-total", 20);
    }
}

