/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpRoute;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.impl.conn.IdleConnectionHandler;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPoolEntryRef;
import org.apache.http.impl.conn.tsccm.RefQueueHandler;
import org.apache.http.impl.conn.tsccm.RefQueueWorker;
import org.apache.http.params.HttpParams;

public abstract class AbstractConnPool
implements RefQueueHandler {
    private final Log LOG = LogFactory.getLog((Class)AbstractConnPool.class);
    protected Set issuedConnections;
    protected IdleConnectionHandler idleConnHandler;
    protected int numConnections;
    protected HttpParams params;
    protected ConnMgrRef connManager;
    protected ReferenceQueue refQueue;
    private RefQueueWorker refWorker;
    protected volatile boolean isShutDown;

    protected AbstractConnPool(ClientConnectionManager mgr) {
        this.params = mgr.getParams();
        this.issuedConnections = new HashSet();
        this.idleConnHandler = new IdleConnectionHandler();
        boolean conngc = true;
        if (conngc) {
            this.refQueue = new ReferenceQueue();
            this.refWorker = new RefQueueWorker(this.refQueue, this);
            Thread t = new Thread(this.refWorker);
            t.setDaemon(true);
            t.setName("RefQueueWorker@" + this);
            t.start();
        }
        this.connManager = new ConnMgrRef(mgr, this.refQueue);
    }

    public abstract BasicPoolEntry getEntry(HttpRoute var1, long var2, ClientConnectionOperator var4) throws ConnectionPoolTimeoutException, InterruptedException;

    public abstract void freeEntry(BasicPoolEntry var1);

    public synchronized void handleReference(Reference ref) {
        if (ref instanceof BasicPoolEntryRef) {
            boolean lost = this.issuedConnections.remove(ref);
            if (lost) {
                HttpRoute route = ((BasicPoolEntryRef)ref).getRoute();
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Connection garbage collected. " + route));
                }
                this.handleLostEntry(route);
            }
        } else if (ref instanceof ConnMgrRef) {
            if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Connection manager garbage collected. ");
            }
            this.shutdown();
        }
    }

    protected abstract void handleLostEntry(HttpRoute var1);

    public synchronized void closeIdleConnections(long idletime) {
        this.idleConnHandler.closeIdleConnections(idletime);
    }

    public abstract void deleteClosedConnections();

    public synchronized void shutdown() {
        if (this.isShutDown) {
            return;
        }
        if (this.refWorker != null) {
            this.refWorker.shutdown();
        }
        Iterator iter = this.issuedConnections.iterator();
        while (iter.hasNext()) {
            BasicPoolEntryRef per = (BasicPoolEntryRef)iter.next();
            iter.remove();
            BasicPoolEntry entry = (BasicPoolEntry)per.get();
            if (entry == null) continue;
            this.closeConnection(entry.getConnection());
        }
        this.idleConnHandler.removeAll();
        this.isShutDown = true;
    }

    protected void closeConnection(OperatedClientConnection conn) {
        if (conn != null) {
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.LOG.debug((Object)"I/O error closing connection", (Throwable)ex);
            }
        }
    }

    private static class ConnMgrRef
    extends WeakReference {
        public ConnMgrRef(ClientConnectionManager ccmgr, ReferenceQueue queue) {
            super(ccmgr, queue);
        }
    }
}

