/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;

public class URLUtils {
    private static final String DEFAULT_CHARSET = "ISO-8859-1";

    public static String simpleFormUrlEncode(NameValuePair[] pairs, String charset) {
        try {
            return URLUtils.formUrlEncode(pairs, charset);
        }
        catch (UnsupportedEncodingException e) {
            try {
                return URLUtils.formUrlEncode(pairs, DEFAULT_CHARSET);
            }
            catch (UnsupportedEncodingException fatal) {
                throw new Error("HttpClient requires ISO-8859-1 support");
            }
        }
    }

    public static String formUrlEncode(NameValuePair[] pairs, String charset) throws UnsupportedEncodingException {
        StringBuilder buf = new StringBuilder();
        for (int i = 0; i < pairs.length; ++i) {
            URLCodec codec = new URLCodec();
            NameValuePair pair = pairs[i];
            if (pair.getName() == null) continue;
            if (i > 0) {
                buf.append("&");
            }
            buf.append(codec.encode(pair.getName(), charset));
            buf.append("=");
            if (pair.getValue() == null) continue;
            buf.append(codec.encode(pair.getValue(), charset));
        }
        return buf.toString();
    }

    public static URI createURI(String scheme, String host, int port, String path, String query, String fragment) throws URISyntaxException {
        StringBuilder buffer = new StringBuilder();
        if (host != null) {
            if (scheme != null) {
                buffer.append(scheme);
                buffer.append("://");
            }
            buffer.append(host);
            if (port > 0) {
                buffer.append(":");
                buffer.append(port);
            }
        }
        if (path == null || !path.startsWith("/")) {
            buffer.append("/");
        }
        if (path != null) {
            buffer.append(path);
        }
        if (query != null) {
            buffer.append("?");
            buffer.append(query);
        }
        if (fragment != null) {
            buffer.append("#");
            buffer.append(fragment);
        }
        return new URI(buffer.toString());
    }

    public static URI rewriteURI(URI uri, HttpHost target, boolean dropFragment) throws URISyntaxException {
        if (uri == null) {
            throw new IllegalArgumentException("URI may nor be null");
        }
        if (target != null) {
            return URLUtils.createURI(target.getSchemeName(), target.getHostName(), target.getPort(), uri.getRawPath(), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
        }
        return URLUtils.createURI(null, null, -1, uri.getRawPath(), uri.getRawQuery(), dropFragment ? null : uri.getRawFragment());
    }

    public static URI rewriteURI(URI uri, HttpHost target) throws URISyntaxException {
        return URLUtils.rewriteURI(uri, target, false);
    }

    private URLUtils() {
    }
}

