/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HttpResponse;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.CharArrayBuffer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthenticationHandler
implements AuthenticationHandler {
    private static final Log LOG = LogFactory.getLog(AbstractAuthenticationHandler.class);
    private static List<String> DEFAULT_SCHEME_PRIORITY = Arrays.asList("digest", "basic");

    protected Map<String, Header> parseChallenges(Header[] headers) throws MalformedChallengeException {
        HashMap<String, Header> map = new HashMap<String, Header>(headers.length);
        for (int i = 0; i < headers.length; ++i) {
            int pos;
            CharArrayBuffer buffer;
            Header header = headers[i];
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                pos = ((FormattedHeader)header).getValuePos();
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedChallengeException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                pos = 0;
            }
            while (pos < buffer.length() && HTTP.isWhitespace((char)buffer.charAt(pos))) {
                ++pos;
            }
            int beginIndex = pos;
            while (pos < buffer.length() && !HTTP.isWhitespace((char)buffer.charAt(pos))) {
                ++pos;
            }
            int endIndex = pos;
            String s = buffer.substring(beginIndex, endIndex);
            map.put(s.toLowerCase(), header);
        }
        return map;
    }

    protected List<String> getAuthPreferences() {
        return DEFAULT_SCHEME_PRIORITY;
    }

    @Override
    public AuthScheme selectScheme(Map<String, Header> challenges, HttpResponse response, HttpContext context) throws AuthenticationException {
        AuthSchemeRegistry registry = (AuthSchemeRegistry)context.getAttribute("http.authscheme-registry");
        if (registry == null) {
            throw new IllegalStateException("AuthScheme registry not set in HTTP context");
        }
        List<String> authPrefs = this.getAuthPreferences();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Supported authentication schemes in the order of preference: " + authPrefs));
        }
        AuthScheme authScheme = null;
        for (String id : authPrefs) {
            Header challenge = challenges.get(id.toLowerCase());
            if (challenge != null) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)(id + " authentication scheme selected"));
                }
                try {
                    authScheme = registry.getAuthScheme(id, response.getParams());
                    break;
                }
                catch (IllegalStateException e) {
                    throw new AuthenticationException(e.getMessage());
                }
            }
            if (!LOG.isDebugEnabled()) continue;
            LOG.debug((Object)("Challenge for " + id + " authentication scheme not available"));
        }
        if (authScheme == null) {
            throw new AuthenticationException("Unable to respond to any of these challenges: " + challenges);
        }
        return authScheme;
    }
}

