/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.params.HttpConnectionManagerParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThread;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConnPoolByRoute
extends AbstractConnPool {
    private final Log LOG = LogFactory.getLog(ConnPoolByRoute.class);
    protected Queue<BasicPoolEntry> freeConnections = this.createFreeConnQueue();
    protected Queue<WaitingThread> waitingThreads = this.createWaitingThreadQueue();
    protected final Map<HttpRoute, RouteSpecificPool> routeToPool = this.createRouteToPoolMap();

    public ConnPoolByRoute(ClientConnectionManager mgr) {
        super(mgr);
    }

    protected Queue<BasicPoolEntry> createFreeConnQueue() {
        return new LinkedList<BasicPoolEntry>();
    }

    protected Queue<WaitingThread> createWaitingThreadQueue() {
        return new LinkedList<WaitingThread>();
    }

    protected Map<HttpRoute, RouteSpecificPool> createRouteToPoolMap() {
        return new HashMap<HttpRoute, RouteSpecificPool>();
    }

    protected RouteSpecificPool newRouteSpecificPool(HttpRoute route) {
        return new RouteSpecificPool(route);
    }

    protected WaitingThread newWaitingThread(Condition cond, RouteSpecificPool rospl) {
        return new WaitingThread(cond, rospl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RouteSpecificPool getRoutePool(HttpRoute route, boolean create) {
        RouteSpecificPool rospl = null;
        try {
            this.poolLock.lock();
            rospl = this.routeToPool.get(route);
            if (rospl == null && create) {
                rospl = this.newRouteSpecificPool(route);
                this.routeToPool.put(route, rospl);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return rospl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getConnectionsInPool(HttpRoute route) {
        try {
            this.poolLock.lock();
            RouteSpecificPool rospl = this.getRoutePool(route, false);
            int n = rospl != null ? rospl.getEntryCount() : 0;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BasicPoolEntry getEntry(HttpRoute route, long timeout, TimeUnit tunit, ClientConnectionOperator operator) throws ConnectionPoolTimeoutException, InterruptedException {
        int maxHostConnections = HttpConnectionManagerParams.getMaxConnectionsPerHost(this.params, route);
        int maxTotalConnections = HttpConnectionManagerParams.getMaxTotalConnections(this.params);
        Date deadline = null;
        if (timeout > 0L) {
            deadline = new Date(System.currentTimeMillis() + tunit.toMillis(timeout));
        }
        BasicPoolEntry entry = null;
        try {
            this.poolLock.lock();
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            WaitingThread waitingThread = null;
            while (entry == null) {
                if (this.isShutDown) {
                    throw new IllegalStateException("Connection pool shut down.");
                }
                entry = this.getFreeEntry(rospl);
                if (entry != null) continue;
                if (rospl.getEntryCount() < maxHostConnections && this.numConnections < maxTotalConnections) {
                    entry = this.createEntry(rospl, operator);
                    continue;
                }
                if (rospl.getEntryCount() < maxHostConnections && this.freeConnections.size() > 0) {
                    this.deleteLeastUsedEntry();
                    entry = this.createEntry(rospl, operator);
                    continue;
                }
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Need to wait for connection. " + route));
                }
                if (waitingThread == null) {
                    waitingThread = this.newWaitingThread(this.poolLock.newCondition(), rospl);
                }
                boolean success = false;
                try {
                    rospl.queueThread(waitingThread);
                    this.waitingThreads.add(waitingThread);
                    success = waitingThread.await(deadline);
                }
                finally {
                    if (!success) {
                        rospl.removeThread(waitingThread);
                        this.waitingThreads.remove(waitingThread);
                    }
                }
                if (success || deadline == null || deadline.getTime() > System.currentTimeMillis()) continue;
                throw new ConnectionPoolTimeoutException("Timeout waiting for connection");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void freeEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Freeing connection. " + route));
        }
        try {
            this.poolLock.lock();
            if (this.isShutDown) {
                this.closeConnection(entry.getConnection());
                return;
            }
            this.issuedConnections.remove(entry.getWeakRef());
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.freeEntry(entry);
            this.freeConnections.add(entry);
            if (this.numConnections == 0) {
                this.LOG.error((Object)("Master connection pool not found. " + route));
                this.numConnections = 1;
            }
            this.idleConnHandler.add((HttpConnection)entry.getConnection());
            this.notifyWaitingThread(rospl);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry getFreeEntry(RouteSpecificPool rospl) {
        BasicPoolEntry entry = null;
        try {
            this.poolLock.lock();
            entry = rospl.allocEntry();
            if (entry != null) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Getting free connection. " + rospl.getRoute()));
                }
                this.freeConnections.remove(entry);
                this.idleConnHandler.remove((HttpConnection)entry.getConnection());
                this.issuedConnections.add(entry.getWeakRef());
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)("No free connections. " + rospl.getRoute()));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Creating new connection. " + rospl.getRoute()));
        }
        BasicPoolEntry entry = new BasicPoolEntry(op, rospl.getRoute(), this.refQueue);
        try {
            this.poolLock.lock();
            rospl.createdEntry(entry);
            ++this.numConnections;
            this.issuedConnections.add(entry.getWeakRef());
        }
        finally {
            this.poolLock.unlock();
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.LOG.isDebugEnabled()) {
            this.LOG.debug((Object)("Deleting connection. " + route));
        }
        try {
            this.poolLock.lock();
            this.closeConnection(entry.getConnection());
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.deleteEntry(entry);
            --this.numConnections;
            if (rospl.isUnused()) {
                this.routeToPool.remove(route);
            }
            this.idleConnHandler.remove((HttpConnection)entry.getConnection());
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteLeastUsedEntry() {
        try {
            this.poolLock.lock();
            BasicPoolEntry entry = this.freeConnections.remove();
            if (entry != null) {
                this.deleteEntry(entry);
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"No free connection to delete.");
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handleLostEntry(HttpRoute route) {
        try {
            this.poolLock.lock();
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.dropEntry();
            if (rospl.isUnused()) {
                this.routeToPool.remove(route);
            }
            --this.numConnections;
            this.notifyWaitingThread(rospl);
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyWaitingThread(RouteSpecificPool rospl) {
        WaitingThread waitingThread = null;
        try {
            this.poolLock.lock();
            if (rospl != null && rospl.hasThread()) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)("Notifying thread waiting on pool. " + rospl.getRoute()));
                }
                waitingThread = rospl.dequeueThread();
                this.waitingThreads.remove(waitingThread);
            } else if (!this.waitingThreads.isEmpty()) {
                if (this.LOG.isDebugEnabled()) {
                    this.LOG.debug((Object)"Notifying thread waiting on any pool.");
                }
                waitingThread = this.waitingThreads.remove();
                waitingThread.getPool().removeThread(waitingThread);
            } else if (this.LOG.isDebugEnabled()) {
                this.LOG.debug((Object)"Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                waitingThread.wakeup();
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void deleteClosedConnections() {
        try {
            this.poolLock.lock();
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)iter.next();
                if (entry.getConnection().isOpen()) continue;
                iter.remove();
                this.deleteEntry(entry);
            }
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        try {
            this.poolLock.lock();
            super.shutdown();
            Iterator ibpe = this.freeConnections.iterator();
            while (ibpe.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)ibpe.next();
                ibpe.remove();
                this.closeConnection(entry.getConnection());
            }
            Iterator iwth = this.waitingThreads.iterator();
            while (iwth.hasNext()) {
                WaitingThread waiter = (WaitingThread)iwth.next();
                iwth.remove();
                waiter.wakeup();
            }
            this.routeToPool.clear();
        }
        finally {
            this.poolLock.unlock();
        }
    }
}

