/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.client.utils;

import org.apache.http.client.utils.Rfc3492Idn;
import org.junit.Assert;
import org.junit.Test;

public class TestRfc3492Idn {
    @Test
    public void testDecode() throws Exception {
        Rfc3492Idn idn = new Rfc3492Idn();
        Assert.assertEquals((Object)"\u0644\u064a\u0647\u0645\u0627\u0628\u062a\u0643\u0644\u0645\u0648\u0634\u0639\u0631\u0628\u064a\u061f", (Object)idn.decode("egbpdaj6bu4bxfgehfvwxn"));
        Assert.assertEquals((Object)"\u4ed6\u4eec\u4e3a\u4ec0\u4e48\u4e0d\u8bf4\u4e2d\u6587", (Object)idn.decode("ihqwcrb4cv8a8dqg056pqjye"));
        Assert.assertEquals((Object)"\u043f\u043e\u0447\u0435\u043c\u0443\u0436\u0435\u043e\u043d\u0438\u043d\u0435\u0433\u043e\u0432\u043e\u0440\u044f\u0442\u043f\u043e\u0440\u0443\u0441\u0441\u043a\u0438", (Object)idn.decode("b1abfaaepdrnnbgefbaDotcwatmq2g4l"));
        Assert.assertEquals((Object)"Maji\u3067Koi\u3059\u308b5\u79d2\u524d", (Object)idn.decode("MajiKoi5-783gue6qz075azm5e"));
    }

    @Test
    public void testToUnicode() throws Exception {
        Rfc3492Idn idn = new Rfc3492Idn();
        Assert.assertEquals((Object)"\u0644\u064a\u0647\u0645\u0627\u0628\u062a\u0643\u0644\u0645\u0648\u0634\u0639\u0631\u0628\u064a\u061f", (Object)idn.toUnicode("xn--egbpdaj6bu4bxfgehfvwxn"));
        Assert.assertEquals((Object)"www.z\u00fcrich.ch", (Object)idn.toUnicode("www.xn--zrich-kva.ch"));
        Assert.assertEquals((Object)"www.g\u00e4ggelig\u00e4\u00e4l.ch", (Object)idn.toUnicode("www.xn--gggeligl-0zaga.ch"));
    }
}

