/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn.routing;

import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.routing.BasicRouteDirector;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteInfo;
import org.junit.Assert;
import org.junit.Test;

public class TestRouteDirector {
    public static final HttpHost TARGET1 = new HttpHost("target1.test.invalid");
    public static final HttpHost TARGET2 = new HttpHost("target2.test.invalid", 8080);
    public static final HttpHost PROXY1 = new HttpHost("proxy1.test.invalid");
    public static final HttpHost PROXY2 = new HttpHost("proxy2.test.invalid", 1080);
    public static final HttpHost PROXY3 = new HttpHost("proxy3.test.invalid", 88);
    public static final InetAddress LOCAL41;
    public static final InetAddress LOCAL42;
    public static final InetAddress LOCAL61;
    public static final InetAddress LOCAL62;

    @Test(expected=IllegalArgumentException.class)
    public void testIllegal() {
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route = new HttpRoute(TARGET1);
        rowdy.nextStep(null, (RouteInfo)route);
    }

    @Test
    public void testDirect() {
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route1 = new HttpRoute(TARGET1);
        HttpRoute route2 = new HttpRoute(TARGET2);
        HttpRoute route1p1 = new HttpRoute(TARGET1, null, PROXY1, false);
        int step = rowdy.nextStep((RouteInfo)route1, null);
        Assert.assertEquals((String)"wrong step to route1", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route2, null);
        Assert.assertEquals((String)"wrong step to route2", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1);
        Assert.assertEquals((String)"complete route1 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route2, (RouteInfo)route2);
        Assert.assertEquals((String)"complete route2 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route2);
        Assert.assertEquals((String)"unreachable target not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1p1);
        Assert.assertEquals((String)"invalid proxy not detected", (long)-1L, (long)step);
    }

    @Test
    public void testProxy() {
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route1p1 = new HttpRoute(TARGET1, null, PROXY1, false);
        HttpRoute route1p2 = new HttpRoute(TARGET1, null, PROXY2, false);
        HttpRoute route2p1 = new HttpRoute(TARGET2, null, PROXY1, false);
        HttpRoute route0 = new HttpRoute(PROXY1);
        HttpRoute route1 = new HttpRoute(TARGET1);
        int step = rowdy.nextStep((RouteInfo)route1p1, null);
        Assert.assertEquals((String)"wrong step to route1p1", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p2, null);
        Assert.assertEquals((String)"wrong step to route1p2", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route1p1);
        Assert.assertEquals((String)"complete route1p1 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p2, (RouteInfo)route1p2);
        Assert.assertEquals((String)"complete route1p2 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route2p1, (RouteInfo)route2p1);
        Assert.assertEquals((String)"complete route2p1 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route1p2);
        Assert.assertEquals((String)"unreachable route1p1 via route1p2 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route2p1);
        Assert.assertEquals((String)"unreachable route1p1 via route2p1 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route0);
        Assert.assertEquals((String)"unreachable route1p1 via route0 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1p1, (RouteInfo)route1);
        Assert.assertEquals((String)"unreachable route1p1 via route1 not detected", (long)-1L, (long)step);
    }

    @Test
    public void testProxyChain() {
        HttpHost[] chainA = new HttpHost[]{PROXY1};
        HttpHost[] chainB = new HttpHost[]{PROXY1, PROXY2};
        HttpHost[] chainC = new HttpHost[]{PROXY2, PROXY1};
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route1cA = new HttpRoute(TARGET1, null, chainA, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1cB = new HttpRoute(TARGET1, null, chainB, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1cC = new HttpRoute(TARGET1, null, chainC, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1cD = new HttpRoute(TARGET1, null, chainC, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        int step = rowdy.nextStep((RouteInfo)route1cA, null);
        Assert.assertEquals((String)"wrong step to route1cA", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cB, null);
        Assert.assertEquals((String)"wrong step to route1cB", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cC, null);
        Assert.assertEquals((String)"wrong step to route1cC", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cD, null);
        Assert.assertEquals((String)"wrong step to route1cD", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cA);
        Assert.assertEquals((String)"wrong step to route 1cB from 1cA", (long)4L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cB);
        Assert.assertEquals((String)"complete route 1cB not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cC);
        Assert.assertEquals((String)"unreachable route 1cB from 1cC not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cB, (RouteInfo)route1cD);
        Assert.assertEquals((String)"unreachable route 1cB from 1cD not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1cA, (RouteInfo)route1cB);
        Assert.assertEquals((String)"unreachable route 1cA from 1cB not detected", (long)-1L, (long)step);
    }

    @Test
    public void testLocalDirect() {
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route1l41 = new HttpRoute(TARGET1, LOCAL41, false);
        HttpRoute route1l42 = new HttpRoute(TARGET1, LOCAL42, false);
        HttpRoute route1l61 = new HttpRoute(TARGET1, LOCAL61, false);
        HttpRoute route1l00 = new HttpRoute(TARGET1, null, false);
        int step = rowdy.nextStep((RouteInfo)route1l41, null);
        Assert.assertEquals((String)"wrong step to route1l41", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l42, null);
        Assert.assertEquals((String)"wrong step to route1l42", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l61, null);
        Assert.assertEquals((String)"wrong step to route1l61", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l00, null);
        Assert.assertEquals((String)"wrong step to route1l00", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l41);
        Assert.assertEquals((String)"complete route1l41 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l42, (RouteInfo)route1l42);
        Assert.assertEquals((String)"complete route1l42 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l61, (RouteInfo)route1l61);
        Assert.assertEquals((String)"complete route1l61 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l00);
        Assert.assertEquals((String)"complete route1l00 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l42);
        Assert.assertEquals((String)"unreachable route1l41 via route1l42 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l61);
        Assert.assertEquals((String)"unreachable route1l41 via route1l61 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l41, (RouteInfo)route1l00);
        Assert.assertEquals((String)"unreachable route1l41 via route1l00 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l41);
        Assert.assertEquals((String)"complete route1l00 as route1l41 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l42);
        Assert.assertEquals((String)"complete route1l00 as route1l42 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1l00, (RouteInfo)route1l61);
        Assert.assertEquals((String)"complete route1l00 as route1l61 not detected", (long)0L, (long)step);
    }

    @Test
    public void testDirectSecure() {
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route1u = new HttpRoute(TARGET1, null, false);
        HttpRoute route1s = new HttpRoute(TARGET1, null, true);
        HttpRoute route1p1u = new HttpRoute(TARGET1, null, PROXY1, false);
        HttpRoute route1p1s = new HttpRoute(TARGET1, null, PROXY1, true);
        int step = rowdy.nextStep((RouteInfo)route1u, null);
        Assert.assertEquals((String)"wrong step to route1u", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, null);
        Assert.assertEquals((String)"wrong step to route1s", (long)1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1u, (RouteInfo)route1s);
        Assert.assertEquals((String)"unreachable route 1u from 1s not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1u);
        Assert.assertEquals((String)"unreachable route 1s from 1u not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1p1u);
        Assert.assertEquals((String)"unreachable route 1s from 1p1u not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1p1s);
        Assert.assertEquals((String)"unreachable route 1s from 1p1s not detected", (long)-1L, (long)step);
    }

    @Test
    public void testProxyTLS() {
        BasicRouteDirector rowdy = new BasicRouteDirector();
        HttpRoute route1 = new HttpRoute(TARGET1, null, PROXY1, false, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1t = new HttpRoute(TARGET1, null, PROXY1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute route1tl = new HttpRoute(TARGET1, null, PROXY1, false, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        HttpRoute route1s = new HttpRoute(TARGET1, null, PROXY1, true, RouteInfo.TunnelType.PLAIN, RouteInfo.LayerType.PLAIN);
        HttpRoute route1ts = new HttpRoute(TARGET1, null, PROXY1, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.PLAIN);
        HttpRoute route1tls = new HttpRoute(TARGET1, null, PROXY1, true, RouteInfo.TunnelType.TUNNELLED, RouteInfo.LayerType.LAYERED);
        int step = rowdy.nextStep((RouteInfo)route1, null);
        Assert.assertEquals((String)"wrong step to route1", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1t, null);
        Assert.assertEquals((String)"wrong step to route1t", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tl, null);
        Assert.assertEquals((String)"wrong step to route1tl", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, null);
        Assert.assertEquals((String)"wrong step to route1s", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1ts, null);
        Assert.assertEquals((String)"wrong step to route1ts", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tls, null);
        Assert.assertEquals((String)"wrong step to route1tls", (long)2L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1);
        Assert.assertEquals((String)"complete route1 not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1t, (RouteInfo)route1t);
        Assert.assertEquals((String)"complete route1t not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1tl);
        Assert.assertEquals((String)"complete route1tl not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1s);
        Assert.assertEquals((String)"complete route1s not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1ts, (RouteInfo)route1ts);
        Assert.assertEquals((String)"complete route1ts not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1tls);
        Assert.assertEquals((String)"complete route1tls not detected", (long)0L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1t);
        Assert.assertEquals((String)"unreachable route1 from 1t not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1tl);
        Assert.assertEquals((String)"unreachable route1 from 1tl not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1s);
        Assert.assertEquals((String)"unreachable route1 from 1s not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1ts);
        Assert.assertEquals((String)"unreachable route1 from 1ts not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1, (RouteInfo)route1tls);
        Assert.assertEquals((String)"unreachable route1 from 1tls not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1s, (RouteInfo)route1);
        Assert.assertEquals((String)"unreachable route1s from 1 not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1tl);
        Assert.assertEquals((String)"unreachable route1tls from 1tl not detected", (long)-1L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1t, (RouteInfo)route1);
        Assert.assertEquals((String)"wrong step to route1t from 1", (long)3L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1);
        Assert.assertEquals((String)"wrong step to route1tl from 1", (long)3L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1);
        Assert.assertEquals((String)"wrong step to route1tls from 1", (long)3L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1t);
        Assert.assertEquals((String)"wrong step to route1tl from 1t", (long)5L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tl, (RouteInfo)route1ts);
        Assert.assertEquals((String)"wrong step to route1tl from 1ts", (long)5L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1t);
        Assert.assertEquals((String)"wrong step to route1tls from 1t", (long)5L, (long)step);
        step = rowdy.nextStep((RouteInfo)route1tls, (RouteInfo)route1ts);
        Assert.assertEquals((String)"wrong step to route1tls from 1ts", (long)5L, (long)step);
    }

    static {
        try {
            LOCAL41 = InetAddress.getByAddress(new byte[]{127, 0, 0, 1});
            LOCAL42 = InetAddress.getByAddress(new byte[]{127, 0, 0, 2});
            LOCAL61 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 1});
            LOCAL62 = InetAddress.getByAddress(new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 2});
        }
        catch (Exception x) {
            throw new ExceptionInInitializerError(x);
        }
    }
}

