/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Queue;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpVersion;
import org.apache.http.ProtocolVersion;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthProtocolState;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthSchemeProvider;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthState;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.ContextAwareAuthScheme;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.HttpAuthenticator;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.message.BasicHttpResponse;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestHttpAuthenticator {
    private AuthenticationStrategy authStrategy;
    private AuthState authState;
    private ContextAwareAuthScheme authScheme;
    private HttpContext context;
    private HttpHost host;
    private Credentials credentials;
    private BasicCredentialsProvider credentialsProvider;
    private Lookup<AuthSchemeProvider> authSchemeRegistry;
    private AuthCache authCache;
    private HttpAuthenticator httpAuthenticator;

    @Before
    public void setUp() throws Exception {
        this.authStrategy = (AuthenticationStrategy)Mockito.mock(AuthenticationStrategy.class);
        this.authState = new AuthState();
        this.authScheme = (ContextAwareAuthScheme)Mockito.mock(ContextAwareAuthScheme.class);
        Mockito.when((Object)this.authScheme.getSchemeName()).thenReturn((Object)"Basic");
        Mockito.when((Object)this.authScheme.isComplete()).thenReturn((Object)Boolean.TRUE);
        this.context = new BasicHttpContext();
        this.host = new HttpHost("localhost", 80);
        this.context.setAttribute("http.target_host", (Object)this.host);
        this.credentials = (Credentials)Mockito.mock(Credentials.class);
        this.credentialsProvider = new BasicCredentialsProvider();
        this.credentialsProvider.setCredentials(AuthScope.ANY, this.credentials);
        this.context.setAttribute("http.auth.credentials-provider", (Object)this.credentialsProvider);
        this.authSchemeRegistry = RegistryBuilder.create().register("basic", (Object)new BasicSchemeFactory()).register("digest", (Object)new DigestSchemeFactory()).register("ntlm", (Object)new NTLMSchemeFactory()).build();
        this.context.setAttribute("http.authscheme-registry", this.authSchemeRegistry);
        this.authCache = (AuthCache)Mockito.mock(AuthCache.class);
        this.context.setAttribute("http.auth.auth-cache", (Object)this.authCache);
        this.httpAuthenticator = new HttpAuthenticator();
    }

    @Test
    public void testAuthenticationRequested() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.TRUE);
        Assert.assertTrue((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
    }

    @Test
    public void testAuthenticationRequestedAfterSuccess() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.TRUE);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        this.authState.setState(AuthProtocolState.SUCCESS);
        Assert.assertTrue((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).authFailed(this.host, (AuthScheme)this.authScheme, this.context);
    }

    @Test
    public void testAuthenticationNotRequestedUnchallenged() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.FALSE);
        Assert.assertFalse((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.UNCHALLENGED, (Object)this.authState.getState());
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
    }

    @Test
    public void testAuthenticationNotRequestedSuccess1() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.FALSE);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        this.authState.setState(AuthProtocolState.CHALLENGED);
        Assert.assertFalse((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.SUCCESS, (Object)this.authState.getState());
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).authSucceeded(this.host, (AuthScheme)this.authScheme, this.context);
    }

    @Test
    public void testAuthenticationNotRequestedSuccess2() throws Exception {
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 200, "OK");
        Mockito.when((Object)this.authStrategy.isAuthenticationRequested((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)Boolean.FALSE);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        this.authState.setState(AuthProtocolState.HANDSHAKE);
        Assert.assertFalse((boolean)this.httpAuthenticator.isAuthenticationRequested(this.host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.SUCCESS, (Object)this.authState.getState());
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).isAuthenticationRequested(this.host, (HttpResponse)response, this.context);
        ((AuthenticationStrategy)Mockito.verify((Object)this.authStrategy)).authSucceeded(this.host, (AuthScheme)this.authScheme, this.context);
    }

    @Test
    public void testAuthentication() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertTrue((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.CHALLENGED, (Object)this.authState.getState());
        Queue options = this.authState.getAuthOptions();
        Assert.assertNotNull((Object)options);
        AuthOption option1 = (AuthOption)options.poll();
        Assert.assertNotNull((Object)option1);
        Assert.assertEquals((Object)"digest", (Object)option1.getAuthScheme().getSchemeName());
        AuthOption option2 = (AuthOption)options.poll();
        Assert.assertNotNull((Object)option2);
        Assert.assertEquals((Object)"basic", (Object)option2.getAuthScheme().getSchemeName());
        Assert.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationNoChallenges() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        Mockito.when((Object)this.authStrategy.getChallenges((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn(new HashMap());
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
    }

    @Test
    public void testAuthenticationNoSupportedChallenges() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "This realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "That realm=\"realm1\", nonce=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
    }

    @Test
    public void testAuthenticationNoCredentials() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        this.credentialsProvider.clear();
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
    }

    @Test
    public void testAuthenticationFailed() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.FAILURE, (Object)this.authState.getState());
        ((AuthCache)Mockito.verify((Object)this.authCache)).remove(host);
    }

    @Test
    public void testAuthenticationFailedPreviously() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        this.authState.setState(AuthProtocolState.FAILURE);
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.FAILURE, (Object)this.authState.getState());
    }

    @Test
    public void testAuthenticationFailure() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)new BasicScheme(), this.credentials);
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.FAILURE, (Object)this.authState.getState());
        Assert.assertNull((Object)this.authState.getCredentials());
    }

    @Test
    public void testAuthenticationHandshaking() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Basic realm=\"test\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", stale=true, nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)new DigestScheme(), this.credentials);
        Assert.assertTrue((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.HANDSHAKE, (Object)this.authState.getState());
    }

    @Test
    public void testAuthenticationNoMatchingChallenge() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"1234\""));
        response.addHeader((Header)new BasicHeader("WWW-Authenticate", "whatever realm=\"realm1\", stuff=\"1234\""));
        TargetAuthenticationStrategy authStrategy = new TargetAuthenticationStrategy();
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)new BasicScheme(), this.credentials);
        Assert.assertTrue((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, (AuthenticationStrategy)authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.CHALLENGED, (Object)this.authState.getState());
        Queue options = this.authState.getAuthOptions();
        Assert.assertNotNull((Object)options);
        AuthOption option1 = (AuthOption)options.poll();
        Assert.assertNotNull((Object)option1);
        Assert.assertEquals((Object)"digest", (Object)option1.getAuthScheme().getSchemeName());
        Assert.assertNull(options.poll());
    }

    @Test
    public void testAuthenticationException() throws Exception {
        HttpHost host = new HttpHost("somehost", 80);
        BasicHttpResponse response = new BasicHttpResponse((ProtocolVersion)HttpVersion.HTTP_1_1, 401, "UNAUTHORIZED");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        ((AuthenticationStrategy)Mockito.doThrow((Throwable)new MalformedChallengeException()).when((Object)this.authStrategy)).getChallenges((HttpHost)Mockito.any(HttpHost.class), (HttpResponse)Mockito.any(HttpResponse.class), (HttpContext)Mockito.any(HttpContext.class));
        Assert.assertFalse((boolean)this.httpAuthenticator.handleAuthChallenge(host, (HttpResponse)response, this.authStrategy, this.authState, this.context));
        Assert.assertEquals((Object)AuthProtocolState.UNCHALLENGED, (Object)this.authState.getState());
        Assert.assertNull((Object)this.authState.getAuthScheme());
        Assert.assertNull((Object)this.authState.getCredentials());
    }

    @Test
    public void testAuthFailureState() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.FAILURE);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        this.httpAuthenticator.generateAuthResponse((HttpRequest)request, this.authState, this.context);
        Assert.assertFalse((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme, (VerificationMode)Mockito.never())).authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
    }

    @Test
    public void testAuthChallengeStateNoOption() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.httpAuthenticator.generateAuthResponse((HttpRequest)request, this.authState, this.context);
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme)).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthChallengeStateOneOptions() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        LinkedList<AuthOption> authOptions = new LinkedList<AuthOption>();
        authOptions.add(new AuthOption((AuthScheme)this.authScheme, this.credentials));
        this.authState.update(authOptions);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.httpAuthenticator.generateAuthResponse((HttpRequest)request, this.authState, this.context);
        Assert.assertSame((Object)this.authScheme, (Object)this.authState.getAuthScheme());
        Assert.assertSame((Object)this.credentials, (Object)this.authState.getCredentials());
        Assert.assertNull((Object)this.authState.getAuthOptions());
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme)).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthChallengeStateMultipleOption() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.CHALLENGED);
        LinkedList<AuthOption> authOptions = new LinkedList<AuthOption>();
        ContextAwareAuthScheme authScheme1 = (ContextAwareAuthScheme)Mockito.mock(ContextAwareAuthScheme.class);
        ((ContextAwareAuthScheme)Mockito.doThrow((Throwable)new AuthenticationException()).when((Object)authScheme1)).authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
        ContextAwareAuthScheme authScheme2 = (ContextAwareAuthScheme)Mockito.mock(ContextAwareAuthScheme.class);
        Mockito.when((Object)authScheme2.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        authOptions.add(new AuthOption((AuthScheme)authScheme1, this.credentials));
        authOptions.add(new AuthOption((AuthScheme)authScheme2, this.credentials));
        this.authState.update(authOptions);
        this.httpAuthenticator.generateAuthResponse((HttpRequest)request, this.authState, this.context);
        Assert.assertSame((Object)authScheme2, (Object)this.authState.getAuthScheme());
        Assert.assertSame((Object)this.credentials, (Object)this.authState.getCredentials());
        Assert.assertNull((Object)this.authState.getAuthOptions());
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)authScheme1, (VerificationMode)Mockito.times((int)1))).authenticate(this.credentials, (HttpRequest)request, this.context);
        ((ContextAwareAuthScheme)Mockito.verify((Object)authScheme2, (VerificationMode)Mockito.times((int)1))).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthSuccess() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.SUCCESS);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        Mockito.when((Object)this.authScheme.isConnectionBased()).thenReturn((Object)Boolean.FALSE);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.httpAuthenticator.generateAuthResponse((HttpRequest)request, this.authState, this.context);
        Assert.assertSame((Object)this.authScheme, (Object)this.authState.getAuthScheme());
        Assert.assertSame((Object)this.credentials, (Object)this.authState.getCredentials());
        Assert.assertNull((Object)this.authState.getAuthOptions());
        Assert.assertTrue((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme)).authenticate(this.credentials, (HttpRequest)request, this.context);
    }

    @Test
    public void testAuthSuccessConnectionBased() throws Exception {
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        this.authState.setState(AuthProtocolState.SUCCESS);
        this.authState.update((AuthScheme)this.authScheme, this.credentials);
        Mockito.when((Object)this.authScheme.isConnectionBased()).thenReturn((Object)Boolean.TRUE);
        Mockito.when((Object)this.authScheme.authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class))).thenReturn((Object)new BasicHeader("Authorization", "stuff"));
        this.httpAuthenticator.generateAuthResponse((HttpRequest)request, this.authState, this.context);
        Assert.assertFalse((boolean)request.containsHeader("Authorization"));
        ((ContextAwareAuthScheme)Mockito.verify((Object)this.authScheme, (VerificationMode)Mockito.never())).authenticate((Credentials)Mockito.any(Credentials.class), (HttpRequest)Mockito.any(HttpRequest.class), (HttpContext)Mockito.any(HttpContext.class));
    }
}

