/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.LinkedList;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import junit.framework.Assert;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.FutureRequestExecutionService;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpRequestFutureTask;
import org.apache.http.localserver.LocalTestServer;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpRequestHandler;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class TestFutureRequestExecutionService {
    private LocalTestServer localServer;
    private String uri;
    private FutureRequestExecutionService httpAsyncClientWithFuture;
    private final AtomicBoolean blocked = new AtomicBoolean(false);

    @Before
    public void before() throws Exception {
        this.localServer = new LocalTestServer(null, null);
        this.localServer.register("/wait", new HttpRequestHandler(){

            public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
                try {
                    while (TestFutureRequestExecutionService.this.blocked.get()) {
                        Thread.sleep(10L);
                    }
                }
                catch (InterruptedException e) {
                    throw new IllegalStateException(e);
                }
                response.setStatusCode(200);
            }
        });
        this.localServer.start();
        InetSocketAddress address = this.localServer.getServiceAddress();
        this.uri = "http://" + address.getHostName() + ":" + address.getPort() + "/wait";
        CloseableHttpClient httpClient = HttpClientBuilder.create().setMaxConnPerRoute(5).build();
        ExecutorService executorService = Executors.newFixedThreadPool(5);
        this.httpAsyncClientWithFuture = new FutureRequestExecutionService((HttpClient)httpClient, executorService);
    }

    @After
    public void after() throws Exception {
        this.blocked.set(false);
        this.localServer.stop();
        this.httpAsyncClientWithFuture.close();
    }

    @Test
    public void shouldExecuteSingleCall() throws InterruptedException, ExecutionException {
        HttpRequestFutureTask task = this.httpAsyncClientWithFuture.execute((HttpUriRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (ResponseHandler)new OkidokiHandler());
        Assert.assertTrue((String)"request should have returned OK", (boolean)((Boolean)task.get()));
    }

    @Test(expected=CancellationException.class)
    public void shouldCancel() throws InterruptedException, ExecutionException {
        HttpRequestFutureTask task = this.httpAsyncClientWithFuture.execute((HttpUriRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (ResponseHandler)new OkidokiHandler());
        task.cancel(true);
        task.get();
    }

    @Test(expected=TimeoutException.class)
    public void shouldTimeout() throws InterruptedException, ExecutionException, TimeoutException {
        this.blocked.set(true);
        HttpRequestFutureTask task = this.httpAsyncClientWithFuture.execute((HttpUriRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (ResponseHandler)new OkidokiHandler());
        task.get(10L, TimeUnit.MILLISECONDS);
    }

    @Test
    public void shouldExecuteMultipleCalls() throws Exception {
        int reqNo = 100;
        LinkedList<Future> tasks = new LinkedList<Future>();
        for (int i = 0; i < 100; ++i) {
            Future task = this.httpAsyncClientWithFuture.execute((HttpUriRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (ResponseHandler)new OkidokiHandler());
            tasks.add(task);
        }
        for (Future task : tasks) {
            Boolean b = (Boolean)task.get();
            Assert.assertNotNull((Object)b);
            Assert.assertTrue((String)"request should have returned OK", (boolean)b);
        }
    }

    @Test
    public void shouldExecuteMultipleCallsAndCallback() throws Exception {
        int reqNo = 100;
        LinkedList<Future> tasks = new LinkedList<Future>();
        CountDownLatch latch = new CountDownLatch(100);
        for (int i = 0; i < 100; ++i) {
            Future task = this.httpAsyncClientWithFuture.execute((HttpUriRequest)new HttpGet(this.uri), (HttpContext)HttpClientContext.create(), (ResponseHandler)new OkidokiHandler(), (FutureCallback)new CountingCallback(latch));
            tasks.add(task);
        }
        Assert.assertTrue((boolean)latch.await(5L, TimeUnit.SECONDS));
        for (Future task : tasks) {
            Boolean b = (Boolean)task.get();
            Assert.assertNotNull((Object)b);
            Assert.assertTrue((String)"request should have returned OK", (boolean)b);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class OkidokiHandler
    implements ResponseHandler<Boolean> {
        private OkidokiHandler() {
        }

        public Boolean handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
            return response.getStatusLine().getStatusCode() == 200;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class CountingCallback
    implements FutureCallback<Boolean> {
        private final CountDownLatch latch;

        CountingCallback(CountDownLatch latch) {
            this.latch = latch;
        }

        public void failed(Exception ex) {
            this.latch.countDown();
        }

        public void completed(Boolean result) {
            this.latch.countDown();
        }

        public void cancelled() {
            this.latch.countDown();
        }
    }
}

