/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.conn;

import java.io.IOException;
import java.net.InetAddress;
import org.apache.http.HttpHost;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.HttpHostConnectException;
import org.junit.Assert;
import org.junit.Test;

public class TestExceptions {
    @Test
    public void testConnectTimeoutExceptionNullMessage() {
        ConnectTimeoutException ctx = new ConnectTimeoutException();
        Assert.assertNull((Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionSimpleMessage() {
        ConnectTimeoutException ctx = new ConnectTimeoutException("sample exception message");
        Assert.assertEquals((Object)"sample exception message", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromNullCause() {
        ConnectTimeoutException ctx = new ConnectTimeoutException(null, null, new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to remote host timed out", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromCause() {
        IOException cause = new IOException("something awful");
        ConnectTimeoutException ctx = new ConnectTimeoutException(cause, null, new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to remote host failed: something awful", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromCauseAndHost() {
        HttpHost target = new HttpHost("localhost");
        IOException cause = new IOException();
        ConnectTimeoutException ctx = new ConnectTimeoutException(cause, target, new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to localhost timed out", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectTimeoutExceptionFromCauseHostAndRemoteAddress() throws Exception {
        HttpHost target = new HttpHost("localhost");
        InetAddress remoteAddress = InetAddress.getByAddress(new byte[]{1, 2, 3, 4});
        IOException cause = new IOException();
        ConnectTimeoutException ctx = new ConnectTimeoutException(cause, target, new InetAddress[]{remoteAddress});
        Assert.assertEquals((Object)"Connect to localhost [/1.2.3.4] timed out", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromNullCause() {
        HttpHostConnectException ctx = new HttpHostConnectException(null, null, (InetAddress[])null);
        Assert.assertEquals((Object)"Connect to remote host refused", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromCause() {
        IOException cause = new IOException("something awful");
        HttpHostConnectException ctx = new HttpHostConnectException(cause, null, new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to remote host failed: something awful", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromCauseAndHost() {
        HttpHost target = new HttpHost("localhost");
        IOException cause = new IOException();
        HttpHostConnectException ctx = new HttpHostConnectException(cause, target, new InetAddress[0]);
        Assert.assertEquals((Object)"Connect to localhost refused", (Object)ctx.getMessage());
    }

    @Test
    public void testHttpHostConnectExceptionFromCauseHostAndRemoteAddress() throws Exception {
        HttpHost target = new HttpHost("localhost");
        InetAddress remoteAddress1 = InetAddress.getByAddress(new byte[]{1, 2, 3, 4});
        InetAddress remoteAddress2 = InetAddress.getByAddress(new byte[]{5, 6, 7, 8});
        IOException cause = new IOException();
        HttpHostConnectException ctx = new HttpHostConnectException(cause, target, new InetAddress[]{remoteAddress1, remoteAddress2});
        Assert.assertEquals((Object)"Connect to localhost [/1.2.3.4, /5.6.7.8] refused", (Object)ctx.getMessage());
    }

    @Test
    public void testConnectionPoolTimeoutException() {
        String msg = "sample exception message";
        ConnectionPoolTimeoutException cptx = new ConnectionPoolTimeoutException("sample exception message");
        Assert.assertFalse((!cptx.toString().contains("sample exception message") ? 1 : 0) != 0);
        Assert.assertSame((Object)"sample exception message", (Object)cptx.getMessage());
        cptx = new ConnectionPoolTimeoutException();
        Assert.assertNull((Object)cptx.getMessage());
    }
}

