/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client.integration;

import java.io.IOException;
import org.apache.http.Consts;
import org.apache.http.HttpEntity;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.entity.StringEntity;
import org.apache.http.localserver.LocalServerTestBase;
import org.apache.http.localserver.RequestBasicAuth;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpProcessorBuilder;
import org.apache.http.protocol.HttpRequestHandler;
import org.apache.http.protocol.ResponseConnControl;
import org.apache.http.protocol.ResponseContent;
import org.apache.http.protocol.ResponseDate;
import org.apache.http.protocol.ResponseServer;
import org.apache.http.util.EntityUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestClientAuthenticationFallBack
extends LocalServerTestBase {
    @Override
    @Before
    public void setUp() throws Exception {
        super.setUp();
        HttpProcessor httpproc = HttpProcessorBuilder.create().add((HttpResponseInterceptor)new ResponseDate()).add((HttpResponseInterceptor)new ResponseServer("TEST/1.1")).add((HttpResponseInterceptor)new ResponseContent()).add((HttpResponseInterceptor)new ResponseConnControl()).add((HttpRequestInterceptor)new RequestBasicAuth()).add((HttpResponseInterceptor)new ResponseBasicUnauthorized()).build();
        this.serverBootstrap.setHttpProcessor(httpproc);
    }

    @Test
    public void testBasicAuthenticationSuccess() throws Exception {
        this.serverBootstrap.registerHandler("*", (HttpRequestHandler)new AuthHandler());
        HttpHost target = this.start();
        HttpClientContext context = HttpClientContext.create();
        TestCredentialsProvider credsProvider = new TestCredentialsProvider((Credentials)new UsernamePasswordCredentials("test", "test"));
        context.setCredentialsProvider((CredentialsProvider)credsProvider);
        HttpGet httpget = new HttpGet("/");
        CloseableHttpResponse response = this.httpclient.execute(target, (HttpRequest)httpget, (HttpContext)context);
        HttpEntity entity = response.getEntity();
        Assert.assertEquals((long)200L, (long)response.getStatusLine().getStatusCode());
        Assert.assertNotNull((Object)entity);
        EntityUtils.consume((HttpEntity)entity);
        AuthScope authscope = credsProvider.getAuthScope();
        Assert.assertNotNull((Object)authscope);
        Assert.assertEquals((Object)"test realm", (Object)authscope.getRealm());
    }

    static class TestCredentialsProvider
    implements CredentialsProvider {
        private final Credentials creds;
        private AuthScope authscope;

        TestCredentialsProvider(Credentials creds) {
            this.creds = creds;
        }

        public void clear() {
        }

        public Credentials getCredentials(AuthScope authscope) {
            this.authscope = authscope;
            return this.creds;
        }

        public void setCredentials(AuthScope authscope, Credentials credentials) {
        }

        public AuthScope getAuthScope() {
            return this.authscope;
        }
    }

    static class AuthHandler
    implements HttpRequestHandler {
        AuthHandler() {
        }

        public void handle(HttpRequest request, HttpResponse response, HttpContext context) throws HttpException, IOException {
            String creds = (String)context.getAttribute("creds");
            if (creds == null || !creds.equals("test:test")) {
                response.setStatusCode(401);
            } else {
                response.setStatusCode(200);
                StringEntity entity = new StringEntity("success", Consts.ASCII);
                response.setEntity((HttpEntity)entity);
            }
        }
    }

    public class ResponseBasicUnauthorized
    implements HttpResponseInterceptor {
        public void process(HttpResponse response, HttpContext context) throws HttpException, IOException {
            if (response.getStatusLine().getStatusCode() == 401) {
                response.addHeader("WWW-Authenticate", "Digest realm=\"test realm\" invalid");
                response.addHeader("WWW-Authenticate", "Basic realm=\"test realm\"");
            }
        }
    }
}

