/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Collection;
import org.apache.http.Consts;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.conn.util.PublicSuffixListParser;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.PublicSuffixDomainFilter;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestPublicSuffixListParser {
    private static final String SOURCE_FILE = "suffixlist.txt";
    private PublicSuffixDomainFilter filter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Before
    public void setUp() throws Exception {
        PublicSuffixList suffixList;
        ClassLoader classLoader = this.getClass().getClassLoader();
        InputStream in = classLoader.getResourceAsStream(SOURCE_FILE);
        Assert.assertNotNull((Object)in);
        try {
            PublicSuffixListParser parser = new PublicSuffixListParser();
            suffixList = parser.parse((Reader)new InputStreamReader(in, Consts.UTF_8));
        }
        finally {
            in.close();
        }
        PublicSuffixMatcher matcher = new PublicSuffixMatcher((Collection)suffixList.getRules(), (Collection)suffixList.getExceptions());
        this.filter = new PublicSuffixDomainFilter((CommonCookieAttributeHandler)new RFC2109DomainHandler(), matcher);
    }

    @Test
    public void testParse() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.jp", 80, "/stuff", false)));
        cookie.setDomain(".ac.jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.ac.jp", 80, "/stuff", false)));
        cookie.setDomain(".any.tokyo.jp");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.any.tokyo.jp", 80, "/stuff", false)));
        cookie.setDomain(".metro.tokyo.jp");
        Assert.assertTrue((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.metro.tokyo.jp", 80, "/stuff", false)));
    }

    @Test
    public void testUnicode() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", "value");
        cookie.setDomain(".h\u00e5.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.h\u00e5.no", 80, "/stuff", false)));
        cookie.setDomain(".xn--h-2fa.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xn--h-2fa.no", 80, "/stuff", false)));
        cookie.setDomain(".h\u00e5.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.xn--h-2fa.no", 80, "/stuff", false)));
        cookie.setDomain(".xn--h-2fa.no");
        Assert.assertFalse((boolean)this.filter.match((Cookie)cookie, new CookieOrigin("apache.h\u00e5.no", 80, "/stuff", false)));
    }
}

