/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.security.MessageDigest;
import java.util.HashMap;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.entity.InputStreamEntity;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.auth.DigestScheme;
import org.apache.http.impl.auth.HttpEntityDigester;
import org.apache.http.message.BasicHeader;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.BasicHttpEntityEnclosingRequest;
import org.apache.http.message.BasicHttpRequest;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HTTP;
import org.apache.http.protocol.HttpContext;
import org.junit.Assert;
import org.junit.Test;

public class TestDigestScheme {
    @Test(expected=MalformedChallengeException.class)
    public void testDigestAuthenticationEmptyChallenge1() throws Exception {
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
    }

    @Test(expected=MalformedChallengeException.class)
    public void testDigestAuthenticationEmptyChallenge2() throws Exception {
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest ");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
    }

    @Test
    public void testDigestAuthenticationWithDefaultCreds() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Assert.assertTrue((boolean)authscheme.isComplete());
        Assert.assertFalse((boolean)authscheme.isConnectionBased());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"e95a7ddf37c2eab009568b1ed134f89a", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthentication() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"e95a7ddf37c2eab009568b1ed134f89a", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationInvalidInput() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        try {
            authscheme.authenticate(null, (HttpRequest)request, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            authscheme.authenticate((Credentials)cred, null, (HttpContext)context);
            Assert.fail((String)"IllegalArgumentException should have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testDigestAuthenticationOverrideParameter() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        authscheme.overrideParamter("realm", "other realm");
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"other realm", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"3f211de10463cbd055ab4cd9c5158eac", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithSHA() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=SHA";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", algorithm=SHA");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"8769e82e4e28ecc040b969562b9050580c6d186d", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithQueryStringInDigestURI() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/?param=value");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/?param=value", (Object)table.get("uri"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"a847f58f5fef0bc087bcb9c3eb30e042", (Object)table.get("response"));
    }

    @Test
    public void testDigestAuthenticationWithMultipleRealms() throws Exception {
        String challenge1 = "Digest realm=\"realm1\", nonce=\"abcde\"";
        String challenge2 = "Digest realm=\"realm2\", nonce=\"123546\"";
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        UsernamePasswordCredentials cred2 = new UsernamePasswordCredentials("uname2", "password2");
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"abcde\"");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"abcde", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"786f500303eac1478f3c2865e676ed68", (Object)table.get("response"));
        authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm2\", nonce=\"123546\"");
        DigestScheme authscheme2 = new DigestScheme();
        authscheme2.processChallenge((Header)authChallenge);
        authResponse = authscheme2.authenticate((Credentials)cred2, (HttpRequest)request, (HttpContext)context);
        table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"uname2", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm2", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"123546", (Object)table.get("nonce"));
        Assert.assertEquals((Object)"0283edd9ef06a38b378b3b74661391e9", (Object)table.get("response"));
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationNoRealm() throws Exception {
        String challenge = "Digest no-realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest no-realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationNoNonce() throws Exception {
        String challenge = "Digest realm=\"realm1\", no-nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", no-nonce=\"f2a3f18799759d4f1a1c068b92b573cb\"");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
    }

    @Test
    public void testDigestAuthenticationMD5Sess() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"auth,auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"auth,auth-int\"");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        String response = authResponse.getValue();
        Assert.assertTrue((response.indexOf("nc=00000001") > 0 ? 1 : 0) != 0);
        Assert.assertTrue((response.indexOf("qop=auth") > 0 ? 1 : 0) != 0);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm", (Object)table.get("realm"));
        Assert.assertEquals((Object)"MD5-sess", (Object)table.get("algorithm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"e273f1776275974f1a120d8b92c5b3cb", (Object)table.get("nonce"));
        Assert.assertEquals((long)1L, (long)Integer.parseInt(table.get("nc"), 16));
        Assert.assertTrue((null != table.get("cnonce") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"SomeString", (Object)table.get("opaque"));
        Assert.assertEquals((Object)"auth", (Object)table.get("qop"));
        Assert.assertTrue((null != table.get("response") ? 1 : 0) != 0);
    }

    @Test
    public void testDigestAuthenticationMD5SessNoQop() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm", (Object)table.get("realm"));
        Assert.assertEquals((Object)"MD5-sess", (Object)table.get("algorithm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"e273f1776275974f1a120d8b92c5b3cb", (Object)table.get("nonce"));
        Assert.assertTrue((null == table.get("nc") ? 1 : 0) != 0);
        Assert.assertEquals((Object)"SomeString", (Object)table.get("opaque"));
        Assert.assertTrue((null == table.get("qop") ? 1 : 0) != 0);
        Assert.assertTrue((null != table.get("response") ? 1 : 0) != 0);
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationMD5SessUnknownQop() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"stuff\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=MD5-sess, qop=\"stuff\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        BasicHttpContext context = new BasicHttpContext();
        authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationUnknownAlgo() throws Exception {
        String realm = "realm";
        String username = "username";
        String password = "password";
        String nonce = "e273f1776275974f1a120d8b92c5b3cb";
        String challenge = "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=stuff, qop=\"auth\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", opaque=\"SomeString\", stale=false, algorithm=stuff, qop=\"auth\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpRequest request = new BasicHttpRequest("Simple", "/");
        BasicHttpContext context = new BasicHttpContext();
        authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
    }

    @Test
    public void testDigestAuthenticationWithStaleNonce() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", stale=\"true\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", stale=\"true\"");
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge);
        Assert.assertFalse((boolean)authscheme.isComplete());
    }

    private static Map<String, String> parseAuthResponse(Header authResponse) {
        String s = authResponse.getValue();
        if (!s.startsWith("Digest ")) {
            return null;
        }
        HeaderElement[] elements = BasicHeaderValueParser.parseElements((String)s.substring(7), null);
        HashMap<String, String> map = new HashMap<String, String>(elements.length);
        for (HeaderElement element : elements) {
            map.put(element.getName(), element.getValue());
        }
        return map;
    }

    @Test
    public void testDigestNouceCount() throws Exception {
        String challenge1 = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth";
        BasicHeader authChallenge1 = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge1);
        Header authResponse1 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table1 = TestDigestScheme.parseAuthResponse(authResponse1);
        Assert.assertEquals((Object)"00000001", (Object)table1.get("nc"));
        Header authResponse2 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table2 = TestDigestScheme.parseAuthResponse(authResponse2);
        Assert.assertEquals((Object)"00000002", (Object)table2.get("nc"));
        String challenge2 = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth";
        BasicHeader authChallenge2 = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=auth");
        authscheme.processChallenge((Header)authChallenge2);
        Header authResponse3 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table3 = TestDigestScheme.parseAuthResponse(authResponse3);
        Assert.assertEquals((Object)"00000003", (Object)table3.get("nc"));
        String challenge3 = "Digest realm=\"realm1\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", qop=auth";
        BasicHeader authChallenge3 = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"e273f1776275974f1a120d8b92c5b3cb\", qop=auth");
        authscheme.processChallenge((Header)authChallenge3);
        Header authResponse4 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table4 = TestDigestScheme.parseAuthResponse(authResponse4);
        Assert.assertEquals((Object)"00000001", (Object)table4.get("nc"));
    }

    @Test
    public void testDigestMD5SessA1AndCnonceConsistency() throws Exception {
        String challenge1 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"";
        BasicHeader authChallenge1 = new BasicHeader("WWW-Authenticate", "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        BasicHttpContext context = new BasicHttpContext();
        DigestScheme authscheme = new DigestScheme();
        authscheme.processChallenge((Header)authChallenge1);
        Header authResponse1 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table1 = TestDigestScheme.parseAuthResponse(authResponse1);
        Assert.assertEquals((Object)"00000001", (Object)table1.get("nc"));
        String cnonce1 = authscheme.getCnonce();
        String sessionKey1 = authscheme.getA1();
        Header authResponse2 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table2 = TestDigestScheme.parseAuthResponse(authResponse2);
        Assert.assertEquals((Object)"00000002", (Object)table2.get("nc"));
        String cnonce2 = authscheme.getCnonce();
        String sessionKey2 = authscheme.getA1();
        Assert.assertEquals((Object)cnonce1, (Object)cnonce2);
        Assert.assertEquals((Object)sessionKey1, (Object)sessionKey2);
        String challenge2 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"";
        BasicHeader authChallenge2 = new BasicHeader("WWW-Authenticate", "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"1234567890abcdef\", charset=utf-8, realm=\"subnet.domain.com\"");
        authscheme.processChallenge((Header)authChallenge2);
        Header authResponse3 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table3 = TestDigestScheme.parseAuthResponse(authResponse3);
        Assert.assertEquals((Object)"00000003", (Object)table3.get("nc"));
        String cnonce3 = authscheme.getCnonce();
        String sessionKey3 = authscheme.getA1();
        Assert.assertEquals((Object)cnonce1, (Object)cnonce3);
        Assert.assertEquals((Object)sessionKey1, (Object)sessionKey3);
        String challenge3 = "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"fedcba0987654321\", charset=utf-8, realm=\"subnet.domain.com\"";
        BasicHeader authChallenge3 = new BasicHeader("WWW-Authenticate", "Digest qop=\"auth\", algorithm=MD5-sess, nonce=\"fedcba0987654321\", charset=utf-8, realm=\"subnet.domain.com\"");
        authscheme.processChallenge((Header)authChallenge3);
        Header authResponse4 = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Map<String, String> table4 = TestDigestScheme.parseAuthResponse(authResponse4);
        Assert.assertEquals((Object)"00000001", (Object)table4.get("nc"));
        String cnonce4 = authscheme.getCnonce();
        String sessionKey4 = authscheme.getA1();
        Assert.assertFalse((boolean)cnonce1.equals(cnonce4));
        Assert.assertFalse((boolean)sessionKey1.equals(sessionKey4));
    }

    @Test
    public void testHttpEntityDigest() throws Exception {
        HttpEntityDigester digester = new HttpEntityDigester(MessageDigest.getInstance("MD5"));
        Assert.assertNull((Object)digester.getDigest());
        digester.write(97);
        digester.write(98);
        digester.write(99);
        digester.write(228);
        digester.write(246);
        digester.write(252);
        digester.write(new byte[]{97, 98, 99});
        Assert.assertNull((Object)digester.getDigest());
        digester.close();
        Assert.assertEquals((Object)"acd2b59cd01c7737d8069015584c6cac", (Object)DigestScheme.encode((byte[])digester.getDigest()));
        try {
            digester.write(97);
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            digester.write(new byte[]{97, 98, 99});
            Assert.fail((String)"IOException should have been thrown");
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Test
    public void testDigestAuthenticationQopAuthInt() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("Post", "/");
        request.setEntity((HttpEntity)new StringEntity("abc\u00e4\u00f6\u00fcabc", HTTP.DEF_CONTENT_CHARSET));
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)"Post:/:acd2b59cd01c7737d8069015584c6cac", (Object)authscheme.getA2());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"auth-int", (Object)table.get("qop"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
    }

    @Test
    public void testDigestAuthenticationQopAuthIntNullEntity() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("Post", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)"Post:/:d41d8cd98f00b204e9800998ecf8427e", (Object)authscheme.getA2());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"auth-int", (Object)table.get("qop"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
    }

    @Test
    public void testDigestAuthenticationQopAuthOrAuthIntNonRepeatableEntity() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("Post", "/");
        request.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{97}), -1L));
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        Header authResponse = authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
        Assert.assertEquals((Object)"Post:/", (Object)authscheme.getA2());
        Map<String, String> table = TestDigestScheme.parseAuthResponse(authResponse);
        Assert.assertEquals((Object)"username", (Object)table.get("username"));
        Assert.assertEquals((Object)"realm1", (Object)table.get("realm"));
        Assert.assertEquals((Object)"/", (Object)table.get("uri"));
        Assert.assertEquals((Object)"auth", (Object)table.get("qop"));
        Assert.assertEquals((Object)"f2a3f18799759d4f1a1c068b92b573cb", (Object)table.get("nonce"));
    }

    @Test
    public void testParameterCaseSensitivity() throws Exception {
        String challenge = "Digest Realm=\"-\", nonce=\"YjYuNGYyYmJhMzUuY2I5ZDhlZDE5M2ZlZDM 1Mjk3NGJkNTIyYjgyNTcwMjQ=\", opaque=\"98700A3D9CE17065E2246B41035C6609\", qop=\"auth\"";
        BasicHeader authChallenge = new BasicHeader("Proxy-Authenticate", "Digest Realm=\"-\", nonce=\"YjYuNGYyYmJhMzUuY2I5ZDhlZDE5M2ZlZDM 1Mjk3NGJkNTIyYjgyNTcwMjQ=\", opaque=\"98700A3D9CE17065E2246B41035C6609\", qop=\"auth\"");
        BasicHttpRequest request = new BasicHttpRequest("GET", "/");
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        Assert.assertEquals((Object)"-", (Object)authscheme.getRealm());
        authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
    }

    @Test(expected=AuthenticationException.class)
    public void testDigestAuthenticationQopIntOnlyNonRepeatableEntity() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth-int\"");
        BasicHttpEntityEnclosingRequest request = new BasicHttpEntityEnclosingRequest("Post", "/");
        request.setEntity((HttpEntity)new InputStreamEntity((InputStream)new ByteArrayInputStream(new byte[]{97}), -1L));
        UsernamePasswordCredentials cred = new UsernamePasswordCredentials("username", "password");
        DigestScheme authscheme = new DigestScheme();
        BasicHttpContext context = new BasicHttpContext();
        authscheme.processChallenge((Header)authChallenge);
        authscheme.authenticate((Credentials)cred, (HttpRequest)request, (HttpContext)context);
    }

    @Test
    public void testSerialization() throws Exception {
        String challenge = "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"";
        BasicHeader authChallenge = new BasicHeader("WWW-Authenticate", "Digest realm=\"realm1\", nonce=\"f2a3f18799759d4f1a1c068b92b573cb\", qop=\"auth,auth-int\"");
        DigestScheme digestScheme = new DigestScheme();
        digestScheme.processChallenge((Header)authChallenge);
        ByteArrayOutputStream buffer = new ByteArrayOutputStream();
        ObjectOutputStream out = new ObjectOutputStream(buffer);
        out.writeObject(digestScheme);
        out.flush();
        byte[] raw = buffer.toByteArray();
        ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(raw));
        DigestScheme authScheme = (DigestScheme)in.readObject();
        Assert.assertEquals((Object)digestScheme.getSchemeName(), (Object)authScheme.getSchemeName());
        Assert.assertEquals((Object)digestScheme.getRealm(), (Object)authScheme.getRealm());
        Assert.assertEquals((Object)digestScheme.isComplete(), (Object)authScheme.isComplete());
        Assert.assertEquals((Object)digestScheme.getA1(), (Object)authScheme.getA1());
        Assert.assertEquals((Object)digestScheme.getA2(), (Object)authScheme.getA2());
        Assert.assertEquals((Object)digestScheme.getCnonce(), (Object)authScheme.getCnonce());
    }
}

