/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.impl.cookie.RFC2109Spec;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestCookieRFC2109Spec {
    @Test
    public void testConstructor() throws Exception {
        new RFC2109Spec();
        new RFC2109Spec(null, false);
        new RFC2109Spec(new String[]{"EEE, dd-MMM-yy HH:mm:ss zzz"}, false);
    }

    @Test
    public void testParseVersion() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; version=1");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertEquals((String)"Found 1 cookie.", (long)1L, (long)cookies.size());
        Assert.assertEquals((String)"Name", (Object)"cookie-name", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((String)"Value", (Object)"cookie-value", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((String)"Version", (long)1L, (long)((Cookie)cookies.get(0)).getVersion());
    }

    @Test
    public void testCookiesomainEqualsHost() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=www.b.com; version=1");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("www.b.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"www.b.com", (Object)((Cookie)cookies.get(0)).getDomain());
    }

    @Test
    public void testParseWithIllegalDomain1() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=a.b.com; version=1");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("www.a.b.com", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWithIllegalDomain2() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=.com; version=1");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("b.com", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseWithIllegalDomain4() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=.c.com; version=1");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("a.b.c.com", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testSecondDomainLevelCookie() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("sourceforge.net", 80, "/", false);
        try {
            cookiespec.validate((Cookie)cookie, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testSecondDomainLevelCookieMatch() throws Exception {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".sourceforge.net");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("sourceforge.net", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin));
    }

    @Test
    public void testParseWithWrongPath() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "cookie-name=cookie-value; domain=127.0.0.1; path=/not/just/root");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testCookieNameWithBlanks() throws Exception {
        BasicHeader setcookie = new BasicHeader("Set-Cookie", "invalid name=");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)setcookie, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testCookieNameStartingWithDollarSign() throws Exception {
        BasicHeader setcookie = new BasicHeader("Set-Cookie", "$invalid_name=");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        try {
            List cookies = cookiespec.parse((Header)setcookie, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testInvalidDomainWithSimpleHostName() throws Exception {
        RFC2109Spec cookiespec = new RFC2109Spec();
        BasicHeader header = new BasicHeader("Set-Cookie", "name=\"value\"; version=\"1\"; path=\"/\"; domain=\".mydomain.com\"");
        CookieOrigin origin1 = new CookieOrigin("host", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin1);
        try {
            cookiespec.validate((Cookie)cookies.get(0), origin1);
            Assert.fail((String)"MalformedCookieException must have thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
        CookieOrigin origin2 = new CookieOrigin("host2", 80, "/", false);
        header = new BasicHeader("Set-Cookie", "name=\"value\"; version=\"1\"; path=\"/\"; domain=\"host1\"");
        cookies = cookiespec.parse((Header)header, origin2);
        try {
            cookiespec.validate((Cookie)cookies.get(0), origin2);
            Assert.fail((String)"MalformedCookieException must have thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testCookieWithComma() throws Exception {
        BasicHeader header = new BasicHeader("Set-Cookie", "a=b,c");
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertEquals((String)"number of cookies", (long)2L, (long)cookies.size());
        Assert.assertEquals((Object)"a", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"c", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals(null, (Object)((Cookie)cookies.get(1)).getValue());
    }

    @Test
    public void testRFC2109CookieFormatting() throws Exception {
        RFC2109Spec cookiespec = new RFC2109Spec(null, false);
        BasicHeader header = new BasicHeader("Set-Cookie", "name=\"value\"; version=1; path=\"/\"; domain=\".mydomain.com\"");
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=1; name=\"value\"; $Path=\"/\"; $Domain=\".mydomain.com\"", (Object)((Header)headers.get(0)).getValue());
        header = new BasicHeader("Set-Cookie", "name=value; path=/; domain=.mydomain.com");
        cookies = cookiespec.parse((Header)header, origin);
        cookiespec.validate((Cookie)cookies.get(0), origin);
        headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=0; name=value; $Path=/; $Domain=.mydomain.com", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testRFC2109CookiesFormatting() throws Exception {
        RFC2109Spec cookiespec = new RFC2109Spec(null, true);
        BasicHeader header = new BasicHeader("Set-Cookie", "name1=value1; path=/; domain=.mydomain.com, name2=\"value2\"; version=\"1\"; path=\"/\"; domain=\".mydomain.com\"");
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)2L, (long)cookies.size());
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=0; name1=value1; $Path=/; $Domain=.mydomain.com; name2=value2; $Path=/; $Domain=.mydomain.com", (Object)((Header)headers.get(0)).getValue());
        header = new BasicHeader("Set-Cookie", "name1=value1; version=1; path=/; domain=.mydomain.com, name2=\"value2\"; version=\"1\"; path=\"/\"; domain=\".mydomain.com\"");
        cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)2L, (long)cookies.size());
        headers = cookiespec.formatCookies(cookies);
        Assert.assertEquals((Object)"$Version=1; name1=\"value1\"; $Path=\"/\"; $Domain=\".mydomain.com\"; name2=\"value2\"; $Path=\"/\"; $Domain=\".mydomain.com\"", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testNullCookieValueFormatting() {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setDomain(".whatever.com");
        cookie.setAttribute("domain", cookie.getDomain());
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        RFC2109Spec cookiespec = new RFC2109Spec();
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
        cookies.add(cookie);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=0; name=; $Path=/; $Domain=.whatever.com", (Object)((Header)headers.get(0)).getValue());
        cookie.setVersion(1);
        cookies = new ArrayList();
        cookies.add(cookie);
        headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=1; name=; $Path=\"/\"; $Domain=\".whatever.com\"", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testCookieNullDomainNullPathFormatting() {
        BasicClientCookie cookie = new BasicClientCookie("name", null);
        cookie.setPath("/");
        cookie.setAttribute("path", cookie.getPath());
        RFC2109Spec cookiespec = new RFC2109Spec();
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
        cookies.add(cookie);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=0; name=; $Path=/", (Object)((Header)headers.get(0)).getValue());
        cookie.removeAttribute("domain");
        cookie.removeAttribute("path");
        cookies = new ArrayList();
        cookies.add(cookie);
        headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=0; name=", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testCookieOrderingByPath() {
        BasicClientCookie c1 = new BasicClientCookie("name1", "value1");
        c1.setPath("/a/b/c");
        c1.setAttribute("path", c1.getPath());
        BasicClientCookie c2 = new BasicClientCookie("name2", "value2");
        c2.setPath("/a/b");
        c2.setAttribute("path", c2.getPath());
        BasicClientCookie c3 = new BasicClientCookie("name3", "value3");
        c3.setPath("/a");
        c3.setAttribute("path", c3.getPath());
        BasicClientCookie c4 = new BasicClientCookie("name4", "value4");
        c4.setPath("/");
        c4.setAttribute("path", c4.getPath());
        RFC2109Spec cookiespec = new RFC2109Spec(null, true);
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>();
        cookies.add(c2);
        cookies.add(c4);
        cookies.add(c1);
        cookies.add(c3);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=0; name1=value1; $Path=/a/b/c; name2=value2; $Path=/a/b; name3=value3; $Path=/a; name4=value4; $Path=/", (Object)((Header)headers.get(0)).getValue());
    }

    @Test(expected=MalformedCookieException.class)
    public void testVersion1CookieWithInvalidExpires() throws Exception {
        RFC2109Spec cookiespec = new RFC2109Spec();
        CookieOrigin origin = new CookieOrigin("myhost.mydomain.com", 80, "/", false);
        BasicHeader origHeader = new BasicHeader("Set-Cookie", "test=\"test\"; Version=1; Expires=Mon, 11-Feb-2013 10:39:19 GMT; Path=/");
        cookiespec.parse((Header)origHeader, origin);
    }

    @Test
    public void testInvalidInput() throws Exception {
        RFC2109Spec cookiespec = new RFC2109Spec();
        try {
            cookiespec.parse(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            cookiespec.parse((Header)new BasicHeader("Set-Cookie", "name=value"), null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            cookiespec.validate(null, null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            cookiespec.formatCookies(null);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            ArrayList cookies = new ArrayList();
            cookiespec.formatCookies(cookies);
            Assert.fail((String)"IllegalArgumentException must have been thrown");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }
}

