/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicClientCookie2;
import org.apache.http.impl.cookie.RFC2965Spec;
import org.apache.http.message.BasicHeader;
import org.junit.Assert;
import org.junit.Test;

public class TestCookieRFC2965Spec {
    @Test
    public void testParsePath() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Path=/;Version=1;Path=");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.containsAttribute("path"));
    }

    @Test
    public void testParsePathDefault() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/path/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"/path", (Object)cookie.getPath());
        Assert.assertFalse((boolean)cookie.containsAttribute("path"));
    }

    @Test
    public void testParseNullPath() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Path=;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.containsAttribute("path"));
    }

    @Test
    public void testParseBlankPath() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Path=\"   \";Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"/", (Object)cookie.getPath());
        Assert.assertTrue((boolean)cookie.containsAttribute("path"));
    }

    @Test
    public void testParseDomain() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Domain=.domain.com;Version=1;Domain=");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)".domain.com", (Object)cookie.getDomain());
        Assert.assertTrue((boolean)cookie.containsAttribute("domain"));
        header = new BasicHeader("Set-Cookie2", "name=value;Domain=domain.com;Version=1");
        cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)".domain.com", (Object)cookie.getDomain());
    }

    @Test
    public void testParseDomainDefaultValue() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"www.domain.com", (Object)cookie.getDomain());
        Assert.assertFalse((boolean)cookie.containsAttribute("domain"));
    }

    @Test
    public void testParseNullDomain() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Domain=;Version=1");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseBlankDomain() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Domain=\"   \";Version=1");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParsePort() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Port=\"80,800,8000\";Version=1;Port=nonsense");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        int[] ports = cookie.getPorts();
        Assert.assertNotNull((Object)ports);
        Assert.assertEquals((long)3L, (long)ports.length);
        Assert.assertEquals((long)80L, (long)ports[0]);
        Assert.assertEquals((long)800L, (long)ports[1]);
        Assert.assertEquals((long)8000L, (long)ports[2]);
        Assert.assertTrue((boolean)cookie.containsAttribute("port"));
    }

    @Test
    public void testParsePortDefault() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertFalse((boolean)cookie.containsAttribute("port"));
    }

    @Test
    public void testParseNullPort() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Port=;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        int[] ports = cookie.getPorts();
        Assert.assertNotNull((Object)ports);
        Assert.assertEquals((long)1L, (long)ports.length);
        Assert.assertEquals((long)80L, (long)ports[0]);
        Assert.assertEquals((Object)"", (Object)cookie.getAttribute("port"));
    }

    @Test
    public void testParseBlankPort() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Port=\"  \";Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        int[] ports = cookie.getPorts();
        Assert.assertNotNull((Object)ports);
        Assert.assertEquals((long)1L, (long)ports.length);
        Assert.assertEquals((long)80L, (long)ports[0]);
        Assert.assertEquals((Object)"  ", (Object)cookie.getAttribute("port"));
    }

    @Test
    public void testParseInvalidPort() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Port=nonsense;Version=1");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNegativePort() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Port=\"80,-800,8000\";Version=1");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNameValue() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1;");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
    }

    @Test
    public void testParseVersion() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1;");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((long)1L, (long)cookie.getVersion());
        Assert.assertTrue((boolean)cookie.containsAttribute("version"));
    }

    @Test
    public void testParseNullVersion() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=;");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNegativeVersion() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=-1;");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseMaxage() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Max-age=3600;Version=1;Max-age=nonsense");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertFalse((boolean)cookie.isExpired(new Date()));
    }

    @Test
    public void testParseMaxageDefault() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertFalse((boolean)cookie.isPersistent());
    }

    @Test
    public void testParseNullMaxage() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Max-age=;Version=1");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseNegativeMaxage() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Max-age=-3600;Version=1;");
        try {
            cookiespec.parse((Header)header, origin);
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testParseSecure() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Secure;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertTrue((boolean)cookie.isSecure());
    }

    @Test
    public void testParseDiscard() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Discard;Max-age=36000;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertFalse((boolean)cookie.isPersistent());
        header = new BasicHeader("Set-Cookie2", "name=value;Max-age=36000;Version=1");
        cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        cookie = (ClientCookie)cookies.get(0);
        Assert.assertTrue((boolean)cookie.isPersistent());
    }

    @Test
    public void testParseOtherAttributes() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Comment=\"good cookie\";CommentURL=\"www.domain.com/goodcookie/\";Secure;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"good cookie", (Object)cookie.getComment());
        Assert.assertEquals((Object)"www.domain.com/goodcookie/", (Object)cookie.getCommentURL());
        Assert.assertTrue((boolean)cookie.isSecure());
        header = new BasicHeader("Set-Cookie2", "name=value;Version=1");
        cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        cookie = (ClientCookie)cookies.get(0);
        Assert.assertFalse((boolean)cookie.isSecure());
    }

    @Test
    public void testCookiesWithComma() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "a=b,c");
        List cookies = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)2L, (long)cookies.size());
        Assert.assertEquals((Object)"a", (Object)((Cookie)cookies.get(0)).getName());
        Assert.assertEquals((Object)"b", (Object)((Cookie)cookies.get(0)).getValue());
        Assert.assertEquals((Object)"c", (Object)((Cookie)cookies.get(1)).getName());
        Assert.assertEquals(null, (Object)((Cookie)cookies.get(1)).getValue());
    }

    @Test
    public void testValidateNoDomain() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"www.domain.com", (Object)cookie.getDomain());
    }

    @Test
    public void testValidateDomainLeadingDot() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;Domain=domain.com;Version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)".domain.com", (Object)cookie.getDomain());
    }

    @Test
    public void testValidateDomainEmbeddedDot() throws Exception {
        int i;
        List cookies2;
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("b.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value; domain=.com; version=1");
        try {
            cookies2 = cookiespec.parse((Header)header, origin);
            for (i = 0; i < cookies2.size(); ++i) {
                cookiespec.validate((Cookie)cookies2.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException cookies2) {
            // empty catch block
        }
        origin = new CookieOrigin("www.domain.com", 80, "/", false);
        header = new BasicHeader("Set-Cookie2", "name=value;Domain=domain.com;Version=1");
        cookies2 = cookiespec.parse((Header)header, origin);
        for (i = 0; i < cookies2.size(); ++i) {
            cookiespec.validate((Cookie)cookies2.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies2);
        Assert.assertEquals((long)1L, (long)cookies2.size());
    }

    @Test
    public void testValidateDomainLocal() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("simplehost", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value; domain=.local; version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)".local", (Object)cookie.getDomain());
        header = new BasicHeader("Set-Cookie2", "name=value; domain=domain.com; version=1");
        try {
            cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testValidateDomainLocalhost() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("localhost", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value; version=1");
        List cookies = cookiespec.parse((Header)header, origin);
        for (int i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        Assert.assertEquals((Object)"localhost.local", (Object)cookie.getDomain());
    }

    @Test
    public void testValidateDomainEffectiveHost() throws Exception {
        int i;
        List cookies;
        CookieOrigin origin2;
        RFC2965Spec cookiespec = new RFC2965Spec();
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value; domain=.domain.com; version=1");
        try {
            origin2 = new CookieOrigin("www.domain.org", 80, "/", false);
            cookies = cookiespec.parse((Header)header, origin2);
            for (i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin2);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException origin2) {
            // empty catch block
        }
        origin2 = new CookieOrigin("www.domain.com", 80, "/", false);
        header = new BasicHeader("Set-Cookie2", "name=value; domain=.domain.com; version=1");
        cookies = cookiespec.parse((Header)header, origin2);
        for (i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin2);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
    }

    @Test
    public void testValidateDomainIllegal() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("a.b.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value; domain=.domain.com; version=1");
        try {
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testValidatePath() throws Exception {
        int i;
        List cookies;
        CookieOrigin origin2;
        RFC2965Spec cookiespec = new RFC2965Spec();
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value;path=/path;version=1");
        try {
            origin2 = new CookieOrigin("www.domain.com", 80, "/", false);
            cookies = cookiespec.parse((Header)header, origin2);
            for (i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin2);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException origin2) {
            // empty catch block
        }
        header = new BasicHeader("Set-Cookie2", "name=value;path=/Path;version=1");
        try {
            origin2 = new CookieOrigin("www.domain.com", 80, "/path", false);
            cookies = cookiespec.parse((Header)header, origin2);
            for (i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin2);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException origin3) {
            // empty catch block
        }
        origin2 = new CookieOrigin("www.domain.com", 80, "/path/path1", false);
        header = new BasicHeader("Set-Cookie2", "name=value;path=/path;version=1");
        cookies = cookiespec.parse((Header)header, origin2);
        for (i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin2);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        Assert.assertEquals((Object)"/path", (Object)((Cookie)cookies.get(0)).getPath());
    }

    @Test
    public void testValidateCookieName() throws Exception {
        int i;
        List cookies2;
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("127.0.0.1", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie2", "invalid name=value; version=1");
        try {
            cookies2 = cookiespec.parse((Header)header, origin);
            for (i = 0; i < cookies2.size(); ++i) {
                cookiespec.validate((Cookie)cookies2.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException cookies2) {
            // empty catch block
        }
        header = new BasicHeader("Set-Cookie2", "$invalid_name=value; version=1");
        try {
            cookies2 = cookiespec.parse((Header)header, origin);
            for (i = 0; i < cookies2.size(); ++i) {
                cookiespec.validate((Cookie)cookies2.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException exception should have been thrown");
        }
        catch (MalformedCookieException cookies3) {
            // empty catch block
        }
        header = new BasicHeader("Set-Cookie2", "name=value; version=1");
        cookies2 = cookiespec.parse((Header)header, origin);
        Assert.assertNotNull((Object)cookies2);
        Assert.assertEquals((long)1L, (long)cookies2.size());
        ClientCookie cookie = (ClientCookie)cookies2.get(0);
        Assert.assertEquals((Object)"name", (Object)cookie.getName());
        Assert.assertEquals((Object)"value", (Object)cookie.getValue());
    }

    @Test
    public void testValidatePort() throws Exception {
        int i;
        List cookies;
        CookieOrigin origin2;
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value; Port=\"80,800\"; version=1");
        RFC2965Spec cookiespec = new RFC2965Spec();
        try {
            origin2 = new CookieOrigin("www.domain.com", 8000, "/", false);
            cookies = cookiespec.parse((Header)header, origin2);
            for (i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin2);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException origin2) {
            // empty catch block
        }
        origin2 = new CookieOrigin("www.domain.com", 80, "/", false);
        cookies = cookiespec.parse((Header)header, origin2);
        for (i = 0; i < cookies.size(); ++i) {
            cookiespec.validate((Cookie)cookies.get(i), origin2);
        }
        Assert.assertNotNull((Object)cookies);
        Assert.assertEquals((long)1L, (long)cookies.size());
        ClientCookie cookie = (ClientCookie)cookies.get(0);
        int[] ports = cookie.getPorts();
        Assert.assertNotNull((Object)ports);
        Assert.assertEquals((long)2L, (long)ports.length);
        Assert.assertEquals((long)80L, (long)ports[0]);
        Assert.assertEquals((long)800L, (long)ports[1]);
    }

    @Test
    public void testValidateVersion() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        BasicHeader header = new BasicHeader("Set-Cookie2", "name=value");
        try {
            CookieOrigin origin = new CookieOrigin("www.domain.com", 8000, "/", false);
            List cookies = cookiespec.parse((Header)header, origin);
            for (int i = 0; i < cookies.size(); ++i) {
                cookiespec.validate((Cookie)cookies.get(i), origin);
            }
            Assert.fail((String)"MalformedCookieException should have been thrown");
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }

    @Test
    public void testMatchPath() throws Exception {
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/path");
        cookie.setPorts(new int[]{80});
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin1 = new CookieOrigin("www.domain.com", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("www.domain.com", 80, "/path/path1", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin2));
    }

    @Test
    public void testMatchDomain() throws Exception {
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/");
        cookie.setPorts(new int[]{80});
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin1 = new CookieOrigin("a.b.domain.com", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("www.domain.org", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin2));
        CookieOrigin origin3 = new CookieOrigin("www.domain.com", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin3));
    }

    @Test
    public void testMatchDomainLocal() throws Exception {
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".local");
        cookie.setPath("/");
        cookie.setPorts(new int[]{80});
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin1 = new CookieOrigin("host", 80, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("host.com", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin2));
    }

    @Test
    public void testMatchPort() throws Exception {
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/");
        cookie.setPorts(null);
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin1 = new CookieOrigin("www.domain.com", 8080, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("www.domain.com", 323, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin2));
        cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/");
        cookie.setPorts(new int[]{80, 8080});
        cookie.setAttribute("port", "80, 8080");
        CookieOrigin origin3 = new CookieOrigin("www.domain.com", 434, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin3));
        CookieOrigin origin4 = new CookieOrigin("www.domain.com", 8080, "/", false);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin4));
    }

    @Test
    public void testCookieExpiration() throws Exception {
        Date now = new Date();
        Date beforeOneHour = new Date(now.getTime() - 3600000L);
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/");
        cookie.setPorts(null);
        cookie.setExpiryDate(beforeOneHour);
        Assert.assertTrue((boolean)cookie.isExpired(now));
        Date afterOneHour = new Date(now.getTime() + 3600000L);
        cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/");
        cookie.setPorts(null);
        cookie.setExpiryDate(afterOneHour);
        Assert.assertFalse((boolean)cookie.isExpired(now));
        cookie.setDiscard(true);
        Assert.assertFalse((boolean)cookie.isPersistent());
        Assert.assertTrue((boolean)cookie.isExpired(now));
    }

    @Test
    public void testCookieSecure() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        BasicClientCookie2 cookie = new BasicClientCookie2("name", "value");
        cookie.setDomain(".domain.com");
        cookie.setPath("/");
        cookie.setSecure(true);
        CookieOrigin origin1 = new CookieOrigin("www.domain.com", 80, "/", false);
        Assert.assertFalse((boolean)cookiespec.match((Cookie)cookie, origin1));
        CookieOrigin origin2 = new CookieOrigin("www.domain.com", 80, "/", true);
        Assert.assertTrue((boolean)cookiespec.match((Cookie)cookie, origin2));
    }

    @Test
    public void testRFC2965CookieFormatting() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec(null, true);
        BasicClientCookie2 cookie1 = new BasicClientCookie2("name1", "value");
        cookie1.setDomain(".domain.com");
        cookie1.setPath("/");
        cookie1.setPorts(new int[]{80, 8080});
        cookie1.setVersion(1);
        cookie1.setAttribute("domain", ".domain.com");
        cookie1.setAttribute("path", "/");
        cookie1.setAttribute("port", "80,8080");
        ArrayList<BasicClientCookie2> cookies = new ArrayList<BasicClientCookie2>();
        cookies.add(cookie1);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=1; name1=\"value\"; $Path=\"/\"; $Domain=\".domain.com\"; $Port=\"80,8080\"", (Object)((Header)headers.get(0)).getValue());
        BasicClientCookie2 cookie2 = new BasicClientCookie2("name2", "value");
        cookie2.setDomain(".domain.com");
        cookie2.setPath("/a/");
        cookie2.setPorts(new int[]{80, 8080});
        cookie2.setVersion(2);
        cookie2.setAttribute("domain", ".domain.com");
        cookie2.setAttribute("path", "/a/");
        cookies = new ArrayList();
        cookies.add(cookie2);
        headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=2; name2=\"value\"; $Path=\"/a/\"; $Domain=\".domain.com\"", (Object)((Header)headers.get(0)).getValue());
        BasicClientCookie2 cookie3 = new BasicClientCookie2("name3", "value");
        cookie3.setDomain(".domain.com");
        cookie3.setPath("/a/b/");
        cookie3.setPorts(new int[]{80, 8080});
        cookie3.setVersion(1);
        cookie3.setAttribute("path", "/a/b/");
        cookie3.setAttribute("port", "  ");
        cookies = new ArrayList();
        cookies.add(cookie3);
        headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=1; name3=\"value\"; $Path=\"/a/b/\"; $Port=\"\"", (Object)((Header)headers.get(0)).getValue());
        cookies = new ArrayList();
        cookies.add(cookie3);
        cookies.add(cookie2);
        cookies.add(cookie1);
        headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=1; name3=\"value\"; $Path=\"/a/b/\"; $Port=\"\"; name2=\"value\"; $Path=\"/a/\"; $Domain=\".domain.com\"; name1=\"value\"; $Path=\"/\"; $Domain=\".domain.com\"; $Port=\"80,8080\"", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testRFC2965CookiesFormatting() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec(null, true);
        BasicClientCookie2 cookie1 = new BasicClientCookie2("name1", "value1");
        cookie1.setDomain(".domain.com");
        cookie1.setPath("/");
        cookie1.setPorts(new int[]{80, 8080});
        cookie1.setVersion(1);
        cookie1.setAttribute("domain", ".domain.com");
        cookie1.setAttribute("path", "/");
        cookie1.setAttribute("port", "80,8080");
        BasicClientCookie2 cookie2 = new BasicClientCookie2("name2", "");
        cookie2.setDomain(".domain.com");
        cookie2.setPath("/");
        cookie2.setPorts(new int[]{80, 8080});
        cookie2.setVersion(1);
        cookie2.setAttribute("domain", ".domain.com");
        cookie2.setAttribute("path", "/");
        ArrayList<BasicClientCookie2> cookies = new ArrayList<BasicClientCookie2>();
        cookies.add(cookie1);
        cookies.add(cookie2);
        List headers = cookiespec.formatCookies(cookies);
        Assert.assertNotNull((Object)headers);
        Assert.assertEquals((long)1L, (long)headers.size());
        Assert.assertEquals((Object)"$Version=1; name1=\"value1\"; $Path=\"/\"; $Domain=\".domain.com\"; $Port=\"80,8080\"; name2=\"\"; $Path=\"/\"; $Domain=\".domain.com\"", (Object)((Header)headers.get(0)).getValue());
    }

    @Test
    public void testRejectSetCookie() throws Exception {
        RFC2965Spec cookiespec = new RFC2965Spec();
        CookieOrigin origin = new CookieOrigin("www.domain.com", 80, "/", false);
        BasicHeader header = new BasicHeader("Set-Cookie", "name=value; domain=.domain.com; version=1");
        try {
            cookiespec.parse((Header)header, origin);
        }
        catch (MalformedCookieException malformedCookieException) {
            // empty catch block
        }
    }
}

