/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.impl.client.IdleConnectionEvictor;
import org.junit.Assert;
import org.junit.Test;
import org.mockito.Mockito;
import org.mockito.verification.VerificationMode;

public class TestIdleConnectionEvictor {
    @Test
    public void testEvictExpiredAndIdle() throws Exception {
        HttpClientConnectionManager cm = (HttpClientConnectionManager)Mockito.mock(HttpClientConnectionManager.class);
        IdleConnectionEvictor connectionEvictor = new IdleConnectionEvictor(cm, 500L, TimeUnit.MILLISECONDS, 3L, TimeUnit.SECONDS);
        connectionEvictor.start();
        Thread.sleep(1000L);
        ((HttpClientConnectionManager)Mockito.verify((Object)cm, (VerificationMode)Mockito.atLeast((int)1))).closeExpiredConnections();
        ((HttpClientConnectionManager)Mockito.verify((Object)cm, (VerificationMode)Mockito.atLeast((int)1))).closeIdleConnections(3000L, TimeUnit.MILLISECONDS);
        Assert.assertTrue((boolean)connectionEvictor.isRunning());
        connectionEvictor.shutdown();
        connectionEvictor.awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)connectionEvictor.isRunning());
    }

    @Test
    public void testEvictExpiredOnly() throws Exception {
        HttpClientConnectionManager cm = (HttpClientConnectionManager)Mockito.mock(HttpClientConnectionManager.class);
        IdleConnectionEvictor connectionEvictor = new IdleConnectionEvictor(cm, 500L, TimeUnit.MILLISECONDS, 0L, TimeUnit.SECONDS);
        connectionEvictor.start();
        Thread.sleep(1000L);
        ((HttpClientConnectionManager)Mockito.verify((Object)cm, (VerificationMode)Mockito.atLeast((int)1))).closeExpiredConnections();
        ((HttpClientConnectionManager)Mockito.verify((Object)cm, (VerificationMode)Mockito.never())).closeIdleConnections(Mockito.anyLong(), (TimeUnit)((Object)Mockito.any()));
        Assert.assertTrue((boolean)connectionEvictor.isRunning());
        connectionEvictor.shutdown();
        connectionEvictor.awaitTermination(1L, TimeUnit.SECONDS);
        Assert.assertFalse((boolean)connectionEvictor.isRunning());
    }
}

