/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.aws.s3;

import java.io.Serializable;
import java.net.URI;
import java.time.Duration;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;
import org.apache.iceberg.EnvironmentContext;
import org.apache.iceberg.aws.AwsClientProperties;
import org.apache.iceberg.aws.s3.S3AccessGrantsPluginConfigurations;
import org.apache.iceberg.aws.s3.signer.S3V4RestSignerClient;
import org.apache.iceberg.common.DynMethods;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.util.PropertyUtil;
import org.apache.iceberg.util.SerializableMap;
import software.amazon.awssdk.auth.credentials.AnonymousCredentialsProvider;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.core.client.config.ClientOverrideConfiguration;
import software.amazon.awssdk.core.client.config.SdkAdvancedClientOption;
import software.amazon.awssdk.core.exception.SdkServiceException;
import software.amazon.awssdk.core.retry.RetryMode;
import software.amazon.awssdk.core.retry.RetryPolicy;
import software.amazon.awssdk.core.retry.backoff.BackoffStrategy;
import software.amazon.awssdk.core.retry.backoff.EqualJitterBackoffStrategy;
import software.amazon.awssdk.core.retry.conditions.OrRetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryCondition;
import software.amazon.awssdk.core.retry.conditions.RetryOnExceptionsCondition;
import software.amazon.awssdk.core.retry.conditions.TokenBucketRetryCondition;
import software.amazon.awssdk.services.s3.S3ClientBuilder;
import software.amazon.awssdk.services.s3.S3Configuration;
import software.amazon.awssdk.services.s3.model.ObjectCannedACL;
import software.amazon.awssdk.services.s3.model.Tag;

public class S3FileIOProperties
implements Serializable {
    public static final String CLIENT_FACTORY = "s3.client-factory-impl";
    public static final String S3_ACCESS_GRANTS_ENABLED = "s3.access-grants.enabled";
    public static final boolean S3_ACCESS_GRANTS_ENABLED_DEFAULT = false;
    public static final String S3_ACCESS_GRANTS_FALLBACK_TO_IAM_ENABLED = "s3.access-grants.fallback-to-iam";
    public static final boolean S3_ACCESS_GRANTS_FALLBACK_TO_IAM_ENABLED_DEFAULT = false;
    public static final String SSE_TYPE = "s3.sse.type";
    public static final String SSE_TYPE_NONE = "none";
    public static final String SSE_TYPE_KMS = "kms";
    public static final String DSSE_TYPE_KMS = "dsse-kms";
    public static final String SSE_TYPE_S3 = "s3";
    public static final String SSE_TYPE_CUSTOM = "custom";
    public static final String SSE_KEY = "s3.sse.key";
    public static final String SSE_MD5 = "s3.sse.md5";
    public static final String MULTIPART_UPLOAD_THREADS = "s3.multipart.num-threads";
    public static final String MULTIPART_SIZE = "s3.multipart.part-size-bytes";
    public static final int MULTIPART_SIZE_DEFAULT = 0x2000000;
    public static final int MULTIPART_SIZE_MIN = 0x500000;
    public static final String MULTIPART_THRESHOLD_FACTOR = "s3.multipart.threshold";
    public static final double MULTIPART_THRESHOLD_FACTOR_DEFAULT = 1.5;
    public static final String STAGING_DIRECTORY = "s3.staging-dir";
    public static final String ACL = "s3.acl";
    public static final String ENDPOINT = "s3.endpoint";
    public static final String PATH_STYLE_ACCESS = "s3.path-style-access";
    public static final boolean PATH_STYLE_ACCESS_DEFAULT = false;
    public static final String ACCESS_KEY_ID = "s3.access-key-id";
    public static final String SECRET_ACCESS_KEY = "s3.secret-access-key";
    public static final String SESSION_TOKEN = "s3.session-token";
    static final String SESSION_TOKEN_EXPIRES_AT_MS = "s3.session-token-expires-at-ms";
    public static final String USE_ARN_REGION_ENABLED = "s3.use-arn-region-enabled";
    public static final boolean USE_ARN_REGION_ENABLED_DEFAULT = false;
    public static final String CHECKSUM_ENABLED = "s3.checksum-enabled";
    public static final boolean CHECKSUM_ENABLED_DEFAULT = false;
    public static final String REMOTE_SIGNING_ENABLED = "s3.remote-signing-enabled";
    public static final boolean REMOTE_SIGNING_ENABLED_DEFAULT = false;
    public static final String DELETE_BATCH_SIZE = "s3.delete.batch-size";
    public static final int DELETE_BATCH_SIZE_DEFAULT = 250;
    public static final int DELETE_BATCH_SIZE_MAX = 1000;
    public static final String WRITE_TAGS_PREFIX = "s3.write.tags.";
    public static final String WRITE_TABLE_TAG_ENABLED = "s3.write.table-tag-enabled";
    public static final boolean WRITE_TABLE_TAG_ENABLED_DEFAULT = false;
    public static final String WRITE_STORAGE_CLASS = "s3.write.storage-class";
    public static final String WRITE_NAMESPACE_TAG_ENABLED = "s3.write.namespace-tag-enabled";
    public static final boolean WRITE_NAMESPACE_TAG_ENABLED_DEFAULT = false;
    public static final String S3_TAG_ICEBERG_TABLE = "iceberg.table";
    public static final String S3_TAG_ICEBERG_NAMESPACE = "iceberg.namespace";
    public static final String DELETE_TAGS_PREFIX = "s3.delete.tags.";
    public static final String DELETE_THREADS = "s3.delete.num-threads";
    public static final String DELETE_ENABLED = "s3.delete-enabled";
    public static final boolean DELETE_ENABLED_DEFAULT = true;
    public static final String ACCELERATION_ENABLED = "s3.acceleration-enabled";
    public static final boolean ACCELERATION_ENABLED_DEFAULT = false;
    public static final String DUALSTACK_ENABLED = "s3.dualstack-enabled";
    public static final boolean DUALSTACK_ENABLED_DEFAULT = false;
    public static final String CROSS_REGION_ACCESS_ENABLED = "s3.cross-region-access-enabled";
    public static final boolean CROSS_REGION_ACCESS_ENABLED_DEFAULT = false;
    public static final String ACCESS_POINTS_PREFIX = "s3.access-points.";
    public static final String PRELOAD_CLIENT_ENABLED = "s3.preload-client-enabled";
    public static final boolean PRELOAD_CLIENT_ENABLED_DEFAULT = false;
    private static final String S3_FILE_IO_USER_AGENT = "s3fileio/" + EnvironmentContext.get();
    public static final String S3_RETRY_NUM_RETRIES = "s3.retry.num-retries";
    public static final int S3_RETRY_NUM_RETRIES_DEFAULT = 5;
    public static final String S3_RETRY_MIN_WAIT_MS = "s3.retry.min-wait-ms";
    public static final long S3_RETRY_MIN_WAIT_MS_DEFAULT = 2000L;
    public static final String S3_RETRY_MAX_WAIT_MS = "s3.retry.max-wait-ms";
    public static final long S3_RETRY_MAX_WAIT_MS_DEFAULT = 20000L;
    public static final String S3_DIRECTORY_BUCKET_LIST_PREFIX_AS_DIRECTORY = "s3.directory-bucket.list-prefix-as-directory";
    public static final boolean S3_DIRECTORY_BUCKET_LIST_PREFIX_AS_DIRECTORY_DEFAULT = true;
    private String sseType;
    private String sseKey;
    private String sseMd5;
    private final String accessKeyId;
    private final String secretAccessKey;
    private final String sessionToken;
    private boolean isS3AccessGrantsEnabled;
    private boolean isS3AccessGrantsFallbackToIamEnabled;
    private int multipartUploadThreads;
    private int multiPartSize;
    private int deleteBatchSize;
    private double multipartThresholdFactor;
    private String stagingDirectory;
    private ObjectCannedACL acl;
    private boolean isChecksumEnabled;
    private final Set<Tag> writeTags;
    private boolean isWriteTableTagEnabled;
    private boolean isWriteNamespaceTagEnabled;
    private final Set<Tag> deleteTags;
    private int deleteThreads;
    private boolean isDeleteEnabled;
    private final Map<String, String> bucketToAccessPointMapping;
    private boolean isPreloadClientEnabled;
    private final boolean isDualStackEnabled;
    private final boolean isCrossRegionAccessEnabled;
    private final boolean isPathStyleAccess;
    private final boolean isUseArnRegionEnabled;
    private final boolean isAccelerationEnabled;
    private final String endpoint;
    private final boolean isRemoteSigningEnabled;
    private String writeStorageClass;
    private int s3RetryNumRetries;
    private long s3RetryMinWaitMs;
    private long s3RetryMaxWaitMs;
    private boolean s3DirectoryBucketListPrefixAsDirectory;
    private final Map<String, String> allProperties;

    public S3FileIOProperties() {
        this.sseType = SSE_TYPE_NONE;
        this.sseKey = null;
        this.sseMd5 = null;
        this.accessKeyId = null;
        this.secretAccessKey = null;
        this.sessionToken = null;
        this.acl = null;
        this.endpoint = null;
        this.multipartUploadThreads = Runtime.getRuntime().availableProcessors();
        this.multiPartSize = 0x2000000;
        this.multipartThresholdFactor = 1.5;
        this.deleteBatchSize = 250;
        this.stagingDirectory = System.getProperty("java.io.tmpdir");
        this.isChecksumEnabled = false;
        this.writeTags = Sets.newHashSet();
        this.isWriteTableTagEnabled = false;
        this.isWriteNamespaceTagEnabled = false;
        this.deleteTags = Sets.newHashSet();
        this.deleteThreads = Runtime.getRuntime().availableProcessors();
        this.isDeleteEnabled = true;
        this.bucketToAccessPointMapping = Collections.emptyMap();
        this.isPreloadClientEnabled = false;
        this.isDualStackEnabled = false;
        this.isCrossRegionAccessEnabled = false;
        this.isPathStyleAccess = false;
        this.isUseArnRegionEnabled = false;
        this.isAccelerationEnabled = false;
        this.isRemoteSigningEnabled = false;
        this.isS3AccessGrantsEnabled = false;
        this.isS3AccessGrantsFallbackToIamEnabled = false;
        this.s3RetryNumRetries = 5;
        this.s3RetryMinWaitMs = 2000L;
        this.s3RetryMaxWaitMs = 20000L;
        this.s3DirectoryBucketListPrefixAsDirectory = true;
        this.allProperties = Maps.newHashMap();
        ValidationException.check((boolean)this.keyIdAccessKeyBothConfigured(), (String)"S3 client access key ID and secret access key must be set at the same time", (Object[])new Object[0]);
    }

    public S3FileIOProperties(Map<String, String> properties) {
        this.sseType = properties.getOrDefault(SSE_TYPE, SSE_TYPE_NONE);
        this.sseKey = properties.get(SSE_KEY);
        this.sseMd5 = properties.get(SSE_MD5);
        this.accessKeyId = properties.get(ACCESS_KEY_ID);
        this.secretAccessKey = properties.get(SECRET_ACCESS_KEY);
        this.sessionToken = properties.get(SESSION_TOKEN);
        if (SSE_TYPE_CUSTOM.equals(this.sseType)) {
            Preconditions.checkArgument((null != this.sseKey ? 1 : 0) != 0, (Object)"Cannot initialize SSE-C S3FileIO with null encryption key");
            Preconditions.checkArgument((null != this.sseMd5 ? 1 : 0) != 0, (Object)"Cannot initialize SSE-C S3FileIO with null encryption key MD5");
        }
        this.endpoint = properties.get(ENDPOINT);
        this.multipartUploadThreads = PropertyUtil.propertyAsInt(properties, (String)MULTIPART_UPLOAD_THREADS, (int)Runtime.getRuntime().availableProcessors());
        this.isPathStyleAccess = PropertyUtil.propertyAsBoolean(properties, (String)PATH_STYLE_ACCESS, (boolean)false);
        this.isUseArnRegionEnabled = PropertyUtil.propertyAsBoolean(properties, (String)USE_ARN_REGION_ENABLED, (boolean)false);
        this.isAccelerationEnabled = PropertyUtil.propertyAsBoolean(properties, (String)ACCELERATION_ENABLED, (boolean)false);
        this.isDualStackEnabled = PropertyUtil.propertyAsBoolean(properties, (String)DUALSTACK_ENABLED, (boolean)false);
        this.isCrossRegionAccessEnabled = PropertyUtil.propertyAsBoolean(properties, (String)CROSS_REGION_ACCESS_ENABLED, (boolean)false);
        try {
            this.multiPartSize = PropertyUtil.propertyAsInt(properties, (String)MULTIPART_SIZE, (int)0x2000000);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(String.format("Input malformed or exceeded maximum multipart upload size 5GB: %s", properties.get(MULTIPART_SIZE)));
        }
        this.multipartThresholdFactor = PropertyUtil.propertyAsDouble(properties, (String)MULTIPART_THRESHOLD_FACTOR, (double)1.5);
        Preconditions.checkArgument((this.multipartThresholdFactor >= 1.0 ? 1 : 0) != 0, (Object)"Multipart threshold factor must be >= to 1.0");
        Preconditions.checkArgument((this.multiPartSize >= 0x500000 ? 1 : 0) != 0, (Object)"Minimum multipart upload object size must be larger than 5 MB.");
        this.stagingDirectory = PropertyUtil.propertyAsString(properties, (String)STAGING_DIRECTORY, (String)System.getProperty("java.io.tmpdir"));
        String aclType = properties.get(ACL);
        this.acl = ObjectCannedACL.fromValue((String)aclType);
        Preconditions.checkArgument((this.acl == null || !this.acl.equals((Object)ObjectCannedACL.UNKNOWN_TO_SDK_VERSION) ? 1 : 0) != 0, (Object)("Cannot support S3 CannedACL " + aclType));
        this.isChecksumEnabled = PropertyUtil.propertyAsBoolean(properties, (String)CHECKSUM_ENABLED, (boolean)false);
        this.deleteBatchSize = PropertyUtil.propertyAsInt(properties, (String)DELETE_BATCH_SIZE, (int)250);
        Preconditions.checkArgument((this.deleteBatchSize > 0 && this.deleteBatchSize <= 1000 ? 1 : 0) != 0, (Object)String.format("Deletion batch size must be between 1 and %s", 1000));
        this.writeTags = this.toS3Tags(properties, WRITE_TAGS_PREFIX);
        this.isWriteTableTagEnabled = PropertyUtil.propertyAsBoolean(properties, (String)WRITE_TABLE_TAG_ENABLED, (boolean)false);
        this.isWriteNamespaceTagEnabled = PropertyUtil.propertyAsBoolean(properties, (String)WRITE_NAMESPACE_TAG_ENABLED, (boolean)false);
        this.deleteTags = this.toS3Tags(properties, DELETE_TAGS_PREFIX);
        this.deleteThreads = PropertyUtil.propertyAsInt(properties, (String)DELETE_THREADS, (int)Runtime.getRuntime().availableProcessors());
        this.isDeleteEnabled = PropertyUtil.propertyAsBoolean(properties, (String)DELETE_ENABLED, (boolean)true);
        this.bucketToAccessPointMapping = PropertyUtil.propertiesWithPrefix(properties, (String)ACCESS_POINTS_PREFIX);
        this.isPreloadClientEnabled = PropertyUtil.propertyAsBoolean(properties, (String)PRELOAD_CLIENT_ENABLED, (boolean)false);
        this.isRemoteSigningEnabled = PropertyUtil.propertyAsBoolean(properties, (String)REMOTE_SIGNING_ENABLED, (boolean)false);
        this.writeStorageClass = properties.get(WRITE_STORAGE_CLASS);
        this.allProperties = SerializableMap.copyOf(properties);
        this.isS3AccessGrantsEnabled = PropertyUtil.propertyAsBoolean(properties, (String)S3_ACCESS_GRANTS_ENABLED, (boolean)false);
        this.isS3AccessGrantsFallbackToIamEnabled = PropertyUtil.propertyAsBoolean(properties, (String)S3_ACCESS_GRANTS_FALLBACK_TO_IAM_ENABLED, (boolean)false);
        this.s3RetryNumRetries = PropertyUtil.propertyAsInt(properties, (String)S3_RETRY_NUM_RETRIES, (int)5);
        this.s3RetryMinWaitMs = PropertyUtil.propertyAsLong(properties, (String)S3_RETRY_MIN_WAIT_MS, (long)2000L);
        this.s3RetryMaxWaitMs = PropertyUtil.propertyAsLong(properties, (String)S3_RETRY_MAX_WAIT_MS, (long)20000L);
        this.s3DirectoryBucketListPrefixAsDirectory = PropertyUtil.propertyAsBoolean(properties, (String)S3_DIRECTORY_BUCKET_LIST_PREFIX_AS_DIRECTORY, (boolean)true);
        ValidationException.check((boolean)this.keyIdAccessKeyBothConfigured(), (String)"S3 client access key ID and secret access key must be set at the same time", (Object[])new Object[0]);
    }

    public String sseType() {
        return this.sseType;
    }

    public void setSseType(String sseType) {
        this.sseType = sseType;
    }

    public String sseKey() {
        return this.sseKey;
    }

    public void setSseKey(String sseKey) {
        this.sseKey = sseKey;
    }

    public int deleteBatchSize() {
        return this.deleteBatchSize;
    }

    public void setDeleteBatchSize(int deleteBatchSize) {
        this.deleteBatchSize = deleteBatchSize;
    }

    public String sseMd5() {
        return this.sseMd5;
    }

    public void setSseMd5(String sseMd5) {
        this.sseMd5 = sseMd5;
    }

    public int multipartUploadThreads() {
        return this.multipartUploadThreads;
    }

    public void setMultipartUploadThreads(int threads) {
        this.multipartUploadThreads = threads;
    }

    public int multiPartSize() {
        return this.multiPartSize;
    }

    public void setMultiPartSize(int size) {
        this.multiPartSize = size;
    }

    public double multipartThresholdFactor() {
        return this.multipartThresholdFactor;
    }

    public void setMultipartThresholdFactor(double factor) {
        this.multipartThresholdFactor = factor;
    }

    public String stagingDirectory() {
        return this.stagingDirectory;
    }

    public void setStagingDirectory(String directory) {
        this.stagingDirectory = directory;
    }

    public ObjectCannedACL acl() {
        return this.acl;
    }

    public void setAcl(ObjectCannedACL acl) {
        this.acl = acl;
    }

    public boolean isPreloadClientEnabled() {
        return this.isPreloadClientEnabled;
    }

    public void setPreloadClientEnabled(boolean preloadClientEnabled) {
        this.isPreloadClientEnabled = preloadClientEnabled;
    }

    public boolean isDualStackEnabled() {
        return this.isDualStackEnabled;
    }

    public boolean isCrossRegionAccessEnabled() {
        return this.isCrossRegionAccessEnabled;
    }

    public boolean isPathStyleAccess() {
        return this.isPathStyleAccess;
    }

    public boolean isUseArnRegionEnabled() {
        return this.isUseArnRegionEnabled;
    }

    public boolean isAccelerationEnabled() {
        return this.isAccelerationEnabled;
    }

    public boolean isChecksumEnabled() {
        return this.isChecksumEnabled;
    }

    public boolean isRemoteSigningEnabled() {
        return this.isRemoteSigningEnabled;
    }

    public String endpoint() {
        return this.endpoint;
    }

    public void setChecksumEnabled(boolean eTagCheckEnabled) {
        this.isChecksumEnabled = eTagCheckEnabled;
    }

    public Set<Tag> writeTags() {
        return this.writeTags;
    }

    public boolean writeTableTagEnabled() {
        return this.isWriteTableTagEnabled;
    }

    public void setWriteTableTagEnabled(boolean s3WriteTableNameTagEnabled) {
        this.isWriteTableTagEnabled = s3WriteTableNameTagEnabled;
    }

    public boolean isWriteNamespaceTagEnabled() {
        return this.isWriteNamespaceTagEnabled;
    }

    public void setWriteNamespaceTagEnabled(boolean writeNamespaceTagEnabled) {
        this.isWriteNamespaceTagEnabled = writeNamespaceTagEnabled;
    }

    public Set<Tag> deleteTags() {
        return this.deleteTags;
    }

    public int deleteThreads() {
        return this.deleteThreads;
    }

    public void setDeleteThreads(int threads) {
        this.deleteThreads = threads;
    }

    public boolean isDeleteEnabled() {
        return this.isDeleteEnabled;
    }

    public void setDeleteEnabled(boolean deleteEnabled) {
        this.isDeleteEnabled = deleteEnabled;
    }

    public Map<String, String> bucketToAccessPointMapping() {
        return this.bucketToAccessPointMapping;
    }

    public String accessKeyId() {
        return this.accessKeyId;
    }

    public String secretAccessKey() {
        return this.secretAccessKey;
    }

    public String sessionToken() {
        return this.sessionToken;
    }

    public String writeStorageClass() {
        return this.writeStorageClass;
    }

    private Set<Tag> toS3Tags(Map<String, String> properties, String prefix) {
        return PropertyUtil.propertiesWithPrefix(properties, (String)prefix).entrySet().stream().map(e -> (Tag)Tag.builder().key((String)e.getKey()).value((String)e.getValue()).build()).collect(Collectors.toSet());
    }

    public boolean isS3AccessGrantsEnabled() {
        return this.isS3AccessGrantsEnabled;
    }

    public void setS3AccessGrantsEnabled(boolean s3AccessGrantsEnabled) {
        this.isS3AccessGrantsEnabled = s3AccessGrantsEnabled;
    }

    public boolean isS3AccessGrantsFallbackToIamEnabled() {
        return this.isS3AccessGrantsFallbackToIamEnabled;
    }

    public void setS3AccessGrantsFallbackToIamEnabled(boolean s3AccessGrantsFallbackToIamEnabled) {
        this.isS3AccessGrantsFallbackToIamEnabled = s3AccessGrantsFallbackToIamEnabled;
    }

    public int s3RetryNumRetries() {
        return this.s3RetryNumRetries;
    }

    public void setS3RetryNumRetries(int s3RetryNumRetries) {
        this.s3RetryNumRetries = s3RetryNumRetries;
    }

    public long s3RetryMinWaitMs() {
        return this.s3RetryMinWaitMs;
    }

    public void setS3RetryMinWaitMs(long s3RetryMinWaitMs) {
        this.s3RetryMinWaitMs = s3RetryMinWaitMs;
    }

    public long s3RetryMaxWaitMs() {
        return this.s3RetryMaxWaitMs;
    }

    public void setS3RetryMaxWaitMs(long s3RetryMaxWaitMs) {
        this.s3RetryMaxWaitMs = s3RetryMaxWaitMs;
    }

    public long s3RetryTotalWaitMs() {
        return (long)this.s3RetryNumRetries() * this.s3RetryMaxWaitMs();
    }

    public boolean isS3DirectoryBucketListPrefixAsDirectory() {
        return this.s3DirectoryBucketListPrefixAsDirectory;
    }

    public void setS3DirectoryBucketListPrefixAsDirectory(boolean s3DirectoryBucketListPrefixAsDirectory) {
        this.s3DirectoryBucketListPrefixAsDirectory = s3DirectoryBucketListPrefixAsDirectory;
    }

    private boolean keyIdAccessKeyBothConfigured() {
        return this.accessKeyId == null == (this.secretAccessKey == null);
    }

    public <T extends S3ClientBuilder> void applyCredentialConfigurations(AwsClientProperties awsClientProperties, T builder) {
        builder.credentialsProvider((AwsCredentialsProvider)(this.isRemoteSigningEnabled ? AnonymousCredentialsProvider.create() : awsClientProperties.credentialsProvider(this.accessKeyId, this.secretAccessKey, this.sessionToken)));
    }

    public <T extends S3ClientBuilder> void applyServiceConfigurations(T builder) {
        ((S3ClientBuilder)((S3ClientBuilder)builder.dualstackEnabled(Boolean.valueOf(this.isDualStackEnabled))).crossRegionAccessEnabled(Boolean.valueOf(this.isCrossRegionAccessEnabled))).serviceConfiguration((S3Configuration)S3Configuration.builder().pathStyleAccessEnabled(Boolean.valueOf(this.isPathStyleAccess)).useArnRegionEnabled(Boolean.valueOf(this.isUseArnRegionEnabled)).accelerateModeEnabled(Boolean.valueOf(this.isAccelerationEnabled)).build());
    }

    public <T extends S3ClientBuilder> void applySignerConfiguration(T builder) {
        if (this.isRemoteSigningEnabled) {
            ClientOverrideConfiguration.Builder configBuilder = null != builder.overrideConfiguration() ? builder.overrideConfiguration().toBuilder() : ClientOverrideConfiguration.builder();
            builder.overrideConfiguration((ClientOverrideConfiguration)configBuilder.putAdvancedOption(SdkAdvancedClientOption.SIGNER, (Object)S3V4RestSignerClient.create(this.allProperties)).build());
        }
    }

    public <T extends S3ClientBuilder> void applyEndpointConfigurations(T builder) {
        if (this.endpoint != null) {
            builder.endpointOverride(URI.create(this.endpoint));
        }
    }

    public <T extends S3ClientBuilder> void applyRetryConfigurations(T builder) {
        ClientOverrideConfiguration.Builder configBuilder = null != builder.overrideConfiguration() ? builder.overrideConfiguration().toBuilder() : ClientOverrideConfiguration.builder();
        builder.overrideConfiguration((ClientOverrideConfiguration)configBuilder.retryPolicy(RetryPolicy.builder((RetryMode)RetryMode.LEGACY).numRetries(Integer.valueOf(this.s3RetryNumRetries)).throttlingBackoffStrategy((BackoffStrategy)EqualJitterBackoffStrategy.builder().baseDelay(Duration.ofMillis(this.s3RetryMinWaitMs)).maxBackoffTime(Duration.ofMillis(this.s3RetryMaxWaitMs)).build()).retryCondition((RetryCondition)OrRetryCondition.create((RetryCondition[])new RetryCondition[]{RetryCondition.defaultRetryCondition(), RetryOnExceptionsCondition.create((Class[])new Class[]{XMLStreamException.class})})).retryCapacityCondition((RetryCondition)TokenBucketRetryCondition.builder().tokenBucketSize(500).exceptionCostFunction(e -> {
            SdkServiceException sdkServiceException;
            if (e instanceof SdkServiceException && ((sdkServiceException = (SdkServiceException)e).isThrottlingException() || sdkServiceException.statusCode() == 503)) {
                return 0;
            }
            return 5;
        }).build()).build()).build());
    }

    public <T extends S3ClientBuilder> void applyS3AccessGrantsConfigurations(T builder) {
        if (this.isS3AccessGrantsEnabled) {
            S3AccessGrantsPluginConfigurations s3AccessGrantsPluginConfigurations = (S3AccessGrantsPluginConfigurations)this.loadSdkPluginConfigurations(S3AccessGrantsPluginConfigurations.class.getName(), this.allProperties);
            s3AccessGrantsPluginConfigurations.configureS3ClientBuilder(builder);
        }
    }

    public <T extends S3ClientBuilder> void applyUserAgentConfigurations(T builder) {
        ClientOverrideConfiguration.Builder configBuilder = null != builder.overrideConfiguration() ? builder.overrideConfiguration().toBuilder() : ClientOverrideConfiguration.builder();
        builder.overrideConfiguration((ClientOverrideConfiguration)configBuilder.putAdvancedOption(SdkAdvancedClientOption.USER_AGENT_PREFIX, (Object)S3_FILE_IO_USER_AGENT).build());
    }

    private <T> T loadSdkPluginConfigurations(String impl, Map<String, String> properties) {
        try {
            Object sdkPluginConfigurations = DynMethods.builder((String)"create").hiddenImpl(impl, new Class[]{Map.class}).buildStaticChecked().invoke(new Object[]{properties});
            return (T)sdkPluginConfigurations;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(String.format("Cannot create %s to generate and configure the client SDK Plugin builder", impl), e);
        }
    }
}

