/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.models;

import com.azure.core.util.CoreUtils;
import com.azure.xml.XmlReader;
import com.azure.xml.XmlSerializable;
import com.azure.xml.XmlToken;
import com.azure.xml.XmlWriter;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;

public final class Block
implements XmlSerializable<Block> {
    private String name;
    private long sizeLong;
    private int sizeInt;

    public String getName() {
        return this.name;
    }

    public Block setName(String name) {
        this.name = name;
        return this;
    }

    public long getSizeLong() {
        return this.sizeLong;
    }

    public Block setSizeLong(long sizeLong) {
        this.sizeLong = sizeLong;
        return this;
    }

    @Deprecated
    public int getSize() {
        int returnValue = this.sizeInt;
        return (int)this.sizeLong;
    }

    @Deprecated
    public Block setSize(int sizeInt) {
        this.sizeInt = sizeInt;
        Block returnValue = this;
        return returnValue.setSizeLong(sizeInt);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter) throws XMLStreamException {
        return this.toXml(xmlWriter, null);
    }

    @Override
    public XmlWriter toXml(XmlWriter xmlWriter, String rootElementName) throws XMLStreamException {
        rootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Block" : rootElementName;
        xmlWriter.writeStartElement(rootElementName);
        xmlWriter.writeStringElement("Name", this.name);
        xmlWriter.writeLongElement("Size", this.sizeLong);
        xmlWriter.writeIntElement("SizeInt", this.sizeInt);
        return xmlWriter.writeEndElement();
    }

    public static Block fromXml(XmlReader xmlReader) throws XMLStreamException {
        return Block.fromXml(xmlReader, null);
    }

    public static Block fromXml(XmlReader xmlReader, String rootElementName) throws XMLStreamException {
        String finalRootElementName = CoreUtils.isNullOrEmpty(rootElementName) ? "Block" : rootElementName;
        return xmlReader.readObject(finalRootElementName, reader -> {
            Block deserializedBlock = new Block();
            while (reader.nextElement() != XmlToken.END_ELEMENT) {
                QName elementName = reader.getElementName();
                if ("Name".equals(elementName.getLocalPart())) {
                    deserializedBlock.name = reader.getStringElement();
                    continue;
                }
                if ("Size".equals(elementName.getLocalPart())) {
                    deserializedBlock.sizeLong = reader.getLongElement();
                    continue;
                }
                if ("SizeInt".equals(elementName.getLocalPart())) {
                    deserializedBlock.sizeInt = reader.getIntElement();
                    continue;
                }
                reader.skipElement();
            }
            return deserializedBlock;
        });
    }
}

