/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.specialized;

import com.azure.core.annotation.ReturnType;
import com.azure.core.annotation.ServiceClient;
import com.azure.core.annotation.ServiceMethod;
import com.azure.core.http.HttpPipeline;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.ResponseBase;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.Context;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.BlobServiceVersion;
import com.azure.storage.blob.implementation.models.AppendBlobsCreateHeaders;
import com.azure.storage.blob.implementation.models.EncryptionScope;
import com.azure.storage.blob.implementation.util.ModelHelper;
import com.azure.storage.blob.models.AppendBlobItem;
import com.azure.storage.blob.models.AppendBlobRequestConditions;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobImmutabilityPolicy;
import com.azure.storage.blob.models.BlobRange;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CpkInfo;
import com.azure.storage.blob.models.CustomerProvidedKey;
import com.azure.storage.blob.options.AppendBlobAppendBlockFromUrlOptions;
import com.azure.storage.blob.options.AppendBlobCreateOptions;
import com.azure.storage.blob.options.AppendBlobSealOptions;
import com.azure.storage.blob.specialized.AppendBlobAsyncClient;
import com.azure.storage.blob.specialized.BlobClientBase;
import com.azure.storage.blob.specialized.BlobOutputStream;
import com.azure.storage.blob.specialized.SpecializedBlobClientBuilder;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

@ServiceClient(builder=SpecializedBlobClientBuilder.class)
public final class AppendBlobClient
extends BlobClientBase {
    private static final ClientLogger LOGGER = new ClientLogger(AppendBlobClient.class);
    private final AppendBlobAsyncClient appendBlobAsyncClient;
    @Deprecated
    public static final int MAX_APPEND_BLOCK_BYTES = 0x400000;
    @Deprecated
    public static final int MAX_BLOCKS = 50000;
    static final int MAX_APPEND_BLOCK_BYTES_VERSIONS_2021_12_02_AND_BELOW = 0x400000;
    static final int MAX_APPEND_BLOCK_BYTES_VERSIONS_2022_11_02_AND_ABOVE = 0x6400000;
    static final int MAX_APPEND_BLOCKS = 50000;

    AppendBlobClient(AppendBlobAsyncClient appendBlobAsyncClient) {
        this(appendBlobAsyncClient, appendBlobAsyncClient.getHttpPipeline(), appendBlobAsyncClient.getAccountUrl(), appendBlobAsyncClient.getServiceVersion(), appendBlobAsyncClient.getAccountName(), appendBlobAsyncClient.getContainerName(), appendBlobAsyncClient.getBlobName(), appendBlobAsyncClient.getSnapshotId(), appendBlobAsyncClient.getCustomerProvidedKey(), new EncryptionScope().setEncryptionScope(appendBlobAsyncClient.getEncryptionScope()), appendBlobAsyncClient.getVersionId());
    }

    AppendBlobClient(AppendBlobAsyncClient asyncClient, HttpPipeline pipeline, String url, BlobServiceVersion serviceVersion, String accountName, String containerName, String blobName, String snapshot, CpkInfo customerProvidedKey, EncryptionScope encryptionScope, String versionId) {
        super(asyncClient, pipeline, url, serviceVersion, accountName, containerName, blobName, snapshot, customerProvidedKey, encryptionScope, versionId);
        this.appendBlobAsyncClient = asyncClient;
    }

    @Override
    public AppendBlobClient getEncryptionScopeClient(String encryptionScope) {
        EncryptionScope finalEncryptionScope = null;
        if (encryptionScope != null) {
            finalEncryptionScope = new EncryptionScope().setEncryptionScope(encryptionScope);
        }
        return new AppendBlobClient(this.appendBlobAsyncClient.getEncryptionScopeAsyncClient(encryptionScope), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), this.getCustomerProvidedKey(), finalEncryptionScope, this.getVersionId());
    }

    @Override
    public AppendBlobClient getCustomerProvidedKeyClient(CustomerProvidedKey customerProvidedKey) {
        CpkInfo finalCustomerProvidedKey = null;
        if (customerProvidedKey != null) {
            finalCustomerProvidedKey = new CpkInfo().setEncryptionKey(customerProvidedKey.getKey()).setEncryptionKeySha256(customerProvidedKey.getKeySha256()).setEncryptionAlgorithm(customerProvidedKey.getEncryptionAlgorithm());
        }
        return new AppendBlobClient(this.appendBlobAsyncClient.getCustomerProvidedKeyAsyncClient(customerProvidedKey), this.getHttpPipeline(), this.getAccountUrl(), this.getServiceVersion(), this.getAccountName(), this.getContainerName(), this.getBlobName(), this.getSnapshotId(), finalCustomerProvidedKey, this.encryptionScope, this.getVersionId());
    }

    public BlobOutputStream getBlobOutputStream() {
        return this.getBlobOutputStream(null);
    }

    public BlobOutputStream getBlobOutputStream(boolean overwrite) {
        AppendBlobRequestConditions requestConditions = null;
        if (!overwrite) {
            requestConditions = new AppendBlobRequestConditions().setIfNoneMatch("*");
        } else {
            this.create(true);
        }
        return this.getBlobOutputStream(requestConditions);
    }

    public BlobOutputStream getBlobOutputStream(AppendBlobRequestConditions requestConditions) {
        return BlobOutputStream.appendBlobOutputStream(this.appendBlobAsyncClient, requestConditions);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem create() {
        return this.create(false);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem create(boolean overwrite) {
        BlobRequestConditions blobRequestConditions = new BlobRequestConditions();
        if (!overwrite) {
            blobRequestConditions.setIfNoneMatch("*");
        }
        return this.createWithResponse(null, null, blobRequestConditions, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> createWithResponse(BlobHttpHeaders headers, Map<String, String> metadata, BlobRequestConditions requestConditions, Duration timeout, Context context) {
        return this.createWithResponse(new AppendBlobCreateOptions().setHeaders(headers).setMetadata(metadata).setRequestConditions(requestConditions), timeout, context);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> createWithResponse(AppendBlobCreateOptions options, Duration timeout, Context context) {
        AppendBlobCreateOptions finalOptions = options == null ? new AppendBlobCreateOptions() : options;
        BlobRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new BlobRequestConditions() : finalOptions.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        BlobImmutabilityPolicy immutabilityPolicy = finalOptions.getImmutabilityPolicy() == null ? new BlobImmutabilityPolicy() : finalOptions.getImmutabilityPolicy();
        Callable<ResponseBase> operation = () -> this.azureBlobStorage.getAppendBlobs().createWithResponse(this.containerName, this.blobName, 0L, null, finalOptions.getMetadata(), requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getTagsConditions(), null, ModelHelper.tagsToString(finalOptions.getTags()), immutabilityPolicy.getExpiryTime(), immutabilityPolicy.getPolicyMode(), finalOptions.hasLegalHold(), finalOptions.getHeaders(), this.getCustomerProvidedKey(), this.encryptionScope, finalContext);
        ResponseBase response = StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
        AppendBlobsCreateHeaders hd = (AppendBlobsCreateHeaders)response.getDeserializedHeaders();
        AppendBlobItem item = new AppendBlobItem(hd.getETag(), hd.getLastModified(), hd.getContentMD5(), hd.isXMsRequestServerEncrypted(), hd.getXMsEncryptionKeySha256(), hd.getXMsEncryptionScope(), null, null, hd.getXMsVersionId());
        return new SimpleResponse<AppendBlobItem>(response, item);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem createIfNotExists() {
        return this.createIfNotExistsWithResponse(new AppendBlobCreateOptions(), null, null).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> createIfNotExistsWithResponse(AppendBlobCreateOptions options, Duration timeout, Context context) {
        AppendBlobCreateOptions finalOptions = options == null ? new AppendBlobCreateOptions() : options;
        finalOptions.setRequestConditions(new AppendBlobRequestConditions().setIfNoneMatch("*"));
        try {
            return this.createWithResponse(finalOptions, timeout, context);
        }
        catch (BlobStorageException e) {
            if (e.getStatusCode() == 409) {
                HttpResponse res = e.getResponse();
                return new SimpleResponse<Object>(res.getRequest(), res.getStatusCode(), res.getHeaders(), null);
            }
            throw LOGGER.logExceptionAsError(e);
        }
        catch (RuntimeException e) {
            throw LOGGER.logExceptionAsError(e);
        }
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem appendBlock(InputStream data, long length) {
        return this.appendBlockWithResponse(data, length, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> appendBlockWithResponse(InputStream data, long length, byte[] contentMd5, AppendBlobRequestConditions appendBlobRequestConditions, Duration timeout, Context context) {
        Objects.requireNonNull(data, "'data' cannot be null.");
        Flux<ByteBuffer> fbb = Utility.convertStreamToByteBuffer(data, length, this.getMaxAppendBlockBytes(), true);
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockWithResponse(fbb, length, contentMd5, appendBlobRequestConditions, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public AppendBlobItem appendBlockFromUrl(String sourceUrl, BlobRange sourceRange) {
        return this.appendBlockFromUrlWithResponse(sourceUrl, sourceRange, null, null, null, null, Context.NONE).getValue();
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> appendBlockFromUrlWithResponse(String sourceUrl, BlobRange sourceRange, byte[] sourceContentMd5, AppendBlobRequestConditions destRequestConditions, BlobRequestConditions sourceRequestConditions, Duration timeout, Context context) {
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockFromUrlWithResponse(new AppendBlobAppendBlockFromUrlOptions(sourceUrl).setSourceRange(sourceRange).setSourceContentMd5(sourceContentMd5).setDestinationRequestConditions(destRequestConditions).setSourceRequestConditions(sourceRequestConditions), context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<AppendBlobItem> appendBlockFromUrlWithResponse(AppendBlobAppendBlockFromUrlOptions options, Duration timeout, Context context) {
        Mono<Response<AppendBlobItem>> response = this.appendBlobAsyncClient.appendBlockFromUrlWithResponse(options, context);
        return StorageImplUtils.blockWithOptionalTimeout(response, timeout);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public void seal() {
        this.sealWithResponse(new AppendBlobSealOptions(), null, Context.NONE);
    }

    @ServiceMethod(returns=ReturnType.SINGLE)
    public Response<Void> sealWithResponse(AppendBlobSealOptions options, Duration timeout, Context context) {
        AppendBlobSealOptions finalOptions = options == null ? new AppendBlobSealOptions() : options;
        AppendBlobRequestConditions requestConditions = finalOptions.getRequestConditions() == null ? new AppendBlobRequestConditions() : finalOptions.getRequestConditions();
        Context finalContext = context == null ? Context.NONE : context;
        Callable<Response> operation = () -> this.azureBlobStorage.getAppendBlobs().sealNoCustomHeadersWithResponse(this.containerName, this.blobName, null, null, requestConditions.getLeaseId(), requestConditions.getIfModifiedSince(), requestConditions.getIfUnmodifiedSince(), requestConditions.getIfMatch(), requestConditions.getIfNoneMatch(), requestConditions.getAppendPosition(), finalContext);
        return StorageImplUtils.sendRequest(operation, timeout, BlobStorageException.class);
    }

    public int getMaxAppendBlockBytes() {
        if (this.getServiceVersion().ordinal() < BlobServiceVersion.V2022_11_02.ordinal()) {
            return 0x400000;
        }
        return 0x6400000;
    }

    public int getMaxBlocks() {
        return 50000;
    }
}

