/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.policy;

import com.azure.core.credential.TokenCredential;
import com.azure.core.credential.TokenRequestContext;
import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpPipelineCallContext;
import com.azure.core.http.HttpResponse;
import com.azure.core.http.policy.BearerTokenAuthenticationPolicy;
import com.azure.core.util.CoreUtils;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import reactor.core.publisher.Mono;

public class StorageBearerTokenChallengeAuthorizationPolicy
extends BearerTokenAuthenticationPolicy {
    private static final String DEFAULT_SCOPE = "/.default";
    private static final String BEARER_TOKEN_PREFIX = "Bearer ";
    private String[] scopes;

    public StorageBearerTokenChallengeAuthorizationPolicy(TokenCredential credential, String ... scopes) {
        super(credential, scopes);
        this.scopes = scopes;
    }

    @Override
    public Mono<Void> authorizeRequest(HttpPipelineCallContext context) {
        String[] scopes = this.scopes;
        if ((scopes = this.getScopes(context, scopes)) == null) {
            return Mono.empty();
        }
        return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(scopes));
    }

    @Override
    public void authorizeRequestSync(HttpPipelineCallContext context) {
        String[] scopes = this.scopes;
        if ((scopes = this.getScopes(context, scopes)) != null) {
            this.setAuthorizationHeaderSync(context, new TokenRequestContext().addScopes(scopes));
        }
    }

    @Override
    public Mono<Boolean> authorizeRequestOnChallenge(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        Map<String, String> challenges = this.extractChallengeAttributes(authHeader, BEARER_TOKEN_PREFIX);
        String scope = challenges.get("resource_id");
        if (scope != null) {
            scope = scope + DEFAULT_SCOPE;
            this.scopes = new String[]{scope};
            this.scopes = this.getScopes(context, this.scopes);
            return this.setAuthorizationHeader(context, new TokenRequestContext().addScopes(this.scopes)).thenReturn(true);
        }
        return Mono.just(false);
    }

    @Override
    public boolean authorizeRequestOnChallengeSync(HttpPipelineCallContext context, HttpResponse response) {
        String authHeader = response.getHeaderValue(HttpHeaderName.WWW_AUTHENTICATE);
        Map<String, String> challenges = this.extractChallengeAttributes(authHeader, BEARER_TOKEN_PREFIX);
        String scope = challenges.get("resource_id");
        if (scope != null) {
            scope = scope + DEFAULT_SCOPE;
            this.scopes = new String[]{scope};
            this.scopes = this.getScopes(context, this.scopes);
            this.setAuthorizationHeaderSync(context, new TokenRequestContext().addScopes(this.scopes));
            return true;
        }
        return false;
    }

    String[] getScopes(HttpPipelineCallContext context, String[] scopes) {
        return CoreUtils.clone(scopes);
    }

    Map<String, String> extractChallengeAttributes(String header, String authChallengePrefix) {
        if (!StorageBearerTokenChallengeAuthorizationPolicy.isBearerChallenge(header, authChallengePrefix)) {
            return Collections.emptyMap();
        }
        header = header.toLowerCase(Locale.ROOT).replace(authChallengePrefix.toLowerCase(Locale.ROOT), "");
        String[] attributes = header.split(" ");
        HashMap<String, String> attributeMap = new HashMap<String, String>();
        for (String pair : attributes) {
            String[] keyValue = pair.split("=");
            attributeMap.put(keyValue[0].replaceAll("\"", ""), keyValue[1].replaceAll("\"", ""));
        }
        return attributeMap;
    }

    static boolean isBearerChallenge(String authenticateHeader, String authChallengePrefix) {
        return !CoreUtils.isNullOrEmpty(authenticateHeader) && authenticateHeader.toLowerCase(Locale.ROOT).startsWith(authChallengePrefix.toLowerCase(Locale.ROOT));
    }
}

