/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelPromise;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.DecoderException;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.compression.CompressionOptions;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.DefaultHttpContent;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.DefaultHttpRequest;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.FullHttpRequest;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpContentCompressor;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.iceberg.azure.shaded.io.netty.util.ReferenceCountUtil;

final class SimpleCompressionHandler
extends HttpContentCompressor {
    boolean decoded;
    HttpRequest request;

    SimpleCompressionHandler() {
        super((CompressionOptions[])null);
    }

    @Override
    protected void decode(ChannelHandlerContext ctx, HttpRequest msg, List<Object> out) throws Exception {
        this.decoded = true;
        super.decode(ctx, msg, out);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof ByteBuf) {
            super.write(ctx, new DefaultHttpContent((ByteBuf)msg), promise);
        } else {
            if (!this.decoded && msg instanceof HttpResponse) {
                this.decode(ctx, this.request);
            }
            if (this.decoded && this.request != null && msg instanceof LastHttpContent) {
                this.decoded = false;
                this.request = null;
            }
            super.write(ctx, msg, promise);
        }
    }

    void decode(ChannelHandlerContext ctx, HttpRequest msg) {
        ArrayList<Object> out = new ArrayList<Object>();
        HttpRequest request = msg;
        try {
            if (msg instanceof FullHttpRequest && ((FullHttpRequest)msg).content().refCnt() == 0) {
                request = new DefaultHttpRequest(msg.protocolVersion(), msg.method(), msg.uri(), msg.headers());
            }
            this.decode(ctx, request, (List<Object>)out);
        }
        catch (DecoderException e) {
            throw e;
        }
        catch (Exception e) {
            throw new DecoderException(e);
        }
        finally {
            ReferenceCountUtil.release(request);
            out.clear();
        }
    }
}

