/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.tcp;

import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashMap;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelOption;
import reactor.core.publisher.Mono;
import reactor.netty.DisposableServer;
import reactor.netty.internal.util.MapUtils;
import reactor.netty.tcp.SslProvider;
import reactor.netty.tcp.TcpServer;
import reactor.netty.tcp.TcpServerConfig;

final class TcpServerBind
extends TcpServer {
    static final TcpServerBind INSTANCE = new TcpServerBind();
    final TcpServerConfig config;
    static final int DEFAULT_PORT = 0;

    TcpServerBind() {
        HashMap<ChannelOption<Boolean>, Boolean> childOptions = new HashMap<ChannelOption<Boolean>, Boolean>(MapUtils.calculateInitialCapacity(2));
        childOptions.put(ChannelOption.AUTO_READ, false);
        childOptions.put(ChannelOption.TCP_NODELAY, true);
        this.config = new TcpServerConfig(Collections.singletonMap(ChannelOption.SO_REUSEADDR, true), childOptions, () -> new InetSocketAddress(0));
    }

    TcpServerBind(TcpServerConfig config) {
        this.config = config;
    }

    @Override
    public Mono<? extends DisposableServer> bind() {
        if (this.config.sslProvider != null && this.config.sslProvider.getDefaultConfigurationType() == null) {
            this.config.sslProvider = SslProvider.updateDefaultConfiguration(this.config.sslProvider, SslProvider.DefaultConfigurationType.TCP);
        }
        return super.bind();
    }

    @Override
    public TcpServerConfig configuration() {
        return this.config;
    }

    @Override
    protected TcpServer duplicate() {
        return new TcpServerBind(new TcpServerConfig(this.config));
    }
}

