/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.BaseMetadataTable;
import org.apache.iceberg.BaseTable;
import org.apache.iceberg.DeleteFiles;
import org.apache.iceberg.ExpireSnapshots;
import org.apache.iceberg.HasTableOperations;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.ManageSnapshots;
import org.apache.iceberg.MetadataTableType;
import org.apache.iceberg.MetadataTableUtils;
import org.apache.iceberg.OverwriteFiles;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.PartitionSpecParser;
import org.apache.iceberg.ReplacePartitions;
import org.apache.iceberg.ReplaceSortOrder;
import org.apache.iceberg.RewriteFiles;
import org.apache.iceberg.RewriteManifests;
import org.apache.iceberg.Rollback;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SchemaParser;
import org.apache.iceberg.Snapshot;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.SortOrderParser;
import org.apache.iceberg.StaticTableOperations;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableOperations;
import org.apache.iceberg.TableScan;
import org.apache.iceberg.Transaction;
import org.apache.iceberg.UpdateLocation;
import org.apache.iceberg.UpdatePartitionSpec;
import org.apache.iceberg.UpdateProperties;
import org.apache.iceberg.UpdateSchema;
import org.apache.iceberg.encryption.EncryptionManager;
import org.apache.iceberg.hadoop.HadoopConfigurable;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.LocationProvider;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.util.SerializableMap;

public class SerializableTable
implements Table,
Serializable {
    private final String name;
    private final String location;
    private final String metadataFileLocation;
    private final Map<String, String> properties;
    private final String schemaAsJson;
    private final String specAsJson;
    private final String sortOrderAsJson;
    private final FileIO io;
    private final EncryptionManager encryption;
    private final LocationProvider locationProvider;
    private volatile transient Table lazyTable = null;
    private volatile transient Schema lazySchema = null;
    private volatile transient PartitionSpec lazySpec = null;
    private volatile transient SortOrder lazySortOrder = null;

    private SerializableTable(Table table) {
        this.name = table.name();
        this.location = table.location();
        this.metadataFileLocation = this.metadataFileLocation(table);
        this.properties = SerializableMap.copyOf(table.properties());
        this.schemaAsJson = SchemaParser.toJson(table.schema());
        this.specAsJson = PartitionSpecParser.toJson(table.spec());
        this.sortOrderAsJson = SortOrderParser.toJson(table.sortOrder());
        this.io = this.fileIO(table);
        this.encryption = table.encryption();
        this.locationProvider = table.locationProvider();
    }

    public static Table copyOf(Table table) {
        if (table instanceof BaseMetadataTable) {
            return new SerializableMetadataTable((BaseMetadataTable)table);
        }
        return new SerializableTable(table);
    }

    private String metadataFileLocation(Table table) {
        if (table instanceof HasTableOperations) {
            TableOperations ops = ((HasTableOperations)((Object)table)).operations();
            return ops.current().metadataFileLocation();
        }
        return null;
    }

    private FileIO fileIO(Table table) {
        if (table.io() instanceof HadoopConfigurable) {
            ((HadoopConfigurable)((Object)table.io())).serializeConfWith(conf -> new SerializableConfiguration((Configuration)conf)::get);
        }
        return table.io();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Table lazyTable() {
        if (this.lazyTable == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazyTable == null) {
                    if (this.metadataFileLocation == null) {
                        throw new UnsupportedOperationException("Cannot load metadata: metadata file location is null");
                    }
                    StaticTableOperations ops = new StaticTableOperations(this.metadataFileLocation, this.io, this.locationProvider);
                    this.lazyTable = this.newTable(ops, this.name);
                }
            }
        }
        return this.lazyTable;
    }

    protected Table newTable(TableOperations ops, String tableName) {
        return new BaseTable(ops, tableName);
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public String location() {
        return this.location;
    }

    @Override
    public Map<String, String> properties() {
        return this.properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Schema schema() {
        if (this.lazySchema == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazySchema == null && this.lazyTable == null) {
                    this.lazySchema = SchemaParser.fromJson(this.schemaAsJson);
                } else if (this.lazySchema == null) {
                    this.lazySchema = this.lazyTable.schema();
                }
            }
        }
        return this.lazySchema;
    }

    @Override
    public Map<Integer, Schema> schemas() {
        return this.lazyTable().schemas();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public PartitionSpec spec() {
        if (this.lazySpec == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazySpec == null && this.lazyTable == null) {
                    this.lazySpec = PartitionSpecParser.fromJson(this.schema(), this.specAsJson);
                } else if (this.lazySpec == null) {
                    this.lazySpec = this.lazyTable.spec();
                }
            }
        }
        return this.lazySpec;
    }

    @Override
    public Map<Integer, PartitionSpec> specs() {
        return this.lazyTable().specs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SortOrder sortOrder() {
        if (this.lazySortOrder == null) {
            SerializableTable serializableTable = this;
            synchronized (serializableTable) {
                if (this.lazySortOrder == null && this.lazyTable == null) {
                    this.lazySortOrder = SortOrderParser.fromJson(this.schema(), this.sortOrderAsJson);
                } else if (this.lazySortOrder == null) {
                    this.lazySortOrder = this.lazyTable.sortOrder();
                }
            }
        }
        return this.lazySortOrder;
    }

    @Override
    public Map<Integer, SortOrder> sortOrders() {
        return this.lazyTable().sortOrders();
    }

    @Override
    public FileIO io() {
        return this.io;
    }

    @Override
    public EncryptionManager encryption() {
        return this.encryption;
    }

    @Override
    public LocationProvider locationProvider() {
        return this.locationProvider;
    }

    @Override
    public void refresh() {
        throw new UnsupportedOperationException(this.errorMsg("refresh"));
    }

    @Override
    public TableScan newScan() {
        return this.lazyTable().newScan();
    }

    @Override
    public Snapshot currentSnapshot() {
        return this.lazyTable().currentSnapshot();
    }

    @Override
    public Snapshot snapshot(long snapshotId) {
        return this.lazyTable().snapshot(snapshotId);
    }

    @Override
    public Iterable<Snapshot> snapshots() {
        return this.lazyTable().snapshots();
    }

    @Override
    public List<HistoryEntry> history() {
        return this.lazyTable().history();
    }

    @Override
    public UpdateSchema updateSchema() {
        throw new UnsupportedOperationException(this.errorMsg("updateSchema"));
    }

    @Override
    public UpdatePartitionSpec updateSpec() {
        throw new UnsupportedOperationException(this.errorMsg("updateSpec"));
    }

    @Override
    public UpdateProperties updateProperties() {
        throw new UnsupportedOperationException(this.errorMsg("updateProperties"));
    }

    @Override
    public ReplaceSortOrder replaceSortOrder() {
        throw new UnsupportedOperationException(this.errorMsg("replaceSortOrder"));
    }

    @Override
    public UpdateLocation updateLocation() {
        throw new UnsupportedOperationException(this.errorMsg("updateLocation"));
    }

    @Override
    public AppendFiles newAppend() {
        throw new UnsupportedOperationException(this.errorMsg("newAppend"));
    }

    @Override
    public RewriteFiles newRewrite() {
        throw new UnsupportedOperationException(this.errorMsg("newRewrite"));
    }

    @Override
    public RewriteManifests rewriteManifests() {
        throw new UnsupportedOperationException(this.errorMsg("rewriteManifests"));
    }

    @Override
    public OverwriteFiles newOverwrite() {
        throw new UnsupportedOperationException(this.errorMsg("newOverwrite"));
    }

    @Override
    public RowDelta newRowDelta() {
        throw new UnsupportedOperationException(this.errorMsg("newRowDelta"));
    }

    @Override
    public ReplacePartitions newReplacePartitions() {
        throw new UnsupportedOperationException(this.errorMsg("newReplacePartitions"));
    }

    @Override
    public DeleteFiles newDelete() {
        throw new UnsupportedOperationException(this.errorMsg("newDelete"));
    }

    @Override
    public ExpireSnapshots expireSnapshots() {
        throw new UnsupportedOperationException(this.errorMsg("expireSnapshots"));
    }

    @Override
    public Rollback rollback() {
        throw new UnsupportedOperationException(this.errorMsg("rollback"));
    }

    @Override
    public ManageSnapshots manageSnapshots() {
        throw new UnsupportedOperationException(this.errorMsg("manageSnapshots"));
    }

    @Override
    public Transaction newTransaction() {
        throw new UnsupportedOperationException(this.errorMsg("newTransaction"));
    }

    private String errorMsg(String operation) {
        return String.format("Operation %s is not supported after the table is serialized", operation);
    }

    private static class SerializableConfiguration
    implements Serializable {
        private final Map<String, String> confAsMap;
        private volatile transient Configuration conf = null;

        SerializableConfiguration(Configuration conf) {
            this.confAsMap = Maps.newHashMapWithExpectedSize(conf.size());
            conf.forEach(entry -> this.confAsMap.put((String)entry.getKey(), (String)entry.getValue()));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Configuration get() {
            if (this.conf == null) {
                SerializableConfiguration serializableConfiguration = this;
                synchronized (serializableConfiguration) {
                    if (this.conf == null) {
                        Configuration newConf = new Configuration(false);
                        this.confAsMap.forEach((arg_0, arg_1) -> ((Configuration)newConf).set(arg_0, arg_1));
                        this.conf = newConf;
                    }
                }
            }
            return this.conf;
        }
    }

    private static class SerializableMetadataTable
    extends SerializableTable {
        private final MetadataTableType type;
        private final String baseTableName;

        SerializableMetadataTable(BaseMetadataTable metadataTable) {
            super(metadataTable);
            this.type = metadataTable.metadataTableType();
            this.baseTableName = metadataTable.table().name();
        }

        @Override
        protected Table newTable(TableOperations ops, String tableName) {
            return MetadataTableUtils.createMetadataTableInstance(ops, this.baseTableName, tableName, this.type);
        }
    }
}

